/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades;

import es.mityc.firmaJava.libreria.errores.ClienteError;
import es.mityc.firmaJava.libreria.excepciones.AddXadesException;
import es.mityc.firmaJava.libreria.utilidades.Base64Coder;
import es.mityc.firmaJava.libreria.utilidades.I18n;
import es.mityc.firmaJava.libreria.utilidades.NombreNodo;
import es.mityc.firmaJava.libreria.utilidades.UtilidadFechas;
import es.mityc.firmaJava.libreria.utilidades.UtilidadFicheros;
import es.mityc.firmaJava.libreria.utilidades.UtilidadFirmaElectronica;
import es.mityc.firmaJava.libreria.utilidades.UtilidadTratarNodo;
import es.mityc.firmaJava.libreria.xades.CanonicalizationEnum;
import es.mityc.firmaJava.libreria.xades.DataToSign;
import es.mityc.firmaJava.libreria.xades.EnumFormatoFirma;
import es.mityc.firmaJava.libreria.xades.NombreElementos;
import es.mityc.firmaJava.libreria.xades.RespYCerts;
import es.mityc.firmaJava.libreria.xades.UtilidadXadesX;
import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.CRLRef;
import es.mityc.firmaJava.libreria.xades.elementos.xades.CRLRefs;
import es.mityc.firmaJava.libreria.xades.elementos.xades.CRLValues;
import es.mityc.firmaJava.libreria.xades.elementos.xades.CertificateValues;
import es.mityc.firmaJava.libreria.xades.elementos.xades.DataObjectFormat;
import es.mityc.firmaJava.libreria.xades.elementos.xades.EncapsulatedX509Certificate;
import es.mityc.firmaJava.libreria.xades.elementos.xades.ObjectIdentifier;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SignatureProductionPlace;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SigningTime;
import es.mityc.firmaJava.libreria.xades.errores.BadFormedSignatureException;
import es.mityc.firmaJava.libreria.xades.errores.FirmaXMLError;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import es.mityc.firmaJava.libreria.xades.errores.PolicyException;
import es.mityc.firmaJava.role.IClaimedRole;
import es.mityc.firmaJava.ts.TSCliente;
import es.mityc.firmaJava.ts.TSClienteError;
import es.mityc.javasign.certificate.CertStatusException;
import es.mityc.javasign.certificate.ICertStatus;
import es.mityc.javasign.certificate.IOCSPCertStatus;
import es.mityc.javasign.certificate.IX509CRLCertStatus;
import es.mityc.javasign.exception.SignMITyCException;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.IPKStoreManager;
import es.mityc.javasign.xml.refs.AbstractObjectToSign;
import es.mityc.javasign.xml.refs.InternObjectToSign;
import es.mityc.javasign.xml.refs.ObjectToSign;
import es.mityc.javasign.xml.refs.SignObjectToSign;
import es.mityc.javasign.xml.resolvers.IPrivateData;
import es.mityc.javasign.xml.resolvers.IResourceData;
import es.mityc.javasign.xml.resolvers.MITyCResourceResolver;
import es.mityc.javasign.xml.resolvers.ResolverPrivateData;
import es.mityc.javasign.xml.resolvers.XAdESResourceResolverSpi;
import es.mityc.javasign.xml.transform.Transform;
import es.mityc.javasign.xml.transform.TransformEnveloped;
import es.mityc.javasign.xml.xades.IStoreElements;
import es.mityc.javasign.xml.xades.policy.IFirmaPolicy;
import es.mityc.javasign.xml.xades.policy.PoliciesManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.signature.ObjectContainer;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.IgnoreAllErrorHandler;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FirmaXML {
    private static Log log = LogFactory.getLog(FirmaXML.class);
    private static II18nManager i18n = I18nFactory.getI18nManager((String)"MITyCLibXAdES");
    String profileDirectory = "";
    private String xadesNS = "etsi";
    private String xadesSchema = null;
    private String xmldsigNS = "ds";
    private String servidorTSA = null;
    private String algoritmoTSA = null;
    private ArrayList<String> idNodoSelloTiempo = new ArrayList();
    private String idNodoCertificateRefs = null;
    private String idNodoRevocationRefs = null;
    private String idSigProperties = null;
    private String idSignatureValue = null;
    private ArrayList<ResourceResolverSpi> resolvers;

    public void setTSA(String url) {
        this.servidorTSA = url;
    }

    public void setDefaultNSXmlSig(String namespace) {
        this.xmldsigNS = namespace;
    }

    public void setLocale(String locale) {
        I18n.setLocale(locale, locale.toUpperCase());
    }

    public void addResolver(IPrivateData resolver) {
        this.addResolver(new ResolverPrivateData(resolver));
    }

    public void addResolver(MITyCResourceResolver resolver) {
        if (this.resolvers == null) {
            this.resolvers = new ArrayList();
        }
        this.resolvers.add(resolver);
    }

    public void addResolver(IResourceData resolver) {
        this.addResolver(new XAdESResourceResolverSpi(resolver));
    }

    public void sign2Stream(X509Certificate firmaCertificado, DataToSign xml, IPKStoreManager storeManager, OutputStream salida) throws Exception {
        PrivateKey pk = storeManager.getPrivateKey(firmaCertificado);
        this.signFile(firmaCertificado, xml, pk, salida, storeManager.getProvider(firmaCertificado));
    }

    public boolean signFile(X509Certificate firmaCertificado, DataToSign xml, IPKStoreManager storeManager, String destino, String nombreArchivo) throws Exception {
        PrivateKey pk = storeManager.getPrivateKey(firmaCertificado);
        return this.signFile(firmaCertificado, xml, pk, destino, nombreArchivo, storeManager.getProvider(firmaCertificado));
    }

    private void signFile(X509Certificate certificadoFirma, DataToSign xml, PrivateKey pk, OutputStream salida, Provider provider) throws Exception {
        Object[] res = this.signFile(certificadoFirma, xml, pk, provider);
        if (res[1] != null) {
            throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error43"));
        }
        try {
            XMLUtils.outputDOM((Node)((Document)res[0]), (OutputStream)salida, (boolean)true);
        }
        catch (Throwable t) {
            if (t.getMessage().startsWith("Java heap space")) {
                throw new Exception(I18n.getResource("libreriaxades.firmaxml.error3"));
            }
            throw new Exception(I18n.getResource("libreriaxades.firmaxml.error4"));
        }
    }

    private boolean signFile(X509Certificate certificadoFirma, DataToSign xml, PrivateKey pk, String destino, String nombreArchivo, Provider provider) throws Exception {
        if (destino == null || nombreArchivo == null) {
            throw new Exception(I18n.getResource("libreriaxades.firmaxml.error31"));
        }
        Object[] res = this.signFile(certificadoFirma, xml, pk, provider);
        Document doc = (Document)res[0];
        File fichero = new File(destino + nombreArchivo);
        FileOutputStream f = new FileOutputStream(fichero);
        try {
            XMLUtils.outputDOM((Node)doc, (OutputStream)f, (boolean)true);
        }
        catch (Throwable t) {
            if (t.getMessage().startsWith("Java heap space")) {
                throw new Exception(I18n.getResource("libreriaxades.firmaxml.error3"));
            }
            throw new Exception(I18n.getResource("libreriaxades.firmaxml.error4"));
        }
        finally {
            f.close();
        }
        return true;
    }

    public Object[] signFile(X509Certificate certificadoFirma, DataToSign dataToSign, PrivateKey pk, Provider provider) throws Exception {
        boolean xadesActivo;
        String algDigestXML;
        XAdESSchemas esquemaTemp;
        ArrayList<RespYCerts> respuestas = new ArrayList();
        Init.init();
        Document doc = dataToSign.getDocument();
        if (doc == null) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
            try {
                InputStream is = dataToSign.getInputStream();
                if (is != null) {
                    InputSource isour = new InputSource(is);
                    String encoding = dataToSign.getXMLEncoding();
                    isour.setEncoding(encoding);
                    doc = db.parse(isour);
                } else {
                    doc = db.newDocument();
                }
            }
            catch (IOException ex) {
                throw new Exception(I18n.getResource("libreriaxades.firmaxml.error50"));
            }
        }
        this.xadesSchema = (esquemaTemp = dataToSign.getEsquema()) != null ? esquemaTemp.getSchemaUri() : XAdESSchemas.XAdES_132.getSchemaUri();
        String algTemp = dataToSign.getAlgDigestTSA();
        this.algoritmoTSA = algTemp != null ? algTemp : "SHA-1";
        String string = algDigestXML = dataToSign.getAlgDigestXmlDSig() != null ? dataToSign.getAlgDigestXmlDSig() : "http://www.w3.org/2000/09/xmldsig#sha1";
        if (JCEMapper.translateURItoJCEID((String)algDigestXML) == null) {
            throw new SignMITyCException(i18n.getLocalMessage("i18n.mityc.xades.sign.1", new Object[]{algDigestXML}));
        }
        XMLSignature.setDefaultPrefix((String)"http://www.w3.org/2000/09/xmldsig#", (String)this.xmldsigNS);
        XMLSignature firma = new XMLSignature(doc, dataToSign.getBaseURI(), "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        firma.setId(UtilidadTratarNodo.newID(doc, "Signature"));
        firma.getSignedInfo().setId(UtilidadTratarNodo.newID(doc, "Signature-SignedInfo"));
        if (this.resolvers != null) {
            Iterator<ResourceResolverSpi> it = this.resolvers.iterator();
            while (it.hasNext()) {
                firma.addResourceResolver(it.next());
            }
        }
        firma.setXPathNamespaceContext(this.xmldsigNS, "http://www.w3.org/2000/09/xmldsig#");
        EnumFormatoFirma tipoFirma = dataToSign.getXadesFormat();
        boolean bl = xadesActivo = tipoFirma.compareTo(EnumFormatoFirma.XAdES_BES) >= 0;
        if (xadesActivo) {
            firma.setXPathNamespaceContext(this.xadesNS, this.xadesSchema);
        }
        Element elementoPrincipal = null;
        if (!dataToSign.isEnveloped()) {
            doc.appendChild(firma.getElement());
        } else {
            String nodoRaizXml = dataToSign.getParentSignNode();
            if (nodoRaizXml == null) {
                elementoPrincipal = doc.getDocumentElement();
            } else {
                NodeList nodos = doc.getElementsByTagName(nodoRaizXml);
                if (nodos.getLength() != 0) {
                    elementoPrincipal = (Element)nodos.item(0);
                } else {
                    Element nodo = UtilidadTratarNodo.getElementById(doc, nodoRaizXml);
                    if (nodo != null) {
                        elementoPrincipal = nodo;
                    } else {
                        throw new Exception(I18n.getResource("libreriaxades.firmaxml.error2"));
                    }
                }
            }
            elementoPrincipal.appendChild(firma.getElement());
        }
        this.idSigProperties = UtilidadTratarNodo.newID(doc, "-SignedProperties");
        if (xadesActivo) {
            String tipoEsquema = UtilidadFirmaElectronica.obtenerTipoReference(this.xadesSchema);
            firma.addDocument("#" + firma.getId() + this.idSigProperties, null, algDigestXML, UtilidadTratarNodo.newID(doc, "SignedPropertiesID"), tipoEsquema);
        }
        firma.addKeyInfo(certificadoFirma);
        firma.addKeyInfo(certificadoFirma.getPublicKey());
        String idCert = UtilidadTratarNodo.newID(doc, "Certificate1");
        firma.getKeyInfo().setId(idCert);
        firma.addDocument("#" + idCert, null, algDigestXML, null, null);
        ArrayList<ObjectToSign> objects = dataToSign.getObjects();
        if (objects != null) {
            for (ObjectToSign obj : objects) {
                MITyCResourceResolver resolver;
                AbstractObjectToSign objToSign = obj.getObjectToSign();
                String refId = UtilidadTratarNodo.newID(doc, "Reference-ID-");
                List<ObjectContainer> containers = objToSign.getObjects(doc);
                if (containers != null) {
                    for (ObjectContainer objectContainer : containers) {
                        firma.appendObject(objectContainer);
                    }
                }
                String objId = objToSign.getReferenceURI();
                Transforms trans = null;
                List<Transform> list = objToSign.getTransforms();
                if (dataToSign.isEnveloped() && objId != null) {
                    Element aFirmar = UtilidadTratarNodo.getElementById(doc, objId);
                    if (UtilidadTratarNodo.isChildNode(firma.getElement(), aFirmar)) {
                        list.add(new TransformEnveloped());
                    }
                }
                if (list.size() > 0) {
                    trans = new Transforms(doc);
                    for (Transform transform : list) {
                        trans.addTransform(transform.getAlgorithm(), transform.getExtraData(doc));
                    }
                }
                if ((resolver = objToSign.getResolver()) != null) {
                    firma.addResourceResolver((ResourceResolverSpi)resolver);
                }
                String typeInfo = objToSign.getType();
                firma.addDocument(objId, trans, algDigestXML, refId, typeInfo);
                obj.setId("#" + refId);
            }
        }
        XAdESSchemas schema = null;
        if (xadesActivo) {
            schema = XAdESSchemas.getXAdESSchema(this.xadesSchema);
            if (schema == null) {
                log.error((Object)(I18n.getResource("libreriaxades.firmaxml.error44") + " " + this.xadesSchema));
                throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error45"));
            }
            this.addXades(doc, firma.getId(), certificadoFirma, firma.getElement(), schema, dataToSign, algDigestXML);
            if (dataToSign.hasPolicy()) {
                this.addXadesEPES(firma.getElement(), dataToSign.getPolicyKey());
            } else if (XAdESSchemas.XAdES_111.equals(schema)) {
                this.addXadesEPES(firma.getElement(), "implied");
            }
        }
        try {
            JCEMapper.setProviderSignatureThread((Provider)provider);
            firma.sign((Key)pk);
        }
        catch (Exception ex) {
            log.error((Object)I18n.getResource("libreriaxades.firmaxml.error4"), (Throwable)ex);
            throw ex;
        }
        finally {
            JCEMapper.removeProviderSignatureThread();
        }
        Element elementoValorFirma = null;
        NodeList nodoValorFirma = firma.getElement().getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
        if (nodoValorFirma.getLength() == 0) {
            throw new Exception(I18n.getResource("libreriaxades.firmaxml.error5"));
        }
        elementoValorFirma = (Element)nodoValorFirma.item(0);
        Attr idValorFirma = doc.createAttributeNS(null, "Id");
        this.idSignatureValue = UtilidadTratarNodo.newID(doc, "SignatureValue");
        idValorFirma.setValue(this.idSignatureValue);
        NamedNodeMap elementoIdAtributosValorFirma = elementoValorFirma.getAttributes();
        elementoIdAtributosValorFirma.setNamedItem(idValorFirma);
        boolean xadesT = tipoFirma.compareTo(EnumFormatoFirma.XAdES_T) >= 0;
        log.debug((Object)(I18n.getResource("libreriaxades.firmaxml.debug1") + xadesT));
        if (xadesT) {
            try {
                if (this.servidorTSA == null || this.servidorTSA.trim().equals("")) {
                    throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error6"));
                }
                TSCliente tsCli = null;
                tsCli = new TSCliente(this.servidorTSA, this.algoritmoTSA);
                byte[] byteSignature = UtilidadTratarNodo.obtenerByteNodo(firma.getElement(), "http://www.w3.org/2000/09/xmldsig#", "SignatureValue", CanonicalizationEnum.C14N_OMIT_COMMENTS, 5);
                this.addXadesT(firma.getElement(), firma.getId(), tsCli.generarSelloTiempo(byteSignature));
            }
            catch (AddXadesException e) {
                throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error7") + e.getMessage());
            }
        }
        boolean xadesC = tipoFirma.compareTo(EnumFormatoFirma.XAdES_C) >= 0;
        log.debug((Object)(I18n.getResource("libreriaxades.firmaxml.debug2") + xadesC));
        if (xadesC) {
            try {
                if (xadesT) {
                    if (dataToSign.getCertStatusManager() == null) {
                        throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error53"));
                    }
                } else {
                    throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error24"));
                }
                respuestas = this.convertICertStatus2RespYCerts(dataToSign.getCertStatusManager().getCertChainStatus(certificadoFirma));
                this.addXadesC(firma.getElement(), respuestas, schema, algDigestXML);
            }
            catch (CertStatusException e) {
                throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error56") + e.getMessage());
            }
            catch (AddXadesException e) {
                throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error10") + e.getMessage());
            }
        }
        boolean xadesX = tipoFirma.compareTo(EnumFormatoFirma.XAdES_X) >= 0;
        log.debug((Object)(I18n.getResource("libreriaxades.firmaxml.debug3") + xadesX));
        boolean xadesXL = tipoFirma.compareTo(EnumFormatoFirma.XAdES_XL) == 0;
        log.debug((Object)(I18n.getResource("libreriaxades.firmaxml.debug4") + xadesXL));
        if (xadesC && !xadesXL) {
            try {
                doc = this.addURIXadesC(firma.getElement(), this.saveOCSPFiles(respuestas, dataToSign.getElementsStorer()), dataToSign.getBaseURI());
            }
            catch (FirmaXMLError ex) {
                throw new ClienteError("Error al guardar ficheros de estados de certificados", ex);
            }
        }
        if (xadesX) {
            if (xadesT && xadesC) {
                Element signatureElement = firma.getElement();
                if (!new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "Signature").equals(new NombreNodo(signatureElement.getNamespaceURI(), signatureElement.getLocalName()))) {
                    throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error33") + " " + "Signature");
                }
                Element unsignedSignaturePropertiesElement = null;
                NodeList unsignedSignaturePropertiesNodes = signatureElement.getElementsByTagNameNS(this.xadesSchema, "UnsignedSignatureProperties");
                if (unsignedSignaturePropertiesNodes.getLength() != 1) {
                    log.error((Object)(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "UnsignedSignatureProperties" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + unsignedSignaturePropertiesNodes.getLength()));
                    throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error41"));
                }
                unsignedSignaturePropertiesElement = (Element)unsignedSignaturePropertiesNodes.item(0);
                switch (dataToSign.getXAdESXType()) {
                    case TYPE_2: {
                        this.addXadesX2(unsignedSignaturePropertiesElement);
                        break;
                    }
                    default: {
                        this.addXadesX(unsignedSignaturePropertiesElement);
                        break;
                    }
                }
            } else {
                throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error25"));
            }
        }
        if (xadesXL) {
            if (xadesT && xadesC && xadesX) {
                try {
                    this.addXadesXL(firma.getElement(), respuestas, schema);
                }
                catch (Exception e) {
                    throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error12") + e.getMessage(), e);
                }
            } else {
                throw new ClienteError(I18n.getResource("libreriaxades.firmaxml.error13"));
            }
        }
        Object[] res = new Object[]{doc, xadesC && !xadesXL ? respuestas : null};
        return res;
    }

    private ArrayList<RespYCerts> convertICertStatus2RespYCerts(List<ICertStatus> status) {
        ArrayList<RespYCerts> resps = new ArrayList<RespYCerts>(status != null ? status.size() : 0);
        if (status != null) {
            Iterator<ICertStatus> itStatus = status.iterator();
            while (itStatus.hasNext()) {
                RespYCerts resp = new RespYCerts();
                resp.setCertstatus(itStatus.next());
                resps.add(resp);
            }
        }
        return resps;
    }

    private Document addXades(Document doc, String firmaID, X509Certificate firmaCertificado, Element elementoPrincipalFirma, XAdESSchemas schemaXades, DataToSign dataToSign, String algDigestXML) throws AddXadesException {
        ArrayList<ObjectToSign> objects;
        Iterator<Object> it;
        Element elementoObjeto = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", this.xmldsigNS + ":" + "Object");
        elementoObjeto.setAttributeNS(null, "Id", UtilidadTratarNodo.newID(doc, firmaID + "-Object"));
        elementoPrincipalFirma.appendChild(elementoObjeto);
        System.out.println();
        Element elemntQualifyingProperties = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "QualifyingProperties");
        elementoObjeto.appendChild(elemntQualifyingProperties);
        elemntQualifyingProperties.setAttributeNS(null, "Target", "#" + firmaID);
        Element propiedadesFirmadasElemento = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "SignedProperties");
        elemntQualifyingProperties.appendChild(propiedadesFirmadasElemento);
        propiedadesFirmadasElemento.setAttributeNS(null, "Id", firmaID + this.idSigProperties);
        Element propiedadesFirmadasElementoFirma = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "SignedSignatureProperties");
        propiedadesFirmadasElemento.appendChild(propiedadesFirmadasElementoFirma);
        Date signingDate = dataToSign.getSignDate();
        if (signingDate == null && schemaXades.equals(XAdESSchemas.XAdES_111)) {
            throw new AddXadesException("SigningTime es requerido");
        }
        if (signingDate != null) {
            SigningTime tiempoFirma = new SigningTime(schemaXades, signingDate);
            Element tiempoFirmaElemento = null;
            try {
                tiempoFirmaElemento = tiempoFirma.createElement(doc, this.xadesNS);
            }
            catch (InvalidInfoNodeException e) {
                throw new AddXadesException(e.getMessage(), e);
            }
            propiedadesFirmadasElementoFirma.appendChild(tiempoFirmaElemento);
        }
        Element certificadoFirmaElemento = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "SigningCertificate");
        propiedadesFirmadasElementoFirma.appendChild(certificadoFirmaElemento);
        Element certificadoElemento = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "Cert");
        File signCertFile = dataToSign.getSigningCert();
        if (signCertFile != null) {
            String uri = UtilidadFicheros.relativizeRute(dataToSign.getBaseURI(), signCertFile);
            certificadoElemento.setAttributeNS(null, "URI", uri);
        }
        Element resumenCertificadoElemento = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "CertDigest");
        Element metodoResumenElemento = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", this.xmldsigNS + ":" + "DigestMethod");
        metodoResumenElemento.setAttributeNS(null, "Algorithm", algDigestXML);
        String resumenCertificado = "";
        try {
            MessageDigest resumenCertificadoTemp = UtilidadFirmaElectronica.getMessageDigest(algDigestXML);
            if (resumenCertificadoTemp == null) {
                throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error16"));
            }
            byte[] byteMessageDigest = resumenCertificadoTemp.digest(firmaCertificado.getEncoded());
            resumenCertificado = new String(Base64Coder.encode(byteMessageDigest));
        }
        catch (CertificateEncodingException cee) {
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error17"));
        }
        Element elementDigestValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", this.xmldsigNS + ":" + "DigestValue");
        elementDigestValue.appendChild(doc.createTextNode(resumenCertificado));
        Element elementoEmisorSerial = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "IssuerSerial");
        Element elementoX509EmisorNombre = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", this.xmldsigNS + ":" + "X509IssuerName");
        elementoX509EmisorNombre.appendChild(doc.createTextNode(firmaCertificado.getIssuerX500Principal().getName()));
        Element elementoX509NumeroSerial = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", this.xmldsigNS + ":" + "X509SerialNumber");
        elementoX509NumeroSerial.appendChild(doc.createTextNode(firmaCertificado.getSerialNumber().toString()));
        String[] produc = dataToSign.getProductionPlace();
        if (produc != null) {
            SignatureProductionPlace spp = new SignatureProductionPlace(schemaXades, produc[0], produc[1], produc[2], produc[3]);
            Element productionPlaceElemento = null;
            try {
                productionPlaceElemento = spp.createElement(doc, this.xadesNS);
            }
            catch (InvalidInfoNodeException e) {
                throw new AddXadesException(e.getMessage(), e);
            }
            propiedadesFirmadasElementoFirma.appendChild(productionPlaceElemento);
        }
        resumenCertificadoElemento.appendChild(metodoResumenElemento);
        resumenCertificadoElemento.appendChild(elementDigestValue);
        certificadoElemento.appendChild(resumenCertificadoElemento);
        elementoEmisorSerial.appendChild(elementoX509EmisorNombre);
        elementoEmisorSerial.appendChild(elementoX509NumeroSerial);
        certificadoElemento.appendChild(elementoEmisorSerial);
        certificadoFirmaElemento.appendChild(certificadoElemento);
        ArrayList<IClaimedRole> rolesFirmante = dataToSign.getClaimedRoles();
        if (rolesFirmante != null) {
            Element elementoRoleFirmanteElemento = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "SignerRole");
            propiedadesFirmadasElementoFirma.appendChild(elementoRoleFirmanteElemento);
            Element elementoRolesDemandadosElementos = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "ClaimedRoles");
            elementoRoleFirmanteElemento.appendChild(elementoRolesDemandadosElementos);
            it = rolesFirmante.iterator();
            while (it.hasNext()) {
                Element elementClaimedRoleElement = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "ClaimedRole");
                elementClaimedRoleElement.appendChild(((IClaimedRole)it.next()).createClaimedRoleContent(doc));
                elementoRolesDemandadosElementos.appendChild(elementClaimedRoleElement);
            }
        }
        if ((objects = dataToSign.getObjects()) != null && objects.size() > 0) {
            Element signedDataObjectProperties = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "SignedDataObjectProperties");
            it = objects.iterator();
            DataObjectFormat dof = null;
            ObjectIdentifier oi = null;
            ObjectToSign obj = null;
            String id = null;
            String desc = null;
            String tipoMIME = null;
            URI encoding = null;
            URI referenceId = null;
            while (it.hasNext()) {
                obj = (ObjectToSign)it.next();
                if (obj != null) {
                    id = obj.getId();
                    desc = obj.getDescription();
                    tipoMIME = obj.getMimeType();
                    encoding = obj.getEncoding();
                    oi = obj.getObjectIdentifier();
                }
                if (desc == null && tipoMIME == null && oi == null) continue;
                if (id != null) {
                    try {
                        referenceId = new URI(id);
                    }
                    catch (URISyntaxException e) {
                        log.error((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if (referenceId == null || schemaXades == null) {
                    log.error((Object)"No se puede incluir el objeto DataObjectFormat porque faltan datos");
                    throw new AddXadesException(i18n.getLocalMessage("i18n.mityc.xades.sign.2"));
                }
                dof = new DataObjectFormat(schemaXades, referenceId, desc, tipoMIME);
                if (encoding != null) {
                    dof.setEncoding(encoding);
                }
                if (oi != null) {
                    dof.setObjectIdentifier(oi);
                }
                try {
                    signedDataObjectProperties.appendChild(dof.createElement(doc, this.xadesNS));
                }
                catch (DOMException e) {
                    throw new AddXadesException(e.getMessage(), e);
                }
                catch (InvalidInfoNodeException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new AddXadesException(i18n.getLocalMessage("i18n.mityc.xades.sign.2"));
                }
            }
            if (signedDataObjectProperties.getChildNodes().getLength() > 0) {
                propiedadesFirmadasElemento.appendChild(signedDataObjectProperties);
            }
        }
        return null;
    }

    private void addXadesEPES(Element elementoPrincipalFirma, String confPolicyManager) throws AddXadesException {
        IFirmaPolicy policyManager;
        if (confPolicyManager == null) {
            confPolicyManager = "implied";
        }
        if ((policyManager = PoliciesManager.getInstance().getEscritorPolicy(confPolicyManager)) == null) {
            log.error((Object)(I18n.getResource("libreriaxades.firmaxml.error46") + " " + confPolicyManager));
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error47"));
        }
        XAdESSchemas schema = XAdESSchemas.getXAdESSchema(this.xadesSchema);
        if (schema == null) {
            log.error((Object)(I18n.getResource("libreriaxades.firmaxml.error44") + " " + this.xadesSchema));
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error45"));
        }
        try {
            policyManager.writePolicyNode(elementoPrincipalFirma, this.xmldsigNS, this.xadesNS, schema);
        }
        catch (PolicyException ex) {
            log.error((Object)(I18n.getResource("libreriaxades.firmaxml.error48") + " " + ex.getMessage()), (Throwable)ex);
            throw new AddXadesException(ex.getMessage(), ex);
        }
    }

    private Document addXadesT(Element firma, String firmaID, byte[] selloTiempo) throws AddXadesException {
        Document doc = firma.getOwnerDocument();
        Element elementoPrincipal = null;
        NodeList nodos = firma.getElementsByTagNameNS(this.xadesSchema, "QualifyingProperties");
        if (nodos.getLength() == 0) {
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error18"));
        }
        elementoPrincipal = (Element)nodos.item(0);
        Element propiedadesElementosNoFirmados = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "UnsignedProperties");
        Attr propiedadesNoFirmadasId = doc.createAttributeNS(null, "Id");
        propiedadesNoFirmadasId.setValue(UtilidadTratarNodo.newID(doc, firmaID + "-UnsignedProperties"));
        NamedNodeMap atributosSinFirmarPropiedadesElemento = propiedadesElementosNoFirmados.getAttributes();
        atributosSinFirmarPropiedadesElemento.setNamedItem(propiedadesNoFirmadasId);
        Element propiedadesSinFirmarFirmaElementos = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "UnsignedSignatureProperties");
        NodeList sellosPreexistentes = doc.getElementsByTagNameNS(this.xadesSchema, "SignatureTimeStamp");
        int numSellos = sellosPreexistentes.getLength();
        for (int i = 0; i < numSellos; ++i) {
            Element sello = (Element)sellosPreexistentes.item(i);
            String selloId = sello.getAttribute("Id");
            if (selloId == null) {
                Attr informacionElementoSigTimeStamp = doc.createAttributeNS(null, "Id");
                selloId = UtilidadTratarNodo.newID(doc, "SelloTiempo");
                informacionElementoSigTimeStamp.setValue(selloId);
                sello.getAttributes().setNamedItem(informacionElementoSigTimeStamp);
            }
            this.idNodoSelloTiempo.add(selloId);
        }
        Element tiempoSelloElementoFirma = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "SignatureTimeStamp");
        Attr informacionElementoSigTimeStamp = doc.createAttributeNS(null, "Id");
        String idSelloTiempo = UtilidadTratarNodo.newID(doc, "SelloTiempo");
        informacionElementoSigTimeStamp.setValue(idSelloTiempo);
        this.idNodoSelloTiempo.add(idSelloTiempo);
        tiempoSelloElementoFirma.getAttributes().setNamedItem(informacionElementoSigTimeStamp);
        if ("http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema) || "http://uri.etsi.org/01903/v1.2.2#".equals(this.xadesSchema)) {
            String nombreNodoUri = null;
            String tipoUri = null;
            if ("http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema)) {
                nombreNodoUri = "HashDataInfo";
                tipoUri = "uri";
            } else {
                nombreNodoUri = "Include";
                tipoUri = "URI";
            }
            Element informacionElementoHashDatos = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + nombreNodoUri);
            Attr informacionElementoHashDatosUri = doc.createAttributeNS(null, tipoUri);
            informacionElementoHashDatosUri.setValue("#" + this.idSignatureValue);
            NamedNodeMap informacionAtributosElementoHashDatos = informacionElementoHashDatos.getAttributes();
            informacionAtributosElementoHashDatos.setNamedItem(informacionElementoHashDatosUri);
            tiempoSelloElementoFirma.appendChild(informacionElementoHashDatos);
        }
        if (!"http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema)) {
            Element canonicalizationElemento = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", this.xmldsigNS + ":" + "CanonicalizationMethod");
            Attr canonicalizationAttribute = doc.createAttributeNS(null, "Algorithm");
            canonicalizationAttribute.setValue("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            canonicalizationElemento.getAttributes().setNamedItem(canonicalizationAttribute);
            tiempoSelloElementoFirma.appendChild(canonicalizationElemento);
        }
        Element tiempoSelloEncapsulado = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "EncapsulatedTimeStamp");
        tiempoSelloEncapsulado.appendChild(doc.createTextNode(new String(Base64Coder.encode(selloTiempo))));
        Attr tiempoSelloEncapsuladoId = doc.createAttributeNS(null, "Id");
        String idEncapsulated = UtilidadTratarNodo.newID(doc, "SelloTiempo-Token");
        tiempoSelloEncapsuladoId.setValue(idEncapsulated);
        tiempoSelloEncapsulado.getAttributes().setNamedItem(tiempoSelloEncapsuladoId);
        tiempoSelloElementoFirma.appendChild(tiempoSelloEncapsulado);
        propiedadesSinFirmarFirmaElementos.appendChild(tiempoSelloElementoFirma);
        propiedadesElementosNoFirmados.appendChild(propiedadesSinFirmarFirmaElementos);
        elementoPrincipal.appendChild(propiedadesElementosNoFirmados);
        return doc;
    }

    private Document addXadesC(Element firma, ArrayList<RespYCerts> respuestas, XAdESSchemas schema, String algDigestXML) throws AddXadesException {
        Document doc = firma.getOwnerDocument();
        Element elementoPrincipal = null;
        ArrayList<X509Certificate> certRefs = null;
        String tipoUri = null;
        tipoUri = "http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema) ? "uri" : "URI";
        NodeList nodos = firma.getElementsByTagNameNS(this.xadesSchema, "UnsignedSignatureProperties");
        if (nodos.getLength() == 0) {
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error19"));
        }
        elementoPrincipal = (Element)nodos.item(0);
        Element certificadosElementosFirma = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "CompleteCertificateRefs");
        Element revocacionesElementoFirma = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "CompleteRevocationRefs");
        int size = respuestas.size();
        if (size > 0) {
            certRefs = new ArrayList<X509Certificate>(size);
            for (int x = 0; x < size; ++x) {
                certRefs.add(respuestas.get(x).getCertstatus().getCertificate());
            }
        }
        if (certRefs != null) {
            Attr informacionElementoCertRef = doc.createAttributeNS(null, "Id");
            this.idNodoCertificateRefs = UtilidadTratarNodo.newID(doc, "CompleteCertificateRefs");
            informacionElementoCertRef.setValue(this.idNodoCertificateRefs);
            certificadosElementosFirma.getAttributes().setNamedItem(informacionElementoCertRef);
            Element elementoCertRefs = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "CertRefs");
            certificadosElementosFirma.appendChild(elementoCertRefs);
            int longitud = certRefs.size();
            String idNueva = UtilidadTratarNodo.newID(doc, "CertPath");
            respuestas.get(0).setIdCertificado(idNueva);
            for (int i = 1; i < longitud; ++i) {
                X509Certificate firmaCertificado = (X509Certificate)certRefs.get(i);
                Element elementCertRef = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "Cert");
                Attr uris = doc.createAttributeNS(null, tipoUri);
                idNueva = UtilidadTratarNodo.newID(doc, "CertPath");
                uris.setValue("#" + idNueva);
                respuestas.get(i).setIdCertificado(idNueva);
                NamedNodeMap atributosURI = elementCertRef.getAttributes();
                atributosURI.setNamedItem(uris);
                Element resumenElementoCert = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "CertDigest");
                Element metodoResumenElemento = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", this.xmldsigNS + ":" + "DigestMethod");
                Attr propiedadesFirmaAlgoritmo = doc.createAttributeNS(null, "Algorithm");
                propiedadesFirmaAlgoritmo.setValue(algDigestXML);
                NamedNodeMap cualidadesMetodoResumenElemento = metodoResumenElemento.getAttributes();
                cualidadesMetodoResumenElemento.setNamedItem(propiedadesFirmaAlgoritmo);
                String resumenCertificado = "";
                try {
                    MessageDigest resumenCertificadoTemp = UtilidadFirmaElectronica.getMessageDigest(algDigestXML);
                    if (resumenCertificadoTemp == null) {
                        throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error16"));
                    }
                    byte[] resumenMensajeByte = resumenCertificadoTemp.digest(firmaCertificado.getEncoded());
                    resumenCertificado = new String(Base64Coder.encode(resumenMensajeByte));
                }
                catch (CertificateEncodingException e) {
                    log.error((Object)e);
                    throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error23"));
                }
                Element elementDigestValue = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", this.xmldsigNS + ":" + "DigestValue");
                elementDigestValue.appendChild(doc.createTextNode(resumenCertificado));
                Element elementoEmisorSerial = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "IssuerSerial");
                Element elementoX509EmisorNombre = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", this.xmldsigNS + ":" + "X509IssuerName");
                elementoX509EmisorNombre.appendChild(doc.createTextNode(firmaCertificado.getIssuerX500Principal().getName()));
                Element elementoX509NumeroSerial = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", this.xmldsigNS + ":" + "X509SerialNumber");
                elementoX509NumeroSerial.appendChild(doc.createTextNode(firmaCertificado.getSerialNumber().toString()));
                elementoEmisorSerial.appendChild(elementoX509EmisorNombre);
                elementoEmisorSerial.appendChild(elementoX509NumeroSerial);
                resumenElementoCert.appendChild(metodoResumenElemento);
                resumenElementoCert.appendChild(elementDigestValue);
                elementCertRef.appendChild(resumenElementoCert);
                elementCertRef.appendChild(elementoEmisorSerial);
                elementoCertRefs.appendChild(elementCertRef);
            }
        }
        Element elementOCSPRef = null;
        String tiempoRespuesta = null;
        byte[] mensajeRespuesta = null;
        if (size > 0) {
            Attr informacionElementoCertRef = doc.createAttributeNS(null, "Id");
            this.idNodoRevocationRefs = UtilidadTratarNodo.newID(doc, "CompleteRevocationRefs");
            informacionElementoCertRef.setValue(this.idNodoRevocationRefs);
            revocacionesElementoFirma.getAttributes().setNamedItem(informacionElementoCertRef);
            int nOCSPRefs = 0;
            int nCRLRefs = 0;
            Element elementOCSPRefs = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "OCSPRefs");
            CRLRefs elementCRLRefs = new CRLRefs(schema);
            for (int x = 0; x < size - 1; ++x) {
                RespYCerts respYCert = respuestas.get(x);
                ICertStatus certStatus = respYCert.getCertstatus();
                if (certStatus instanceof IOCSPCertStatus) {
                    Element elementoRespondedorId;
                    ++nOCSPRefs;
                    IOCSPCertStatus respOcsp = (IOCSPCertStatus)certStatus;
                    tiempoRespuesta = UtilidadFechas.formatFechaXML(respOcsp.getResponseDate());
                    IOCSPCertStatus.TYPE_RESPONDER tipoResponder = respOcsp.getResponderType();
                    String valorResponder = respOcsp.getResponderID();
                    mensajeRespuesta = respOcsp.getEncoded();
                    elementOCSPRef = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "OCSPRef");
                    String idNueva = UtilidadTratarNodo.newID(doc, "OCSP");
                    respYCert.setIdRespStatus(idNueva);
                    Element identificadorElementoOCSP = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "OCSPIdentifier");
                    Attr uris = doc.createAttributeNS(null, tipoUri);
                    uris.setValue("#" + idNueva);
                    NamedNodeMap atributosURI = identificadorElementoOCSP.getAttributes();
                    atributosURI.setNamedItem(uris);
                    Element responderFinal = elementoRespondedorId = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "ResponderID");
                    if (!"http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema) && !"http://uri.etsi.org/01903/v1.2.2#".equals(this.xadesSchema)) {
                        Element hijo = null;
                        hijo = tipoResponder.equals((Object)IOCSPCertStatus.TYPE_RESPONDER.BY_NAME) ? doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "ByName") : doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "ByKey");
                        elementoRespondedorId.appendChild(hijo);
                        responderFinal = hijo;
                    }
                    responderFinal.appendChild(doc.createTextNode(valorResponder));
                    Element elementoProdujoEn = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "ProducedAt");
                    elementoProdujoEn.appendChild(doc.createTextNode(tiempoRespuesta));
                    identificadorElementoOCSP.appendChild(elementoRespondedorId);
                    identificadorElementoOCSP.appendChild(elementoProdujoEn);
                    Element valorYResumenElemento = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "DigestAlgAndValue");
                    Element metodoResumenElemento = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", this.xmldsigNS + ":" + "DigestMethod");
                    Attr propiedadesAlgoritmoFirmado = doc.createAttributeNS(null, "Algorithm");
                    propiedadesAlgoritmoFirmado.setValue(algDigestXML);
                    NamedNodeMap atributosMetodoResumenElemento = metodoResumenElemento.getAttributes();
                    atributosMetodoResumenElemento.setNamedItem(propiedadesAlgoritmoFirmado);
                    String digestCertificado = "";
                    MessageDigest resumenCertificadoTemp = UtilidadFirmaElectronica.getMessageDigest(algDigestXML);
                    if (resumenCertificadoTemp == null) {
                        throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error20"));
                    }
                    byte[] resumenMensajeByte = resumenCertificadoTemp.digest(mensajeRespuesta);
                    digestCertificado = new String(Base64Coder.encode(resumenMensajeByte));
                    Element valorResumenElemento = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", this.xmldsigNS + ":" + "DigestValue");
                    valorResumenElemento.appendChild(doc.createTextNode(digestCertificado));
                    valorYResumenElemento.appendChild(metodoResumenElemento);
                    valorYResumenElemento.appendChild(valorResumenElemento);
                    elementOCSPRef.appendChild(identificadorElementoOCSP);
                    elementOCSPRef.appendChild(valorYResumenElemento);
                    elementOCSPRefs.appendChild(elementOCSPRef);
                    continue;
                }
                if (!(certStatus instanceof IX509CRLCertStatus)) continue;
                ++nCRLRefs;
                IX509CRLCertStatus respCRL = (IX509CRLCertStatus)certStatus;
                try {
                    CRLRef crlRef = new CRLRef(schema, algDigestXML, respCRL.getX509CRL());
                    String idNueva = UtilidadTratarNodo.newID(doc, "CRL");
                    crlRef.getCrlIdentifier().setUri("#" + idNueva);
                    respYCert.setIdRespStatus(idNueva);
                    elementCRLRefs.addCRLRef(crlRef);
                    continue;
                }
                catch (InvalidInfoNodeException ex) {
                    throw new AddXadesException("No se pudo construir las referencias a CRLs", ex);
                }
            }
            if (nCRLRefs > 0) {
                try {
                    Element el = elementCRLRefs.createElement(doc, this.xmldsigNS, this.xadesNS);
                    revocacionesElementoFirma.appendChild(el);
                }
                catch (InvalidInfoNodeException ex) {
                    throw new AddXadesException("No se pudo construir las referencias a CRLs", ex);
                }
            }
            if (nOCSPRefs > 0) {
                revocacionesElementoFirma.appendChild(elementOCSPRefs);
            }
        }
        elementoPrincipal.appendChild(certificadosElementosFirma);
        elementoPrincipal.appendChild(revocacionesElementoFirma);
        return doc;
    }

    private Document addXadesX(Element UnsignedSignatureProperties) throws AddXadesException {
        String tipoUri = null;
        String nombreNodoUri = null;
        if ("http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema)) {
            nombreNodoUri = "HashDataInfo";
            tipoUri = "uri";
        } else {
            nombreNodoUri = "Include";
            tipoUri = "URI";
        }
        Document doc = UnsignedSignatureProperties.getOwnerDocument();
        Node padre = UnsignedSignatureProperties.getParentNode();
        for (int i = 0; i < 3; ++i) {
            if (padre == null) {
                throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error33") + " " + "Signature");
            }
            padre = padre.getParentNode();
        }
        Element signatureElement = null;
        if (padre == null || !"Signature".equals(padre.getLocalName())) {
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error33") + " " + "Signature");
        }
        signatureElement = (Element)padre;
        Element sigAndRefsTimeStampElement = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "SigAndRefsTimeStamp");
        Attr informacionElementoSigTimeStamp = doc.createAttributeNS(null, "Id");
        String idSelloTiempo = UtilidadTratarNodo.newID(doc, "SelloTiempo");
        informacionElementoSigTimeStamp.setValue(idSelloTiempo);
        this.idNodoSelloTiempo.add(idSelloTiempo);
        sigAndRefsTimeStampElement.getAttributes().setNamedItem(informacionElementoSigTimeStamp);
        UnsignedSignatureProperties.appendChild(sigAndRefsTimeStampElement);
        ArrayList<Element> elementosSelloX = null;
        try {
            elementosSelloX = UtilidadXadesX.obtenerListadoXADESX1imp(this.xadesSchema, signatureElement, sigAndRefsTimeStampElement);
        }
        catch (BadFormedSignatureException e) {
            throw new AddXadesException(e.getMessage(), e);
        }
        catch (FirmaXMLError e) {
            throw new AddXadesException(e.getMessage(), e);
        }
        if ("http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema) || "http://uri.etsi.org/01903/v1.2.2#".equals(this.xadesSchema)) {
            ArrayList<String> elementosIdSelloX = UtilidadTratarNodo.obtenerIDs(elementosSelloX);
            ArrayList<Element> nodosUriReferencia = new ArrayList<Element>(elementosIdSelloX.size());
            for (String id : elementosIdSelloX) {
                Element uriNode = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + nombreNodoUri);
                Attr includeNodeUri = doc.createAttributeNS(null, tipoUri);
                includeNodeUri.setValue("#" + id);
                NamedNodeMap atributosNodo = uriNode.getAttributes();
                atributosNodo.setNamedItem(includeNodeUri);
                nodosUriReferencia.add(uriNode);
            }
            for (Element includeNode : nodosUriReferencia) {
                sigAndRefsTimeStampElement.appendChild(includeNode);
            }
        }
        byte[] byteData = null;
        try {
            byteData = UtilidadTratarNodo.obtenerByte(elementosSelloX, CanonicalizationEnum.C14N_OMIT_COMMENTS);
        }
        catch (FirmaXMLError e) {
            throw new AddXadesException(e.getMessage(), e);
        }
        TSCliente tsCli = null;
        tsCli = new TSCliente(this.servidorTSA, this.algoritmoTSA);
        try {
            byteData = tsCli.generarSelloTiempo(byteData);
        }
        catch (TSClienteError e) {
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error11") + e.getMessage());
        }
        String hashSelloX = new String(Base64Coder.encode(byteData));
        if (!"http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema)) {
            Element canonicalizationElemento = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", this.xmldsigNS + ":" + "CanonicalizationMethod");
            Attr canonicalizationAttribute = doc.createAttributeNS(null, "Algorithm");
            canonicalizationAttribute.setValue("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            canonicalizationElemento.getAttributes().setNamedItem(canonicalizationAttribute);
            sigAndRefsTimeStampElement.appendChild(canonicalizationElemento);
        }
        Element encapsulatedTimeStampNode = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "EncapsulatedTimeStamp");
        encapsulatedTimeStampNode.appendChild(doc.createTextNode(hashSelloX));
        sigAndRefsTimeStampElement.appendChild(encapsulatedTimeStampNode);
        return doc;
    }

    private Document addXadesX2(Element UnsignedSignatureProperties) throws AddXadesException {
        String tipoUri = null;
        String nombreNodoUri = null;
        if ("http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema)) {
            nombreNodoUri = "HashDataInfo";
            tipoUri = "uri";
        } else {
            nombreNodoUri = "Include";
            tipoUri = "URI";
        }
        Document doc = UnsignedSignatureProperties.getOwnerDocument();
        Node padre = UnsignedSignatureProperties.getParentNode();
        for (int i = 0; i < 3; ++i) {
            if (padre == null) {
                throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error33") + " " + "Signature");
            }
            padre = padre.getParentNode();
        }
        Element signatureElement = null;
        if (padre == null || !"Signature".equals(padre.getLocalName())) {
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error33") + " " + "Signature");
        }
        signatureElement = (Element)padre;
        Element refsOnlyTimeStampElement = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "RefsOnlyTimeStamp");
        Attr informacionElementoSigTimeStamp = doc.createAttributeNS(null, "Id");
        String idSelloTiempo = UtilidadTratarNodo.newID(doc, "SelloTiempo");
        informacionElementoSigTimeStamp.setValue(idSelloTiempo);
        this.idNodoSelloTiempo.add(idSelloTiempo);
        refsOnlyTimeStampElement.getAttributes().setNamedItem(informacionElementoSigTimeStamp);
        UnsignedSignatureProperties.appendChild(refsOnlyTimeStampElement);
        ArrayList<Element> elementosSelloX = null;
        try {
            elementosSelloX = UtilidadXadesX.obtenerListadoXADESX2exp(this.xadesSchema, signatureElement, refsOnlyTimeStampElement);
        }
        catch (BadFormedSignatureException e) {
            throw new AddXadesException(e.getMessage(), e);
        }
        catch (FirmaXMLError e) {
            throw new AddXadesException(e.getMessage(), e);
        }
        if ("http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema) || "http://uri.etsi.org/01903/v1.2.2#".equals(this.xadesSchema)) {
            ArrayList<String> elementosIdSelloX = UtilidadTratarNodo.obtenerIDs(elementosSelloX);
            ArrayList<Element> nodosUriReferencia = new ArrayList<Element>(elementosIdSelloX.size());
            for (String id : elementosIdSelloX) {
                Element uriNode = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + nombreNodoUri);
                Attr includeNodeUri = doc.createAttributeNS(null, tipoUri);
                includeNodeUri.setValue("#" + id);
                NamedNodeMap atributosNodo = uriNode.getAttributes();
                atributosNodo.setNamedItem(includeNodeUri);
                nodosUriReferencia.add(uriNode);
            }
            for (Element includeNode : nodosUriReferencia) {
                refsOnlyTimeStampElement.appendChild(includeNode);
            }
        }
        byte[] byteData = null;
        try {
            byteData = UtilidadTratarNodo.obtenerByte(elementosSelloX, CanonicalizationEnum.C14N_OMIT_COMMENTS);
        }
        catch (FirmaXMLError e) {
            throw new AddXadesException(e.getMessage(), e);
        }
        TSCliente tsCli = null;
        tsCli = new TSCliente(this.servidorTSA, this.algoritmoTSA);
        try {
            byteData = tsCli.generarSelloTiempo(byteData);
        }
        catch (TSClienteError e) {
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error11") + e.getMessage());
        }
        String hashSelloX = new String(Base64Coder.encode(byteData));
        if (!"http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema)) {
            Element canonicalizationElemento = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", this.xmldsigNS + ":" + "CanonicalizationMethod");
            Attr canonicalizationAttribute = doc.createAttributeNS(null, "Algorithm");
            canonicalizationAttribute.setValue("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            canonicalizationElemento.getAttributes().setNamedItem(canonicalizationAttribute);
            refsOnlyTimeStampElement.appendChild(canonicalizationElemento);
        }
        Element encapsulatedTimeStampNode = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "EncapsulatedTimeStamp");
        encapsulatedTimeStampNode.appendChild(doc.createTextNode(hashSelloX));
        refsOnlyTimeStampElement.appendChild(encapsulatedTimeStampNode);
        return doc;
    }

    private Document addXadesXL(Element firma, ArrayList<RespYCerts> respuestas, XAdESSchemas schema) throws AddXadesException {
        Document doc = firma.getOwnerDocument();
        Element elementoPrincipal = null;
        NodeList nodosUnsignedSignatureProperties = firma.getElementsByTagNameNS(schema.getSchemaUri(), "UnsignedSignatureProperties");
        if (nodosUnsignedSignatureProperties.getLength() == 0) {
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error19"));
        }
        elementoPrincipal = (Element)nodosUnsignedSignatureProperties.item(0);
        if (respuestas != null) {
            EncapsulatedX509Certificate encapsulatedX509certificate = null;
            ArrayList<EncapsulatedX509Certificate> certs = new ArrayList<EncapsulatedX509Certificate>();
            Iterator<RespYCerts> itResp = respuestas.iterator();
            boolean hasNext = itResp.hasNext();
            while (hasNext) {
                RespYCerts resp = itResp.next();
                hasNext = itResp.hasNext();
                encapsulatedX509certificate = new EncapsulatedX509Certificate(schema, resp.getIdCertificado());
                try {
                    encapsulatedX509certificate.setX509Certificate(resp.getCertstatus().getCertificate());
                }
                catch (CertificateException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                    throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error23"));
                }
                certs.add(encapsulatedX509certificate);
            }
            CertificateValues certificateValues = new CertificateValues(schema, certs);
            Element certificateValuesElement = null;
            try {
                certificateValuesElement = certificateValues.createElement(doc, this.xadesNS);
            }
            catch (InvalidInfoNodeException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error23"));
            }
            Attr atributoCertVal = doc.createAttributeNS(null, "Id");
            String idCertVal = UtilidadTratarNodo.newID(doc, "CertificateValues");
            atributoCertVal.setValue(idCertVal);
            certificateValuesElement.getAttributes().setNamedItem(atributoCertVal);
            elementoPrincipal.appendChild(certificateValuesElement);
            Element valoresElementosRevocados = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "RevocationValues");
            Element valorElementOCSP = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "OCSPValues");
            CRLValues valorElementoCRL = new CRLValues(schema);
            int nOcspResps = 0;
            int nCRLSResps = 0;
            itResp = respuestas.iterator();
            hasNext = itResp.hasNext();
            while (hasNext) {
                RespYCerts resp = itResp.next();
                hasNext = itResp.hasNext();
                if (!hasNext) continue;
                ICertStatus respStatus = resp.getCertstatus();
                if (respStatus instanceof IOCSPCertStatus) {
                    ++nOcspResps;
                    IOCSPCertStatus respOCSP = (IOCSPCertStatus)respStatus;
                    Element valorElementoEncapsuladoOCSP = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "EncapsulatedOCSPValue");
                    valorElementoEncapsuladoOCSP.appendChild(doc.createTextNode(new String(Base64Coder.encode(respOCSP.getEncoded()))));
                    valorElementoEncapsuladoOCSP.setAttributeNS(null, "Id", resp.getIdRespStatus());
                    valorElementOCSP.appendChild(valorElementoEncapsuladoOCSP);
                    continue;
                }
                if (!(respStatus instanceof IX509CRLCertStatus)) continue;
                ++nCRLSResps;
                IX509CRLCertStatus respCRL = (IX509CRLCertStatus)respStatus;
                try {
                    valorElementoCRL.addCRL(respCRL.getX509CRL(), resp.getIdRespStatus());
                }
                catch (InvalidInfoNodeException ex) {
                    throw new AddXadesException("No se pudo generar nodo EncapsulatedCRLValue", ex);
                }
            }
            if (nCRLSResps > 0) {
                try {
                    Element el = valorElementoCRL.createElement(doc, this.xadesNS);
                    valoresElementosRevocados.appendChild(el);
                }
                catch (InvalidInfoNodeException ex) {
                    throw new AddXadesException("No se pudo generar nodo CRLValues", ex);
                }
            }
            if (nOcspResps > 0) {
                valoresElementosRevocados.appendChild(valorElementOCSP);
            }
            Attr atributoRevVal = doc.createAttributeNS(null, "Id");
            String idRevVal = UtilidadTratarNodo.newID(doc, "RevocationValues");
            atributoRevVal.setValue(idRevVal);
            valoresElementosRevocados.getAttributes().setNamedItem(atributoRevVal);
            elementoPrincipal.appendChild(valoresElementosRevocados);
        }
        return doc;
    }

    private Document addXadesA(Element firma, byte[] selloTiempo, ArrayList<String> inc) throws Exception {
        Document doc = firma.getOwnerDocument();
        ArrayList<Element> UnsignedSignaturePropertiesNodes = UtilidadTratarNodo.obtenerNodos(firma, 4, new NombreNodo(this.xadesSchema, "UnsignedSignatureProperties"));
        Element UnsignedSignaturePropertiesNode = null;
        if (UnsignedSignaturePropertiesNodes.size() != 1) {
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error19"));
        }
        UnsignedSignaturePropertiesNode = UnsignedSignaturePropertiesNodes.get(0);
        Element archiveTimeStamp = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "ArchiveTimeStamp");
        Attr archiveTimeStampId = doc.createAttributeNS(null, "Id");
        archiveTimeStampId.setValue(UtilidadTratarNodo.newID(doc, "ArchiveTimeStamp-"));
        NamedNodeMap archiveTimeStampAttributesElement = archiveTimeStamp.getAttributes();
        archiveTimeStampAttributesElement.setNamedItem(archiveTimeStampId);
        Element encapsulatedTimeStamp = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "EncapsulatedTimeStamp");
        Attr informacionElementoSigTimeStamp = doc.createAttributeNS(null, "Id");
        String idSelloTiempo = UtilidadTratarNodo.newID(doc, "SelloTiempo-Token");
        informacionElementoSigTimeStamp.setValue(idSelloTiempo);
        this.idNodoSelloTiempo.add(idSelloTiempo);
        encapsulatedTimeStamp.getAttributes().setNamedItem(informacionElementoSigTimeStamp);
        Element canonicalizationElemento = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", this.xmldsigNS + ":" + "CanonicalizationMethod");
        Attr canonicalizationAttribute = doc.createAttributeNS(null, "Algorithm");
        canonicalizationAttribute.setValue("http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        canonicalizationElemento.getAttributes().setNamedItem(canonicalizationAttribute);
        archiveTimeStamp.appendChild(canonicalizationElemento);
        encapsulatedTimeStamp.appendChild(doc.createTextNode(new String(Base64Coder.encode(selloTiempo))));
        if (inc != null) {
            Element includeNode = null;
            for (int i = 0; i < inc.size(); ++i) {
                includeNode = doc.createElementNS(this.xadesSchema, this.xadesNS + ":" + "Include");
                includeNode.setAttributeNS(null, "URI", inc.get(i));
                archiveTimeStamp.appendChild(includeNode);
            }
        }
        archiveTimeStamp.appendChild(encapsulatedTimeStamp);
        UnsignedSignaturePropertiesNode.appendChild(archiveTimeStamp);
        return doc;
    }

    public void countersignFile(X509Certificate firmaCertificado, DataToSign xml, IPKStoreManager storeManager, String nodoAFirmarId, String destino, String nombreArchivo) throws Exception {
        PrivateKey pk = storeManager.getPrivateKey(firmaCertificado);
        Document doc = this.countersign(firmaCertificado, xml, nodoAFirmarId, pk, storeManager.getProvider(firmaCertificado));
        File fichero = new File(destino + nombreArchivo);
        FileOutputStream f2 = new FileOutputStream(fichero);
        try {
            XMLUtils.outputDOM((Node)doc, (OutputStream)f2, (boolean)true);
        }
        catch (Throwable t) {
            if (t.getMessage().startsWith("Java heap space")) {
                throw new Exception(I18n.getResource("libreriaxades.firmaxml.error3"));
            }
            throw new Exception(I18n.getResource("libreriaxades.firmaxml.error4"));
        }
        finally {
            f2.close();
        }
    }

    public void countersign2Stream(X509Certificate firmaCertificado, DataToSign xml, IPKStoreManager storeManager, String nodoAFirmarId, OutputStream salida) throws Exception {
        PrivateKey pk = storeManager.getPrivateKey(firmaCertificado);
        Document doc = this.countersign(firmaCertificado, xml, nodoAFirmarId, pk, storeManager.getProvider(firmaCertificado));
        try {
            XMLUtils.outputDOM((Node)doc, (OutputStream)salida, (boolean)true);
        }
        catch (Throwable t) {
            if (t.getMessage().startsWith("Java heap space")) {
                throw new Exception(I18n.getResource("libreriaxades.firmaxml.error3"));
            }
            throw new Exception(I18n.getResource("libreriaxades.firmaxml.error4"));
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document countersign(X509Certificate certificadoFirma, DataToSign xml, String nodoAFirmarId, PrivateKey pk, Provider provider) throws Exception {
        void var17_21;
        ArrayList<Element> listElements;
        Security.addProvider((Provider)new BouncyCastleProvider());
        Document doc = xml.getDocument();
        if (doc == null) {
            try {
                InputStream is = xml.getInputStream();
                if (is != null) {
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    db.setErrorHandler((ErrorHandler)new IgnoreAllErrorHandler());
                    InputSource isour = new InputSource(is);
                    String encoding = xml.getXMLEncoding();
                    isour.setEncoding(encoding);
                    doc = db.parse(isour);
                }
            }
            catch (IOException ex) {
                throw new Exception(I18n.getResource("libreriaxades.firmaxml.error50"));
            }
        }
        Node nodePadreNodoFirmar = null;
        if (nodoAFirmarId != null) {
            Element nodoAFirmar = UtilidadTratarNodo.getElementById(doc, nodoAFirmarId);
            if (nodoAFirmar == null) {
                log.error((Object)(I18n.getResource("libreriaxades.firmaxml.error33") + " " + nodoAFirmarId));
                throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error51"));
            }
            if ("SignatureValue".equals(nodoAFirmar.getLocalName())) {
                this.idSignatureValue = nodoAFirmarId;
                nodePadreNodoFirmar = nodoAFirmar.getParentNode();
            } else {
                if (!"Signature".equals(nodoAFirmar.getLocalName())) {
                    log.error((Object)(I18n.getResource("libreriaxades.firmaxml.error33") + " " + nodoAFirmarId));
                    throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error51"));
                }
                nodePadreNodoFirmar = nodoAFirmar;
            }
        } else {
            NodeList list = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
            if (list.getLength() < 1) {
                log.error((Object)(I18n.getResource("libreriaxades.firmaxml.error33") + " " + nodoAFirmarId));
                throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error51"));
            }
            nodePadreNodoFirmar = list.item(list.getLength() - 1);
        }
        String idSignatureValue = null;
        Element padreNodoFirmar = null;
        if (nodePadreNodoFirmar != null && nodePadreNodoFirmar.getNodeType() == 1) {
            padreNodoFirmar = (Element)nodePadreNodoFirmar;
            listElements = UtilidadTratarNodo.obtenerNodos(padreNodoFirmar, 2, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "SignatureValue"));
            if (listElements.size() != 1) {
                log.error((Object)(I18n.getResource("libreriaxades.firmaxml.error33") + " " + nodoAFirmarId));
                throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error51"));
            }
            idSignatureValue = listElements.get(0).getAttribute("Id");
            if (idSignatureValue == null) {
                log.error((Object)(I18n.getResource("libreriaxades.firmaxml.error33") + " " + nodoAFirmarId));
                throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error51"));
            }
        }
        if ((listElements = UtilidadTratarNodo.obtenerNodos(padreNodoFirmar, 2, "QualifyingProperties")).size() != 1) {
            log.error((Object)(I18n.getResource("libreriaxades.firmaxml.error33") + " " + nodoAFirmarId));
            throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error51"));
        }
        String esquemaOrigen = listElements.get(0).getNamespaceURI();
        NodeList nodosUnsigSigProp = padreNodoFirmar.getElementsByTagNameNS(esquemaOrigen, "UnsignedSignatureProperties");
        Element nodoRaiz = null;
        if (nodosUnsigSigProp != null && nodosUnsigSigProp.getLength() != 0) {
            nodoRaiz = (Element)nodosUnsigSigProp.item(0);
        } else {
            NodeList nodosQualifying = padreNodoFirmar.getElementsByTagNameNS(esquemaOrigen, "QualifyingProperties");
            if (nodosQualifying != null && nodosQualifying.getLength() != 0) {
                Element nodoQualifying = (Element)nodosQualifying.item(0);
                Element unsignedProperties = null;
                if (nodoQualifying.getPrefix() != null) {
                    unsignedProperties = doc.createElementNS(esquemaOrigen, nodoQualifying.getPrefix() + ":" + "UnsignedProperties");
                    nodoRaiz = doc.createElementNS(esquemaOrigen, nodoQualifying.getPrefix() + ":" + "UnsignedSignatureProperties");
                } else {
                    unsignedProperties = doc.createElementNS(esquemaOrigen, "UnsignedProperties");
                    nodoRaiz = doc.createElementNS(esquemaOrigen, "UnsignedSignatureProperties");
                }
                unsignedProperties.appendChild(nodoRaiz);
                nodosQualifying.item(0).appendChild(unsignedProperties);
            } else {
                throw new AddXadesException(I18n.getResource("libreriaxades.firmaxml.error52"));
            }
        }
        Element counterSignature = null;
        counterSignature = nodoRaiz.getPrefix() != null ? doc.createElementNS(esquemaOrigen, nodoRaiz.getPrefix() + ":" + "CounterSignature") : doc.createElementNS(esquemaOrigen, "CounterSignature");
        nodoRaiz.appendChild(counterSignature);
        Attr counterSignatureAttrib = doc.createAttributeNS(null, "Id");
        String counterSignatureId = UtilidadTratarNodo.newID(doc, "CounterSignature-");
        counterSignatureAttrib.setValue(counterSignatureId);
        counterSignature.getAttributes().setNamedItem(counterSignatureAttrib);
        xml.setDocument(doc);
        Object var17_18 = null;
        if (XAdESSchemas.XAdES_132.getSchemaUri().equals(this.xadesSchema)) {
            SignObjectToSign signObjectToSign = new SignObjectToSign(idSignatureValue);
        } else {
            InternObjectToSign internObjectToSign = new InternObjectToSign(idSignatureValue);
        }
        xml.addObject(new ObjectToSign((AbstractObjectToSign)var17_21, null, null, null, null));
        xml.setParentSignNode(counterSignatureId);
        Object[] res = this.signFile(certificadoFirma, xml, pk, provider);
        doc = (Document)res[0];
        counterSignature = UtilidadTratarNodo.getElementById(doc, counterSignatureId);
        counterSignature.removeAttribute("Id");
        return doc;
    }

    public Document addURIXadesC(Element firma, ArrayList<NombreElementos> listaArchivos, String baseUri) throws FirmaXMLError {
        Document doc = firma.getOwnerDocument();
        NodeList completeCertificateRefs = null;
        NodeList completeRevocationRefs = null;
        completeCertificateRefs = firma.getElementsByTagNameNS(this.xadesSchema, "CompleteCertificateRefs");
        completeRevocationRefs = firma.getElementsByTagNameNS(this.xadesSchema, "CompleteRevocationRefs");
        if (completeCertificateRefs.getLength() == 0 || completeRevocationRefs.getLength() == 0) {
            log.error((Object)I18n.getResource("libreriaxades.firmaxml.error29"));
            return doc;
        }
        String tipoUri = null;
        tipoUri = "http://uri.etsi.org/01903/v1.1.1#".equals(this.xadesSchema) ? "uri" : "URI";
        NodeList ocspRefs = null;
        NodeList crlRefs = null;
        try {
            ArrayList<Element> listOcspRefs = UtilidadTratarNodo.obtenerNodos((Element)completeRevocationRefs.item(0), null, new NombreNodo(this.xadesSchema, "OCSPRefs"));
            ArrayList<Element> listCRLRefs = UtilidadTratarNodo.obtenerNodos((Element)completeRevocationRefs.item(0), null, new NombreNodo(this.xadesSchema, "CRLRefs"));
            if (listOcspRefs.size() > 1) {
                throw new FirmaXMLError("hay demasiados elementos ocsprefs");
            }
            if (listCRLRefs.size() > 1) {
                throw new FirmaXMLError("hay demasiados elementos crlrefs");
            }
            if (listOcspRefs.size() > 0) {
                ocspRefs = listOcspRefs.get(0).getChildNodes();
            }
            if (listCRLRefs.size() > 0) {
                crlRefs = listCRLRefs.get(0).getChildNodes();
            }
        }
        catch (FirmaXMLError ex) {
            throw new FirmaXMLError("error obteniendo elementos ocsprefs y crlrefs");
        }
        Iterator<NombreElementos> it = listaArchivos.iterator();
        int indexOCSP = 0;
        int indexCRL = 0;
        while (it.hasNext()) {
            Node el;
            NombreElementos nf = it.next();
            if (!it.hasNext()) continue;
            String nameFile = nf.getNameFileCRLResp();
            if (nameFile == null) {
                nameFile = nf.getNameFileOCSPResp();
                if (nameFile == null) {
                    throw new FirmaXMLError("Fichero de status (OCSP o CRL) sin nombre");
                }
                if (ocspRefs == null || ocspRefs.getLength() <= indexOCSP) {
                    throw new FirmaXMLError("Fichero de status no relacionable con crlref");
                }
                el = ((Element)ocspRefs.item(indexOCSP++)).getElementsByTagNameNS(this.xadesSchema, "OCSPIdentifier").item(0);
            } else {
                if (crlRefs == null || crlRefs.getLength() <= indexCRL) {
                    throw new FirmaXMLError("Fichero de status no relacionable con crlref");
                }
                el = ((Element)crlRefs.item(indexCRL++)).getElementsByTagNameNS(this.xadesSchema, "CRLIdentifier").item(0);
            }
            Attr uri = doc.createAttributeNS(null, tipoUri);
            uri.setValue(nameFile);
            NamedNodeMap nodo = el.getAttributes();
            nodo.setNamedItem(uri);
        }
        Node certRefs = completeCertificateRefs.item(0).getFirstChild();
        if (certRefs != null) {
            NodeList certs = certRefs.getChildNodes();
            int l = certs.getLength();
            if (l != listaArchivos.size() - 1) {
                log.error((Object)I18n.getResource("libreriaxades.firmaxml.error30"));
            }
            for (int i = 0; i < l; ++i) {
                Node certificado = certs.item(i);
                if (certificado == null) continue;
                Attr uri = doc.createAttributeNS(null, tipoUri);
                uri.setValue(listaArchivos.get(i + 1).getNameFileX509Cert());
                NamedNodeMap nodoCertificado = certificado.getAttributes();
                nodoCertificado.setNamedItem(uri);
            }
        }
        return doc;
    }

    public ArrayList<NombreElementos> saveOCSPFiles(ArrayList<RespYCerts> respuesta, IStoreElements storer) {
        ArrayList<NombreElementos> listaArchivos = new ArrayList<NombreElementos>();
        if (respuesta != null && respuesta.size() > 0) {
            int i = 0;
            for (RespYCerts respAndCert : respuesta) {
                X509Certificate certificate = null;
                String certFile = null;
                if (i > 0 && ((certFile = respAndCert.getX509CertFile()) == null || certFile.trim().length() == 0)) {
                    certificate = respAndCert.getCertstatus().getCertificate();
                }
                ICertStatus respCert = null;
                if (i < respuesta.size() - 1) {
                    respCert = respAndCert.getCertstatus();
                }
                String[] names = storer.storeCertAndStatus(certificate, respCert);
                NombreElementos nombreElemento = new NombreElementos();
                if (certFile != null && certFile.trim().length() > 0) {
                    nombreElemento.setNameFileX509Cert(certFile);
                } else {
                    nombreElemento.setNameFileX509Cert(names[0]);
                }
                if (respCert instanceof IOCSPCertStatus) {
                    nombreElemento.setNameFileOCSPResp(names[1]);
                } else if (respCert instanceof IX509CRLCertStatus) {
                    nombreElemento.setNameFileCRLResp(names[1]);
                }
                listaArchivos.add(nombreElemento);
                ++i;
            }
        } else {
            log.error((Object)I18n.getResource("libreriaxades.firmaxml.error27"));
            return null;
        }
        return listaArchivos;
    }
}

