/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos;

import es.mityc.firmaJava.libreria.utilidades.NombreNodo;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractXMLElement {
    protected AbstractXMLElement() {
    }

    protected void addContent(Element element) throws InvalidInfoNodeException {
        throw new UnsupportedOperationException("invalid operation");
    }

    protected Element createElement(Document doc) throws InvalidInfoNodeException {
        throw new UnsupportedOperationException("invalid operation");
    }

    public abstract void load(Element var1) throws InvalidInfoNodeException;

    public abstract boolean equals(Object var1);

    protected void checkElementName(Element element, String namespaceURI, String name) throws InvalidInfoNodeException {
        if (!this.isElementName(element, namespaceURI, name)) {
            throw new InvalidInfoNodeException("Elemento esperado (".concat(namespaceURI).concat(":").concat(name).concat(" Elemento obtenido ") + element.getNamespaceURI() + ":".concat(element.getLocalName()));
        }
    }

    protected boolean isElementName(Element element, String namespaceURI, String name) {
        return element != null && new NombreNodo(namespaceURI, name).equals(new NombreNodo(element.getNamespaceURI(), element.getLocalName()));
    }

    protected boolean isThisNode(Node node) {
        throw new UnsupportedOperationException("invalid operation");
    }

    protected Element nodeToElement(Node node) {
        Element element = null;
        if (node != null && node.getNodeType() == 1) {
            element = (Element)node;
        }
        return element;
    }

    protected static boolean isDecorationNode(Node node) {
        if (node != null) {
            switch (node.getNodeType()) {
                case 3: {
                    String text = node.getNodeValue().trim();
                    text = text.replaceAll("/n", "");
                    text = text.replaceAll("/r", "");
                    text = text.replaceAll(" ", "");
                    return text.equals("");
                }
                case 8: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    protected static Node getFirstNonvoidNode(Node node) {
        Node child;
        for (child = node.getFirstChild(); child != null && AbstractXMLElement.isDecorationNode(child); child = child.getNextSibling()) {
        }
        return child;
    }

    protected static Node getNextNonvoidNode(Node node) {
        Node child;
        for (child = node.getNextSibling(); child != null && AbstractXMLElement.isDecorationNode(child); child = child.getNextSibling()) {
        }
        return child;
    }

    protected static boolean compare(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 != null) {
            return obj1.equals(obj2);
        }
        return false;
    }
}

