/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos;

import es.mityc.firmaJava.libreria.xades.elementos.AbstractXMLElement;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import java.net.URI;
import java.net.URISyntaxException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLDataURIType
extends AbstractXMLElement {
    protected URI value;

    public XMLDataURIType(URI value) {
        this.value = value;
    }

    public void addContent(Element element) throws InvalidInfoNodeException {
        if (this.value == null) {
            throw new InvalidInfoNodeException("Informaci\u00f3n insuficiente para escribir nodo XMLDataURIType");
        }
        element.setTextContent(this.value.toString());
    }

    public boolean equals(Object obj) {
        return obj instanceof XMLDataURIType ? this.value.equals(((XMLDataURIType)obj).value) : obj instanceof URI && this.value.equals(obj);
    }

    public void load(Element element) throws InvalidInfoNodeException {
        URI uri;
        Node node = XMLDataURIType.getFirstNonvoidNode(element);
        if (node.getNodeType() != 3) {
            throw new InvalidInfoNodeException("Nodo xsd:anyURI no contiene CDATA como primer valor");
        }
        String data = node.getNodeValue();
        if (data == null) {
            throw new InvalidInfoNodeException("No hay URI en nodo xsd:anyURI");
        }
        try {
            data = data.replace(" ", "%20");
            uri = new URI(data);
        }
        catch (URISyntaxException ex) {
            throw new InvalidInfoNodeException("URI malformada en nodo xsd:anyURI", ex);
        }
        this.value = uri;
    }

    public URI getValue() {
        return this.value;
    }

    public void setValue(URI value) {
        this.value = value;
    }
}

