/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos.xades;

import es.mityc.firmaJava.libreria.utilidades.UtilidadTratarNodo;
import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.AbstractXADESElement;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SignaturePolicyId;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SignaturePolicyImplied;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignaturePolicyIdentifierType
extends AbstractXADESElement {
    private SignaturePolicyImplied signaturePolicyImplied;
    private SignaturePolicyId signaturePolicyId;

    public SignaturePolicyIdentifierType(XAdESSchemas schema) {
        super(schema);
    }

    public SignaturePolicyIdentifierType(XAdESSchemas schema, boolean isImplied) {
        super(schema);
        if (isImplied) {
            this.signaturePolicyImplied = new SignaturePolicyImplied(schema);
        } else {
            this.signaturePolicyId = new SignaturePolicyId(schema);
        }
    }

    public void addContent(Element element, String namespaceXAdES, String namespaceXDsig) throws InvalidInfoNodeException {
        super.addContent(element, namespaceXAdES, namespaceXDsig);
    }

    protected void addContent(Element element) throws InvalidInfoNodeException {
        if (this.isImplied()) {
            element.appendChild(this.signaturePolicyImplied.createElement(element.getOwnerDocument(), this.namespaceXAdES));
        } else {
            if (this.signaturePolicyId == null) {
                throw new InvalidInfoNodeException("Informaci\u00f3n insuficiente para escribir nodo SignaturePolicyId");
            }
            element.appendChild(this.signaturePolicyId.createElement(element.getOwnerDocument(), this.namespaceXDsig, this.namespaceXAdES));
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof SignaturePolicyIdentifierType) {
            SignaturePolicyIdentifierType spit = (SignaturePolicyIdentifierType)obj;
            if (this.isImplied()) {
                if (spit.isImplied()) {
                    return true;
                }
            } else {
                if (this.signaturePolicyId == null || spit.isImplied()) {
                    return false;
                }
                if (this.signaturePolicyId.equals(spit.signaturePolicyId)) {
                    return true;
                }
            }
        }
        return false;
    }

    public void load(Element element) throws InvalidInfoNodeException {
        SignaturePolicyImplied spi = new SignaturePolicyImplied(this.schema);
        Node node = SignaturePolicyIdentifierType.getFirstNonvoidNode(element);
        if (spi.isThisNode(node)) {
            spi.load((Element)node);
            this.signaturePolicyImplied = spi;
        } else {
            SignaturePolicyId spid = new SignaturePolicyId(this.schema);
            spid.load((Element)node);
            this.signaturePolicyId = spid;
        }
        if (UtilidadTratarNodo.getNextElementSibling(node, true) != null) {
            throw new InvalidInfoNodeException("Nodo SignaturePolicyIdentifierType debe tener un \u00fanico hijo");
        }
    }

    public SignaturePolicyImplied getSignaturePolicyImplied() {
        return this.signaturePolicyImplied;
    }

    public void setSignaturePolicyImplied() {
        this.signaturePolicyImplied = new SignaturePolicyImplied(this.schema);
        this.signaturePolicyId = null;
    }

    public SignaturePolicyId getSignaturePolicyId() {
        return this.signaturePolicyId;
    }

    public void setSignaturePolicyId(SignaturePolicyId signaturePolicyId) {
        this.signaturePolicyId = signaturePolicyId;
        this.signaturePolicyId = null;
    }

    public boolean isImplied() {
        return this.signaturePolicyImplied != null;
    }
}

