/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.xml.resolvers;

import es.mityc.firmaJava.libreria.utilidades.UtilidadFicheros;
import es.mityc.firmaJava.libreria.utilidades.UtilidadTratarNodo;
import es.mityc.firmaJava.libreria.xades.CanonicalizationEnum;
import es.mityc.firmaJava.libreria.xades.errores.FirmaXMLError;
import es.mityc.javasign.xml.refs.AbstractObjectToSign;
import es.mityc.javasign.xml.refs.RelativeDetachedFileToSign;
import es.mityc.javasign.xml.resolvers.MITyCResourceResolver;
import es.mityc.javasign.xml.resolvers.ResourceDataException;
import java.io.File;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.resolver.ResourceResolverException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RelativeResourceResolver
extends MITyCResourceResolver {
    private RelativeDetachedFileToSign internalResolver;

    public RelativeResourceResolver(File file) {
        this.internalResolver = new RelativeDetachedFileToSign(file);
    }

    public AbstractObjectToSign getResolver() {
        return this.internalResolver;
    }

    public boolean engineCanResolve(Attr uri, String BaseURI) {
        if (this.internalResolver == null) {
            return false;
        }
        try {
            return this.internalResolver.getFile().exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    public XMLSignatureInput engineResolve(Attr uri, String BaseURI) throws ResourceResolverException {
        if (this.internalResolver == null) {
            throw new ResourceResolverException("", uri, BaseURI);
        }
        CanonicalizationEnum canonicalization = null;
        try {
            Element nodoCanonicalizationMethod;
            String meth;
            NodeList nodosCanonicalizationMethod = ((Element)uri.getOwnerElement().getParentNode()).getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "CanonicalizationMethod");
            int numNodosCanonicalization = nodosCanonicalizationMethod.getLength();
            if (numNodosCanonicalization > 0 && (canonicalization = CanonicalizationEnum.getCanonicalization(meth = (nodoCanonicalizationMethod = (Element)nodosCanonicalizationMethod.item(0)).getAttribute("Algorithm"))).equals((Object)CanonicalizationEnum.UNKNOWN)) {
                canonicalization = CanonicalizationEnum.C14N_OMIT_COMMENTS;
            }
        }
        catch (Exception e) {
            canonicalization = CanonicalizationEnum.C14N_OMIT_COMMENTS;
        }
        if (uri.getValue().startsWith("#")) {
            try {
                Element el = UtilidadTratarNodo.getElementById(uri.getOwnerDocument(), uri.getValue().substring(1));
                byte[] source = UtilidadTratarNodo.obtenerByte(el, canonicalization);
                if (source == null || source.length <= 0) {
                    throw new ResourceDataException("No se puede obtener el contenido referenciado");
                }
                XMLSignatureInput xsi = new XMLSignatureInput(source);
                return xsi;
            }
            catch (ResourceDataException ex) {
                throw new ResourceResolverException("", uri, BaseURI);
            }
            catch (FirmaXMLError e) {
                throw new ResourceResolverException(e.getMessage(), uri, BaseURI);
            }
        }
        byte[] data = UtilidadFicheros.readFile(this.internalResolver.getFile());
        XMLSignatureInput xsi = new XMLSignatureInput(data);
        return xsi;
    }
}

