/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.DigOutputStream;
import org.bouncycastle.cms.SigOutputStream;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;

public class CMSSignedDataGenerator
extends CMSSignedGenerator {
    private List signerInfs = new ArrayList();

    public CMSSignedDataGenerator() {
    }

    public CMSSignedDataGenerator(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string) throws IllegalArgumentException {
        this.addSigner(privateKey, x509Certificate, this.getEncOID(privateKey, string), string);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2) throws IllegalArgumentException {
        this.doAddSigner(privateKey, CMSSignedDataGenerator.getSignerIdentifier(x509Certificate), string, string2, new DefaultSignedAttributeTableGenerator(), null, null);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string) throws IllegalArgumentException {
        this.addSigner(privateKey, byArray, this.getEncOID(privateKey, string), string);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2) throws IllegalArgumentException {
        this.doAddSigner(privateKey, CMSSignedDataGenerator.getSignerIdentifier(byArray), string, string2, new DefaultSignedAttributeTableGenerator(), null, null);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, AttributeTable attributeTable, AttributeTable attributeTable2) throws IllegalArgumentException {
        this.addSigner(privateKey, x509Certificate, this.getEncOID(privateKey, string), string, attributeTable, attributeTable2);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, AttributeTable attributeTable, AttributeTable attributeTable2) throws IllegalArgumentException {
        this.doAddSigner(privateKey, CMSSignedDataGenerator.getSignerIdentifier(x509Certificate), string, string2, new DefaultSignedAttributeTableGenerator(attributeTable), new SimpleAttributeTableGenerator(attributeTable2), attributeTable);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, AttributeTable attributeTable, AttributeTable attributeTable2) throws IllegalArgumentException {
        this.addSigner(privateKey, byArray, this.getEncOID(privateKey, string), string, attributeTable, attributeTable2);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2, AttributeTable attributeTable, AttributeTable attributeTable2) throws IllegalArgumentException {
        this.doAddSigner(privateKey, CMSSignedDataGenerator.getSignerIdentifier(byArray), string, string2, new DefaultSignedAttributeTableGenerator(attributeTable), new SimpleAttributeTableGenerator(attributeTable2), attributeTable);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2) throws IllegalArgumentException {
        this.addSigner(privateKey, x509Certificate, this.getEncOID(privateKey, string), string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2) throws IllegalArgumentException {
        this.doAddSigner(privateKey, CMSSignedDataGenerator.getSignerIdentifier(x509Certificate), string, string2, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, null);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2) throws IllegalArgumentException {
        this.addSigner(privateKey, byArray, this.getEncOID(privateKey, string), string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2);
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2) throws IllegalArgumentException {
        this.doAddSigner(privateKey, CMSSignedDataGenerator.getSignerIdentifier(byArray), string, string2, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, null);
    }

    private void doAddSigner(PrivateKey privateKey, SignerIdentifier signerIdentifier, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, AttributeTable attributeTable) throws IllegalArgumentException {
        this.signerInfs.add(new SignerInf(privateKey, signerIdentifier, string2, string, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, attributeTable));
    }

    public CMSSignedData generate(CMSProcessable cMSProcessable, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(cMSProcessable, CMSUtils.getProvider(string));
    }

    public CMSSignedData generate(CMSProcessable cMSProcessable, Provider provider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(cMSProcessable, false, provider);
    }

    public CMSSignedData generate(String string, CMSProcessable cMSProcessable, boolean bl, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(string, cMSProcessable, bl, CMSUtils.getProvider(string2), true);
    }

    public CMSSignedData generate(String string, CMSProcessable cMSProcessable, boolean bl, Provider provider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(string, cMSProcessable, bl, provider, true);
    }

    public CMSSignedData generate(String string, CMSProcessable cMSProcessable, boolean bl, String string2, boolean bl2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(string, cMSProcessable, bl, CMSUtils.getProvider(string2), bl2);
    }

    public CMSSignedData generate(String string, CMSProcessable cMSProcessable, boolean bl, Provider provider, boolean bl2) throws NoSuchAlgorithmException, CMSException {
        ByteArrayOutputStream byteArrayOutputStream;
        OutputStream outputStream;
        Object object2;
        SignerInformation signerInformation2;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        this.digests.clear();
        for (SignerInformation signerInformation2 : this._signers) {
            aSN1EncodableVector.add((DEREncodable)CMSSignedHelper.INSTANCE.fixAlgID(signerInformation2.getDigestAlgorithmID()));
            aSN1EncodableVector2.add((DEREncodable)signerInformation2.toSignerInfo());
        }
        boolean bl3 = string == null;
        signerInformation2 = bl3 ? null : new ASN1ObjectIdentifier(string);
        for (Object object2 : this.signerGens) {
            if (cMSProcessable != null) {
                outputStream = ((SignerInfoGenerator)object2).getCalculatingOutputStream();
                try {
                    cMSProcessable.write(outputStream);
                    outputStream.close();
                }
                catch (IOException iOException) {
                    throw new CMSException("data processing exception: " + iOException.getMessage(), iOException);
                }
            }
            outputStream = ((SignerInfoGenerator)object2).generate((ASN1ObjectIdentifier)signerInformation2);
            aSN1EncodableVector.add((DEREncodable)outputStream.getDigestAlgorithm());
            aSN1EncodableVector2.add((DEREncodable)outputStream);
        }
        for (Object object2 : this.signerInfs) {
            try {
                aSN1EncodableVector.add((DEREncodable)((SignerInf)object2).getDigestAlgorithmID());
                aSN1EncodableVector2.add((DEREncodable)((SignerInf)object2).toSignerInfo((DERObjectIdentifier)signerInformation2, cMSProcessable, this.rand, provider, bl2));
            }
            catch (IOException iOException) {
                throw new CMSException("encoding error.", iOException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CMSException("key inappropriate for signature.", invalidKeyException);
            }
            catch (SignatureException signatureException) {
                throw new CMSException("error creating signature.", signatureException);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new CMSException("error creating sid.", certificateEncodingException);
            }
        }
        ASN1Set aSN1Set = null;
        if (this.certs.size() != 0) {
            aSN1Set = CMSUtils.createBerSetFromList(this.certs);
        }
        object2 = null;
        if (this.crls.size() != 0) {
            object2 = CMSUtils.createBerSetFromList(this.crls);
        }
        outputStream = null;
        if (bl) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            if (cMSProcessable != null) {
                try {
                    cMSProcessable.write(byteArrayOutputStream);
                }
                catch (IOException iOException) {
                    throw new CMSException("encapsulation error.", iOException);
                }
            }
            outputStream = new BERConstructedOctetString(byteArrayOutputStream.toByteArray());
        }
        byteArrayOutputStream = new ContentInfo((ASN1ObjectIdentifier)signerInformation2, (DEREncodable)outputStream);
        SignedData signedData = new SignedData((ASN1Set)new DERSet(aSN1EncodableVector), (ContentInfo)byteArrayOutputStream, aSN1Set, (ASN1Set)object2, (ASN1Set)new DERSet(aSN1EncodableVector2));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, (DEREncodable)signedData);
        return new CMSSignedData(cMSProcessable, contentInfo);
    }

    public CMSSignedData generate(CMSProcessable cMSProcessable, boolean bl, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        if (cMSProcessable instanceof CMSTypedData) {
            return this.generate(((CMSTypedData)cMSProcessable).getContentType().getId(), cMSProcessable, bl, string);
        }
        return this.generate(DATA, cMSProcessable, bl, string);
    }

    public CMSSignedData generate(CMSProcessable cMSProcessable, boolean bl, Provider provider) throws NoSuchAlgorithmException, CMSException {
        if (cMSProcessable instanceof CMSTypedData) {
            return this.generate(((CMSTypedData)cMSProcessable).getContentType().getId(), cMSProcessable, bl, provider);
        }
        return this.generate(DATA, cMSProcessable, bl, provider);
    }

    public CMSSignedData generate(CMSTypedData cMSTypedData) throws CMSException {
        return this.generate(cMSTypedData, false);
    }

    public CMSSignedData generate(CMSTypedData cMSTypedData, boolean bl) throws CMSException {
        Object object;
        SignerInfo signerInfo;
        Object object22;
        Object object3;
        SignerInformation signerInformation2;
        if (!this.signerInfs.isEmpty()) {
            throw new IllegalStateException("this method can only be used with SignerInfoGenerator");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        this.digests.clear();
        for (SignerInformation signerInformation2 : this._signers) {
            aSN1EncodableVector.add((DEREncodable)CMSSignedHelper.INSTANCE.fixAlgID(signerInformation2.getDigestAlgorithmID()));
            aSN1EncodableVector2.add((DEREncodable)signerInformation2.toSignerInfo());
        }
        ASN1ObjectIdentifier aSN1ObjectIdentifier = cMSTypedData.getContentType();
        signerInformation2 = null;
        if (bl) {
            object3 = new ByteArrayOutputStream();
            if (cMSTypedData != null) {
                try {
                    cMSTypedData.write((OutputStream)object3);
                }
                catch (IOException iOException) {
                    throw new CMSException("encapsulation error.", iOException);
                }
            }
            signerInformation2 = new BERConstructedOctetString(((ByteArrayOutputStream)object3).toByteArray());
        }
        if (cMSTypedData != null) {
            object3 = null;
            if (bl) {
                object3 = new ByteArrayOutputStream();
            }
            object22 = CMSUtils.attachSignersToOutputStream(this.signerGens, (OutputStream)object3);
            object22 = CMSUtils.getSafeOutputStream((OutputStream)object22);
            try {
                cMSTypedData.write((OutputStream)object22);
                ((OutputStream)object22).close();
            }
            catch (IOException iOException) {
                throw new CMSException("data processing exception: " + iOException.getMessage(), iOException);
            }
            if (bl) {
                signerInformation2 = new BERConstructedOctetString(((ByteArrayOutputStream)object3).toByteArray());
            }
        }
        for (Object object22 : this.signerGens) {
            signerInfo = ((SignerInfoGenerator)object22).generate(aSN1ObjectIdentifier);
            aSN1EncodableVector.add((DEREncodable)signerInfo.getDigestAlgorithm());
            aSN1EncodableVector2.add((DEREncodable)signerInfo);
            object = ((SignerInfoGenerator)object22).getCalculatedDigest();
            if (object == null) continue;
            this.digests.put(signerInfo.getDigestAlgorithm().getAlgorithm().getId(), object);
        }
        object3 = null;
        if (this.certs.size() != 0) {
            object3 = CMSUtils.createBerSetFromList(this.certs);
        }
        object22 = null;
        if (this.crls.size() != 0) {
            object22 = CMSUtils.createBerSetFromList(this.crls);
        }
        signerInfo = new ContentInfo(aSN1ObjectIdentifier, (DEREncodable)signerInformation2);
        object = new SignedData((ASN1Set)new DERSet(aSN1EncodableVector), (ContentInfo)signerInfo, (ASN1Set)object3, (ASN1Set)object22, (ASN1Set)new DERSet(aSN1EncodableVector2));
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.signedData, (DEREncodable)object);
        return new CMSSignedData((CMSProcessable)cMSTypedData, contentInfo);
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signerInformation, Provider provider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(null, (CMSProcessable)new CMSProcessableByteArray(signerInformation.getSignature()), false, provider).getSignerInfos();
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signerInformation, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(null, (CMSProcessable)new CMSProcessableByteArray(signerInformation.getSignature()), false, CMSUtils.getProvider(string)).getSignerInfos();
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signerInformation) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(new CMSProcessableByteArray(null, signerInformation.getSignature()), false).getSignerInfos();
    }

    private class SignerInf {
        final PrivateKey key;
        final SignerIdentifier signerIdentifier;
        final String digestOID;
        final String encOID;
        final CMSAttributeTableGenerator sAttr;
        final CMSAttributeTableGenerator unsAttr;
        final AttributeTable baseSignedTable;

        SignerInf(PrivateKey privateKey, SignerIdentifier signerIdentifier, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, AttributeTable attributeTable) {
            this.key = privateKey;
            this.signerIdentifier = signerIdentifier;
            this.digestOID = string;
            this.encOID = string2;
            this.sAttr = cMSAttributeTableGenerator;
            this.unsAttr = cMSAttributeTableGenerator2;
            this.baseSignedTable = attributeTable;
        }

        AlgorithmIdentifier getDigestAlgorithmID() {
            return new AlgorithmIdentifier(new DERObjectIdentifier(this.digestOID), (DEREncodable)new DERNull());
        }

        SignerInfo toSignerInfo(DERObjectIdentifier dERObjectIdentifier, CMSProcessable cMSProcessable, SecureRandom secureRandom, Provider provider, boolean bl) throws IOException, SignatureException, InvalidKeyException, NoSuchAlgorithmException, CertificateEncodingException, CMSException {
            Object object;
            AttributeTable attributeTable;
            Object object2;
            AlgorithmIdentifier algorithmIdentifier = this.getDigestAlgorithmID();
            String string = CMSSignedHelper.INSTANCE.getDigestAlgName(this.digestOID);
            String string2 = string + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.encOID);
            Signature signature = CMSSignedHelper.INSTANCE.getSignatureInstance(string2, provider);
            MessageDigest messageDigest = CMSSignedHelper.INSTANCE.getDigestInstance(string, provider);
            AlgorithmIdentifier algorithmIdentifier2 = CMSSignedDataGenerator.this.getEncAlgorithmIdentifier(this.encOID, signature);
            if (cMSProcessable != null) {
                cMSProcessable.write(new DigOutputStream(messageDigest));
            }
            byte[] byArray = messageDigest.digest();
            CMSSignedDataGenerator.this.digests.put(this.digestOID, byArray.clone());
            if (bl) {
                object2 = CMSSignedDataGenerator.this.getBaseParameters(dERObjectIdentifier, algorithmIdentifier, byArray);
                attributeTable = this.sAttr != null ? this.sAttr.getAttributes(Collections.unmodifiableMap(object2)) : null;
            } else {
                attributeTable = this.baseSignedTable;
            }
            signature.initSign(this.key, secureRandom);
            object2 = new BufferedOutputStream(new SigOutputStream(signature));
            ASN1Set aSN1Set = null;
            if (attributeTable != null) {
                if (dERObjectIdentifier == null && attributeTable.get((DERObjectIdentifier)CMSAttributes.contentType) != null) {
                    object = attributeTable.toHashtable();
                    ((Hashtable)object).remove(CMSAttributes.contentType);
                    attributeTable = new AttributeTable((Hashtable)object);
                }
                aSN1Set = CMSSignedDataGenerator.this.getAttributeSet(attributeTable);
                new DEROutputStream((OutputStream)object2).writeObject((Object)aSN1Set);
            } else if (cMSProcessable != null) {
                cMSProcessable.write((OutputStream)object2);
            }
            ((OutputStream)object2).close();
            object = signature.sign();
            ASN1Set aSN1Set2 = null;
            if (this.unsAttr != null) {
                Map map = CMSSignedDataGenerator.this.getBaseParameters(dERObjectIdentifier, algorithmIdentifier, byArray);
                map.put("encryptedDigest", object.clone());
                AttributeTable attributeTable2 = this.unsAttr.getAttributes(Collections.unmodifiableMap(map));
                aSN1Set2 = CMSSignedDataGenerator.this.getAttributeSet(attributeTable2);
            }
            return new SignerInfo(this.signerIdentifier, algorithmIdentifier, aSN1Set, algorithmIdentifier2, (ASN1OctetString)new DEROctetString((byte[])object), aSN1Set2);
        }
    }
}

