/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.c14n.InvalidCanonicalizerException;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.HelperNodeList;
import org.apache.xml.security.utils.I18n;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class XMLUtils {
    private static boolean ignoreLineBreaks = false;
    static String dsPrefix;
    static Map namePrefixes;

    private XMLUtils() {
    }

    public static Element getNextElement(Node el) {
        while (el != null && el.getNodeType() != 1) {
            el = el.getNextSibling();
        }
        return (Element)el;
    }

    public static void getSet(Node rootNode, Set result, Node exclude, boolean com) {
        if (exclude != null && XMLUtils.isDescendantOrSelf(exclude, rootNode)) {
            return;
        }
        XMLUtils.getSetRec(rootNode, result, exclude, com);
    }

    static final void getSetRec(Node rootNode, Set result, Node exclude, boolean com) {
        if (rootNode == exclude) {
            return;
        }
        switch (rootNode.getNodeType()) {
            case 1: {
                result.add(rootNode);
                Element el = (Element)rootNode;
                if (el.hasAttributes()) {
                    NamedNodeMap nl = ((Element)rootNode).getAttributes();
                    for (int i = 0; i < nl.getLength(); ++i) {
                        result.add(nl.item(i));
                    }
                }
            }
            case 9: {
                for (Node r = rootNode.getFirstChild(); r != null; r = r.getNextSibling()) {
                    if (r.getNodeType() == 3) {
                        result.add(r);
                        while (r != null && r.getNodeType() == 3) {
                            r = r.getNextSibling();
                        }
                        if (r == null) {
                            return;
                        }
                    }
                    XMLUtils.getSetRec(r, result, exclude, com);
                }
                return;
            }
            case 8: {
                if (com) {
                    result.add(rootNode);
                }
                return;
            }
            case 10: {
                return;
            }
        }
        result.add(rootNode);
    }

    public static void outputDOM(Node contextNode, OutputStream os) {
        XMLUtils.outputDOM(contextNode, os, false);
    }

    public static void outputDOM(Node contextNode, OutputStream os, boolean addPreamble) {
        try {
            if (addPreamble) {
                os.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n".getBytes());
            }
            os.write(Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments").canonicalizeSubtree(contextNode));
        }
        catch (IOException ex) {
        }
        catch (InvalidCanonicalizerException ex) {
            ex.printStackTrace();
        }
        catch (CanonicalizationException ex) {
            ex.printStackTrace();
        }
    }

    public static void outputDOMc14nWithComments(Node contextNode, OutputStream os) {
        try {
            os.write(Canonicalizer.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments").canonicalizeSubtree(contextNode));
        }
        catch (IOException ex) {
        }
        catch (InvalidCanonicalizerException ex) {
        }
        catch (CanonicalizationException canonicalizationException) {
            // empty catch block
        }
    }

    public static String getFullTextChildrenFromElement(Element element) {
        StringBuffer sb = new StringBuffer();
        NodeList children = element.getChildNodes();
        int iMax = children.getLength();
        for (int i = 0; i < iMax; ++i) {
            Node curr = children.item(i);
            if (curr.getNodeType() != 3) continue;
            sb.append(((Text)curr).getData());
        }
        return sb.toString();
    }

    public static Element createElementInSignatureSpace(Document doc, String elementName) {
        if (doc == null) {
            throw new RuntimeException("Document is null");
        }
        if (dsPrefix == null || dsPrefix.length() == 0) {
            return doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", elementName);
        }
        String namePrefix = (String)namePrefixes.get(elementName);
        if (namePrefix == null) {
            StringBuffer tag = new StringBuffer(dsPrefix);
            tag.append(':');
            tag.append(elementName);
            namePrefix = tag.toString();
            namePrefixes.put(elementName, namePrefix);
        }
        return doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", namePrefix);
    }

    public static boolean elementIsInSignatureSpace(Element element, String localName) {
        return ElementProxy.checker.isNamespaceElement(element, localName, "http://www.w3.org/2000/09/xmldsig#");
    }

    public static boolean elementIsInEncryptionSpace(Element element, String localName) {
        return ElementProxy.checker.isNamespaceElement(element, localName, "http://www.w3.org/2001/04/xmlenc#");
    }

    public static Document getOwnerDocument(Node node) {
        if (node.getNodeType() == 9) {
            return (Document)node;
        }
        try {
            return node.getOwnerDocument();
        }
        catch (NullPointerException npe) {
            throw new NullPointerException(I18n.translate("endorsed.jdk1.4.0") + " Original message was \"" + npe.getMessage() + "\"");
        }
    }

    public static Document getOwnerDocument(Set xpathNodeSet) {
        NullPointerException npe = null;
        for (Node node : xpathNodeSet) {
            short nodeType = node.getNodeType();
            if (nodeType == 9) {
                return (Document)node;
            }
            try {
                if (nodeType == 2) {
                    return ((Attr)node).getOwnerElement().getOwnerDocument();
                }
                return node.getOwnerDocument();
            }
            catch (NullPointerException e) {
                npe = e;
            }
        }
        throw new NullPointerException(I18n.translate("endorsed.jdk1.4.0") + " Original message was \"" + (npe == null ? "" : npe.getMessage()) + "\"");
    }

    public static void addReturnToElement(Element e) {
        if (!ignoreLineBreaks) {
            Document doc = e.getOwnerDocument();
            e.appendChild(doc.createTextNode("\n"));
        }
    }

    public static void addReturnToElement(Document doc, HelperNodeList nl) {
        if (!ignoreLineBreaks) {
            nl.appendChild(doc.createTextNode("\n"));
        }
    }

    public static void addReturnBeforeChild(Element e, Node child) {
        if (!ignoreLineBreaks) {
            Document doc = e.getOwnerDocument();
            e.insertBefore(doc.createTextNode("\n"), child);
        }
    }

    public static Set convertNodelistToSet(NodeList xpathNodeSet) {
        if (xpathNodeSet == null) {
            return new HashSet();
        }
        int length = xpathNodeSet.getLength();
        HashSet<Node> set = new HashSet<Node>(length);
        for (int i = 0; i < length; ++i) {
            set.add(xpathNodeSet.item(i));
        }
        return set;
    }

    public static void circumventBug2650(Document doc) {
        Element documentElement = doc.getDocumentElement();
        Attr xmlnsAttr = documentElement.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "xmlns");
        if (xmlnsAttr == null) {
            documentElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "");
        }
        XMLUtils.circumventBug2650internal(doc);
    }

    private static void circumventBug2650internal(Node node) {
        Node parent = null;
        Node sibling = null;
        String namespaceNs = "http://www.w3.org/2000/xmlns/";
        while (true) {
            switch (node.getNodeType()) {
                case 1: {
                    Element element = (Element)node;
                    if (!element.hasChildNodes()) break;
                    if (element.hasAttributes()) {
                        NamedNodeMap attributes = element.getAttributes();
                        int attributesLength = attributes.getLength();
                        for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                            if (child.getNodeType() != 1) continue;
                            Element childElement = (Element)child;
                            for (int i = 0; i < attributesLength; ++i) {
                                Attr currentAttr = (Attr)attributes.item(i);
                                if ("http://www.w3.org/2000/xmlns/" != currentAttr.getNamespaceURI() || childElement.hasAttributeNS("http://www.w3.org/2000/xmlns/", currentAttr.getLocalName())) continue;
                                childElement.setAttributeNS("http://www.w3.org/2000/xmlns/", currentAttr.getName(), currentAttr.getNodeValue());
                            }
                        }
                    }
                }
                case 5: 
                case 9: {
                    parent = node;
                    sibling = node.getFirstChild();
                }
            }
            while (sibling == null && parent != null) {
                sibling = parent.getNextSibling();
                parent = parent.getParentNode();
            }
            if (sibling == null) {
                return;
            }
            node = sibling;
            sibling = node.getNextSibling();
        }
    }

    public static Element selectDsNode(Node sibling, String nodeName, int number) {
        while (sibling != null) {
            if (ElementProxy.checker.isNamespaceElement(sibling, nodeName, "http://www.w3.org/2000/09/xmldsig#")) {
                if (number == 0) {
                    return (Element)sibling;
                }
                --number;
            }
            sibling = sibling.getNextSibling();
        }
        return null;
    }

    public static Element selectXencNode(Node sibling, String nodeName, int number) {
        while (sibling != null) {
            if (ElementProxy.checker.isNamespaceElement(sibling, nodeName, "http://www.w3.org/2001/04/xmlenc#")) {
                if (number == 0) {
                    return (Element)sibling;
                }
                --number;
            }
            sibling = sibling.getNextSibling();
        }
        return null;
    }

    public static Text selectDsNodeText(Node sibling, String nodeName, int number) {
        Node n = XMLUtils.selectDsNode(sibling, nodeName, number);
        if (n == null) {
            return null;
        }
        for (n = n.getFirstChild(); n != null && n.getNodeType() != 3; n = n.getNextSibling()) {
        }
        return (Text)n;
    }

    public static Text selectNodeText(Node sibling, String uri, String nodeName, int number) {
        Node n = XMLUtils.selectNode(sibling, uri, nodeName, number);
        if (n == null) {
            return null;
        }
        for (n = n.getFirstChild(); n != null && n.getNodeType() != 3; n = n.getNextSibling()) {
        }
        return (Text)n;
    }

    public static Element selectNode(Node sibling, String uri, String nodeName, int number) {
        while (sibling != null) {
            if (ElementProxy.checker.isNamespaceElement(sibling, nodeName, uri)) {
                if (number == 0) {
                    return (Element)sibling;
                }
                --number;
            }
            sibling = sibling.getNextSibling();
        }
        return null;
    }

    public static Element[] selectDsNodes(Node sibling, String nodeName) {
        return XMLUtils.selectNodes(sibling, "http://www.w3.org/2000/09/xmldsig#", nodeName);
    }

    public static Element[] selectNodes(Node sibling, String uri, String nodeName) {
        int size = 20;
        Element[] a = new Element[size];
        int curr = 0;
        while (sibling != null) {
            if (ElementProxy.checker.isNamespaceElement(sibling, nodeName, uri)) {
                a[curr++] = (Element)sibling;
                if (size <= curr) {
                    int cursize = size << 2;
                    Element[] cp = new Element[cursize];
                    System.arraycopy(a, 0, cp, 0, size);
                    a = cp;
                    size = cursize;
                }
            }
            sibling = sibling.getNextSibling();
        }
        Element[] af = new Element[curr];
        System.arraycopy(a, 0, af, 0, curr);
        return af;
    }

    public static Set excludeNodeFromSet(Node signatureElement, Set inputSet) {
        HashSet<Node> resultSet = new HashSet<Node>();
        for (Node inputNode : inputSet) {
            if (XMLUtils.isDescendantOrSelf(signatureElement, inputNode)) continue;
            resultSet.add(inputNode);
        }
        return resultSet;
    }

    public static boolean isDescendantOrSelf(Node ctx, Node descendantOrSelf) {
        if (ctx == descendantOrSelf) {
            return true;
        }
        Node parent = descendantOrSelf;
        while (parent != null) {
            if (parent == ctx) {
                return true;
            }
            if (parent.getNodeType() == 2) {
                parent = ((Attr)parent).getOwnerElement();
                continue;
            }
            parent = parent.getParentNode();
        }
        return false;
    }

    public static boolean ignoreLineBreaks() {
        return ignoreLineBreaks;
    }

    static {
        try {
            ignoreLineBreaks = Boolean.getBoolean("org.apache.xml.security.ignoreLineBreaks");
        }
        catch (Exception exception) {
            // empty catch block
        }
        dsPrefix = null;
        namePrefixes = new HashMap();
    }
}

