/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

class PINDialog {
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibAPI");
    private boolean cancelado = false;
    protected JDialog dialog = null;
    protected JLabel lblMessage = null;
    JButton cancelar = null;
    private static final String STR_OK = "OK";
    private static final String STR_CLOSE = "CLOSE";
    private static final int DEFAULT_WIDTH = 300;
    private static final int DEFAULT_HEIGHT = 300;
    private static final String PIN_ICON = "/es/mityc/javasign/pkstore/Images/Candado.png";
    private JPasswordField pass = null;

    public PINDialog(Frame owner) {
        this.dialog = new JDialog(owner, I18N.getLocalMessage("i18n.mityc.api.cert.smartcards.GUI.title"), true);
        this.dialogInit();
    }

    protected void dialogInit() {
        try {
            JPanel distr = new JPanel();
            JButton aceptar = new JButton(I18N.getLocalMessage("i18n.mityc.api.cert.smartcards.GUI.accept"));
            this.cancelar = new JButton(I18N.getLocalMessage("i18n.mityc.api.cert.smartcards.GUI.cancel"));
            aceptar.setActionCommand(STR_OK);
            this.cancelar.setActionCommand(STR_CLOSE);
            this.pass = new JPasswordField(15);
            distr.setLayout(new GridBagLayout());
            this.dialog.setResizable(false);
            this.lblMessage = new JLabel(I18N.getLocalMessage("i18n.mityc.api.cert.smartcards.GUI.pin"));
            this.lblMessage.setHorizontalAlignment(0);
            this.lblMessage.setIcon(new ImageIcon(this.getClass().getResource(PIN_ICON)));
            this.lblMessage.setHorizontalTextPosition(4);
            this.lblMessage.setIconTextGap(10);
            GridBagConstraints g = new GridBagConstraints();
            g.gridx = 0;
            g.gridy = 0;
            g.gridwidth = 4;
            g.insets = new Insets(10, 20, 5, 20);
            distr.add((Component)this.lblMessage, g);
            g.gridx = 0;
            g.gridy = 1;
            g.gridwidth = 4;
            g.fill = 2;
            g.weightx = 1.0;
            g.insets = new Insets(10, 35, 5, 35);
            distr.add((Component)this.pass, g);
            JPanel btnPanel = new JPanel();
            btnPanel.setLayout(new FlowLayout(0, 50, 5));
            btnPanel.add(aceptar);
            btnPanel.add(this.cancelar);
            g = new GridBagConstraints();
            g.gridx = 0;
            g.gridy = 2;
            g.gridwidth = 4;
            g.anchor = 10;
            g.insets = new Insets(15, 0, 15, 0);
            distr.add((Component)btnPanel, g);
            distr.doLayout();
            this.dialog.add(distr);
            this.dialog.setResizable(false);
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.getRootPane().setDefaultButton(aceptar);
            this.dialog.setSize(new Dimension(300, 300));
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.dialog.setLocation(screenSize.width / 2 - this.dialog.getWidth() / 2, screenSize.height / 2 - this.dialog.getHeight() / 2);
            aceptar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals(PINDialog.STR_OK)) {
                        PINDialog.this.dialog.setVisible(false);
                    }
                }
            });
            this.cancelar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals(PINDialog.STR_CLOSE)) {
                        PINDialog.this.cancelado = true;
                        PINDialog.this.dialog.setVisible(false);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setTitle(String newTitle) {
        this.dialog.setTitle(new String(newTitle));
    }

    public void setPINMessage(String newMessage) {
        this.lblMessage.setText(new String(newMessage));
    }

    public void setIcon(ImageIcon icon) {
        this.lblMessage.setIcon(icon);
    }

    public void setCancelBtnVisible(boolean isVisible) {
        this.cancelar.setVisible(isVisible);
        this.pack();
    }

    public void pack() {
        this.dialog.pack();
    }

    public void setVisible(boolean flag) {
        if (flag) {
            this.cancelado = false;
            this.pass.setText("");
        }
        this.dialog.setVisible(flag);
    }

    public char[] getPassword() {
        return this.pass.getPassword();
    }

    public void dispose() {
        this.dialog.dispose();
    }

    public boolean isCancelado() {
        return this.cancelado;
    }

    public int getWidth() {
        if (this.dialog != null) {
            return this.dialog.getWidth();
        }
        return 0;
    }

    public int getHeight() {
        if (this.dialog != null) {
            return this.dialog.getHeight();
        }
        return 0;
    }

    public void setLocation(int x, int y) {
        if (this.dialog != null) {
            this.dialog.setLocation(x, y);
        }
    }
}

