/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.pkcs11;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.pkcs11.IModuleData;
import es.mityc.javasign.pkstore.pkcs11.IProviderData;
import es.mityc.javasign.pkstore.pkcs11.SunP11SlotData;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import sun.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import sun.security.pkcs11.wrapper.CK_TOKEN_INFO;
import sun.security.pkcs11.wrapper.PKCS11;
import sun.security.pkcs11.wrapper.PKCS11Exception;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SunP11ModuleData
implements IModuleData {
    private static final Log LOG = LogFactory.getLog(SunP11ModuleData.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibCert");
    private static final String SUN_CLASS = "sun.security.pkcs11.SunPKCS11";
    private static final String CONFIG_BASE = "name={0}\nlibrary={1}\nslot={2}";
    private static final String KEYSTORE_TYPE = "PKCS11";
    private static final String PKCS11_INSTANTIATE_METHOD = "getInstance";
    private static final String PKCS11_PARAM_JAVA6 = "C_GetFunctionList";
    private static final long[] SLOTS_DEFAULT = new long[0];
    private static final long CKR_DEVICE_ERROR_CODE = 48L;
    private Method pkcs11MethodJ6 = null;
    private Method pkcs11MethodJ5 = null;
    private String name;
    private String lib;
    private ArrayList<IProviderData> providers = new ArrayList();

    public SunP11ModuleData(String provName, String provLib) throws NoSuchProviderException {
        this.name = new String(provName);
        this.lib = new String(provLib);
        this.testSunPKCS11Library();
    }

    private void testSunPKCS11Library() throws NoSuchProviderException {
        try {
            Class<?> prov = Class.forName(SUN_CLASS);
            if (prov == null) {
                throw new NoSuchProviderException(I18N.getLocalMessage("i18n.mityc.cert.p11.16", new Object[]{I18N.getLocalMessage("i18n.mityc.cert.p11.17")}));
            }
        }
        catch (ClassNotFoundException ex) {
            throw new NoSuchProviderException(I18N.getLocalMessage("i18n.mityc.cert.p11.16", new Object[]{ex.getMessage()}));
        }
    }

    public String getLib() {
        return this.lib;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public synchronized List<IProviderData> getProvidersData() {
        return this.providers != null ? (List)this.providers.clone() : new ArrayList();
    }

    private synchronized void adjustProviders(long[] slots) {
        ArrayList<IProviderData> newProviders = new ArrayList<IProviderData>();
        for (int i = 0; i < slots.length; ++i) {
            int pos = this.providers.indexOf(new Long(slots[i]));
            if (pos > -1) {
                newProviders.add(this.providers.get(pos));
                continue;
            }
            try {
                String config = MessageFormat.format(CONFIG_BASE, this.getName() + slots[i], this.getLib(), slots[i]);
                Provider provider = this.getSunPKCS11(new ByteArrayInputStream(config.getBytes()));
                newProviders.add(new SunP11SlotData(provider, slots[i], KEYSTORE_TYPE));
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)I18N.getLocalMessage("i18n.mityc.cert.p11.8", new Object[]{provider.getName(), slots[i]}));
                continue;
            }
            catch (NoSuchProviderException ex) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)I18N.getLocalMessage("i18n.mityc.cert.p11.2", new Object[]{this.getName(), slots[i]}));
                LOG.error((Object)"", (Throwable)ex);
            }
        }
        this.providers = newProviders;
    }

    private Provider getSunPKCS11(InputStream is) throws NoSuchProviderException {
        try {
            Class<?> prov = Class.forName(SUN_CLASS);
            Constructor<?> constructor = prov.getConstructor(InputStream.class);
            return (Provider)constructor.newInstance(is);
        }
        catch (ClassNotFoundException ex) {
            throw new NoSuchProviderException(I18N.getLocalMessage("i18n.mityc.cert.p11.16", new Object[]{ex.getMessage()}));
        }
        catch (SecurityException ex) {
            throw new NoSuchProviderException(I18N.getLocalMessage("i18n.mityc.cert.p11.16", new Object[]{ex.getMessage()}));
        }
        catch (NoSuchMethodException ex) {
            throw new NoSuchProviderException(I18N.getLocalMessage("i18n.mityc.cert.p11.16", new Object[]{ex.getMessage()}));
        }
        catch (IllegalArgumentException ex) {
            throw new NoSuchProviderException(I18N.getLocalMessage("i18n.mityc.cert.p11.16", new Object[]{ex.getMessage()}));
        }
        catch (InstantiationException ex) {
            throw new NoSuchProviderException(I18N.getLocalMessage("i18n.mityc.cert.p11.16", new Object[]{ex.getMessage()}));
        }
        catch (IllegalAccessException ex) {
            throw new NoSuchProviderException(I18N.getLocalMessage("i18n.mityc.cert.p11.16", new Object[]{ex.getMessage()}));
        }
        catch (InvocationTargetException ex) {
            throw new NoSuchProviderException(I18N.getLocalMessage("i18n.mityc.cert.p11.16", new Object[]{ex.getMessage()}));
        }
    }

    @Override
    public void updateModule() {
        long[] slots = this.getSlots();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)I18N.getLocalMessage("i18n.mityc.cert.p11.11", new Object[]{slots.length}));
        }
        this.adjustProviders(slots);
    }

    private void logSlots(long[] slots, String message) {
        StringBuffer sb = new StringBuffer("");
        if (slots != null && slots.length > 0) {
            for (int i = 0; i < slots.length; ++i) {
                sb.append(slots[i]);
                if (i >= slots.length - 1) continue;
                sb.append(", ");
            }
        } else {
            sb.append(I18N.getLocalMessage("i18n.mityc.cert.p11.13"));
        }
        LOG.trace((Object)I18N.getLocalMessage("i18n.mityc.cert.p11.12", new Object[]{message, slots != null ? slots.length : 0, sb.toString()}));
    }

    private long[] filterSlots(PKCS11 pkcs11, long[] slots) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (slots != null) {
            for (int i = 0; i < slots.length; ++i) {
                try {
                    CK_TOKEN_INFO tokenInfo = pkcs11.C_GetTokenInfo(slots[i]);
                    list.add(new Long(slots[i]));
                    continue;
                }
                catch (PKCS11Exception ex) {
                    if (ex.getErrorCode() != 48L) continue;
                    try {
                        CK_TOKEN_INFO tokenInfo = pkcs11.C_GetTokenInfo(slots[i]);
                        list.add(new Long(slots[i]));
                        continue;
                    }
                    catch (PKCS11Exception ex1) {
                        // empty catch block
                    }
                }
            }
        }
        long[] newSlots = new long[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            newSlots[i] = (Long)list.get(i);
        }
        return newSlots;
    }

    private long[] getSlots() {
        long[] slots = null;
        CK_C_INITIALIZE_ARGS ckCInitializeArgs = new CK_C_INITIALIZE_ARGS();
        ckCInitializeArgs.flags = 2L;
        PKCS11 pkcs11 = this.getPKSC11(this.getLib(), ckCInitializeArgs);
        if (pkcs11 != null) {
            try {
                slots = pkcs11.C_GetSlotList(true);
                if (LOG.isTraceEnabled()) {
                    this.logSlots(slots, I18N.getLocalMessage("i18n.mityc.cert.p11.14"));
                }
                slots = this.filterSlots(pkcs11, slots);
                if (LOG.isTraceEnabled()) {
                    this.logSlots(slots, I18N.getLocalMessage("i18n.mityc.cert.p11.15", new Object[]{this.getName()}));
                }
            }
            catch (PKCS11Exception ex) {
                // empty catch block
            }
        }
        return slots != null ? slots : SLOTS_DEFAULT;
    }

    private PKCS11 getPKSC11(String libname, CK_C_INITIALIZE_ARGS args) {
        PKCS11 pkcs11;
        block22: {
            Object res;
            block21: {
                pkcs11 = null;
                try {
                    if (this.pkcs11MethodJ6 == null && this.pkcs11MethodJ5 == null) {
                        this.pkcs11MethodJ6 = PKCS11.class.getMethod(PKCS11_INSTANTIATE_METHOD, String.class, String.class, CK_C_INITIALIZE_ARGS.class, Boolean.TYPE);
                    }
                    if (this.pkcs11MethodJ6 != null && (res = this.pkcs11MethodJ6.invoke(null, libname, PKCS11_PARAM_JAVA6, args, false)) != null && res instanceof PKCS11) {
                        pkcs11 = (PKCS11)res;
                    }
                }
                catch (NoSuchMethodException ex) {
                    if (LOG.isTraceEnabled()) {
                        LOG.error((Object)"", (Throwable)ex);
                    }
                }
                catch (InvocationTargetException ex) {
                    if (LOG.isTraceEnabled()) {
                        LOG.error((Object)"", (Throwable)ex);
                    }
                }
                catch (IllegalAccessException ex) {
                    if (LOG.isTraceEnabled()) {
                        LOG.error((Object)"", (Throwable)ex);
                    }
                }
                catch (IllegalArgumentException ex) {
                    if (!LOG.isTraceEnabled()) break block21;
                    LOG.error((Object)"", (Throwable)ex);
                }
            }
            if (pkcs11 == null) {
                try {
                    if (this.pkcs11MethodJ5 == null) {
                        this.pkcs11MethodJ5 = PKCS11.class.getMethod(PKCS11_INSTANTIATE_METHOD, String.class, CK_C_INITIALIZE_ARGS.class, Boolean.TYPE);
                    }
                    if (this.pkcs11MethodJ5 != null && (res = this.pkcs11MethodJ5.invoke(null, libname, args, false)) != null && res instanceof PKCS11) {
                        pkcs11 = (PKCS11)res;
                    }
                }
                catch (NoSuchMethodException ex) {
                    if (LOG.isTraceEnabled()) {
                        LOG.error((Object)"", (Throwable)ex);
                    }
                }
                catch (InvocationTargetException ex) {
                    if (LOG.isTraceEnabled()) {
                        LOG.error((Object)"", (Throwable)ex);
                    }
                }
                catch (IllegalAccessException ex) {
                    if (LOG.isTraceEnabled()) {
                        LOG.error((Object)"", (Throwable)ex);
                    }
                }
                catch (IllegalArgumentException ex) {
                    if (!LOG.isTraceEnabled()) break block22;
                    LOG.error((Object)"", (Throwable)ex);
                }
            }
        }
        return pkcs11;
    }
}

