/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys.keyresolver.implementations;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.keyvalues.DSAKeyValue;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Element;

public class DSAKeyValueResolver
extends KeyResolverSpi {
    public PublicKey engineLookupAndResolvePublicKey(Element element, String BaseURI, StorageResolver storage) {
        if (element == null) {
            return null;
        }
        Element dsaKeyElement = null;
        boolean isKeyValue = XMLUtils.elementIsInSignatureSpace(element, "KeyValue");
        if (isKeyValue) {
            dsaKeyElement = XMLUtils.selectDsNode(element.getFirstChild(), "DSAKeyValue", 0);
        } else if (XMLUtils.elementIsInSignatureSpace(element, "DSAKeyValue")) {
            dsaKeyElement = element;
        }
        if (dsaKeyElement == null) {
            return null;
        }
        try {
            DSAKeyValue dsaKeyValue = new DSAKeyValue(dsaKeyElement, BaseURI);
            PublicKey pk = dsaKeyValue.getPublicKey();
            return pk;
        }
        catch (XMLSecurityException ex) {
            return null;
        }
    }

    public X509Certificate engineLookupResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }

    public SecretKey engineLookupAndResolveSecretKey(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }
}

