/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.security.KeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.RSAPublicKeySpec;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import org.jcp.xml.dsig.internal.dom.DOMCryptoBinary;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DOMKeyValue
extends DOMStructure
implements KeyValue {
    private KeyFactory rsakf;
    private KeyFactory dsakf;
    private PublicKey publicKey;
    private javax.xml.crypto.dom.DOMStructure externalPublicKey;
    private DOMCryptoBinary p;
    private DOMCryptoBinary q;
    private DOMCryptoBinary g;
    private DOMCryptoBinary y;
    private DOMCryptoBinary j;
    private DOMCryptoBinary seed;
    private DOMCryptoBinary pgen;
    private DOMCryptoBinary modulus;
    private DOMCryptoBinary exponent;

    public DOMKeyValue(PublicKey key) throws KeyException {
        if (key == null) {
            throw new NullPointerException("key cannot be null");
        }
        this.publicKey = key;
        if (key instanceof DSAPublicKey) {
            DSAPublicKey dkey = (DSAPublicKey)key;
            DSAParams params = dkey.getParams();
            this.p = new DOMCryptoBinary(params.getP());
            this.q = new DOMCryptoBinary(params.getQ());
            this.g = new DOMCryptoBinary(params.getG());
            this.y = new DOMCryptoBinary(dkey.getY());
        } else if (key instanceof RSAPublicKey) {
            RSAPublicKey rkey = (RSAPublicKey)key;
            this.exponent = new DOMCryptoBinary(rkey.getPublicExponent());
            this.modulus = new DOMCryptoBinary(rkey.getModulus());
        } else {
            throw new KeyException("unsupported key algorithm: " + key.getAlgorithm());
        }
    }

    public DOMKeyValue(Element kvElem) throws MarshalException {
        Element kvtElem = DOMUtils.getFirstChildElement(kvElem);
        if (kvtElem.getLocalName().equals("DSAKeyValue")) {
            this.publicKey = this.unmarshalDSAKeyValue(kvtElem);
        } else if (kvtElem.getLocalName().equals("RSAKeyValue")) {
            this.publicKey = this.unmarshalRSAKeyValue(kvtElem);
        } else {
            this.publicKey = null;
            this.externalPublicKey = new javax.xml.crypto.dom.DOMStructure(kvtElem);
        }
    }

    public PublicKey getPublicKey() throws KeyException {
        if (this.publicKey == null) {
            throw new KeyException("can't convert KeyValue to PublicKey");
        }
        return this.publicKey;
    }

    public void marshal(Node parent, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        Document ownerDoc = DOMUtils.getOwnerDocument(parent);
        Element kvElem = DOMUtils.createElement(ownerDoc, "KeyValue", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        this.marshalPublicKey(kvElem, ownerDoc, dsPrefix, context);
        parent.appendChild(kvElem);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void marshalPublicKey(Node parent, Document doc, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        if (this.publicKey != null) {
            if (this.publicKey instanceof DSAPublicKey) {
                this.marshalDSAPublicKey(parent, doc, dsPrefix, context);
                return;
            } else {
                if (!(this.publicKey instanceof RSAPublicKey)) throw new MarshalException(this.publicKey.getAlgorithm() + " public key algorithm not supported");
                this.marshalRSAPublicKey(parent, doc, dsPrefix, context);
            }
            return;
        } else {
            parent.appendChild(this.externalPublicKey.getNode());
        }
    }

    private void marshalDSAPublicKey(Node parent, Document doc, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        Element dsaElem = DOMUtils.createElement(doc, "DSAKeyValue", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        Element pElem = DOMUtils.createElement(doc, "P", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        Element qElem = DOMUtils.createElement(doc, "Q", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        Element gElem = DOMUtils.createElement(doc, "G", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        Element yElem = DOMUtils.createElement(doc, "Y", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        this.p.marshal(pElem, dsPrefix, context);
        this.q.marshal(qElem, dsPrefix, context);
        this.g.marshal(gElem, dsPrefix, context);
        this.y.marshal(yElem, dsPrefix, context);
        dsaElem.appendChild(pElem);
        dsaElem.appendChild(qElem);
        dsaElem.appendChild(gElem);
        dsaElem.appendChild(yElem);
        parent.appendChild(dsaElem);
    }

    private void marshalRSAPublicKey(Node parent, Document doc, String dsPrefix, DOMCryptoContext context) throws MarshalException {
        Element rsaElem = DOMUtils.createElement(doc, "RSAKeyValue", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        Element modulusElem = DOMUtils.createElement(doc, "Modulus", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        Element exponentElem = DOMUtils.createElement(doc, "Exponent", "http://www.w3.org/2000/09/xmldsig#", dsPrefix);
        this.modulus.marshal(modulusElem, dsPrefix, context);
        this.exponent.marshal(exponentElem, dsPrefix, context);
        rsaElem.appendChild(modulusElem);
        rsaElem.appendChild(exponentElem);
        parent.appendChild(rsaElem);
    }

    private DSAPublicKey unmarshalDSAKeyValue(Element kvtElem) throws MarshalException {
        Element curElem;
        if (this.dsakf == null) {
            try {
                this.dsakf = KeyFactory.getInstance("DSA");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("unable to create DSA KeyFactory: " + e.getMessage());
            }
        }
        if ((curElem = DOMUtils.getFirstChildElement(kvtElem)).getLocalName().equals("P")) {
            this.p = new DOMCryptoBinary(curElem.getFirstChild());
            curElem = DOMUtils.getNextSiblingElement(curElem);
            this.q = new DOMCryptoBinary(curElem.getFirstChild());
            curElem = DOMUtils.getNextSiblingElement(curElem);
        }
        if (curElem.getLocalName().equals("G")) {
            this.g = new DOMCryptoBinary(curElem.getFirstChild());
            curElem = DOMUtils.getNextSiblingElement(curElem);
        }
        this.y = new DOMCryptoBinary(curElem.getFirstChild());
        if ((curElem = DOMUtils.getNextSiblingElement(curElem)) != null && curElem.getLocalName().equals("J")) {
            this.j = new DOMCryptoBinary(curElem.getFirstChild());
            curElem = DOMUtils.getNextSiblingElement(curElem);
        }
        if (curElem != null) {
            this.seed = new DOMCryptoBinary(curElem.getFirstChild());
            curElem = DOMUtils.getNextSiblingElement(curElem);
            this.pgen = new DOMCryptoBinary(curElem.getFirstChild());
        }
        DSAPublicKeySpec spec = new DSAPublicKeySpec(this.y.getBigNum(), this.p.getBigNum(), this.q.getBigNum(), this.g.getBigNum());
        return (DSAPublicKey)this.generatePublicKey(this.dsakf, spec);
    }

    private RSAPublicKey unmarshalRSAKeyValue(Element kvtElem) throws MarshalException {
        if (this.rsakf == null) {
            try {
                this.rsakf = KeyFactory.getInstance("RSA");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("unable to create RSA KeyFactory: " + e.getMessage());
            }
        }
        Element modulusElem = DOMUtils.getFirstChildElement(kvtElem);
        this.modulus = new DOMCryptoBinary(modulusElem.getFirstChild());
        Element exponentElem = DOMUtils.getNextSiblingElement(modulusElem);
        this.exponent = new DOMCryptoBinary(exponentElem.getFirstChild());
        RSAPublicKeySpec spec = new RSAPublicKeySpec(this.modulus.getBigNum(), this.exponent.getBigNum());
        return (RSAPublicKey)this.generatePublicKey(this.rsakf, spec);
    }

    private PublicKey generatePublicKey(KeyFactory kf, KeySpec keyspec) {
        try {
            return kf.generatePublic(keyspec);
        }
        catch (InvalidKeySpecException e) {
            return null;
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KeyValue)) {
            return false;
        }
        try {
            KeyValue kv = (KeyValue)obj;
            if (this.publicKey == null ? kv.getPublicKey() != null : !this.publicKey.equals(kv.getPublicKey())) {
                return false;
            }
        }
        catch (KeyException ke) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        assert (false) : "hashCode not designed";
        return 45;
    }
}

