/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.ts;

import es.mityc.firmaJava.ts.AuthenticatorProxyCredentials;
import es.mityc.firmaJava.ts.I18n;
import es.mityc.firmaJava.ts.OwnSSLProtocolSocketFactory;
import es.mityc.firmaJava.ts.TSClienteError;
import es.mityc.firmaJava.ts.TSPAlgoritmos;
import es.mityc.javasign.ssl.ISSLManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampRequest;
import org.bouncycastle.tsp.TimeStampRequestGenerator;
import org.bouncycastle.tsp.TimeStampResponse;

public class TSCliente {
    private String servidorTSA = null;
    private String algoritmoHash = null;
    private static final HttpClient CLIENTE = new HttpClient();
    private static final Integer INT5000 = new Integer(5000);
    static Log log = LogFactory.getLog((String)TSCliente.class.getName());

    public TSCliente(String nombreServidor, String algoritmoHash) {
        this.servidorTSA = nombreServidor;
        this.algoritmoHash = "SHA-1";
        if (algoritmoHash != null) {
            String temp = algoritmoHash.trim().toUpperCase();
            if (TSPAlgoritmos.getPermitidos().contains(algoritmoHash)) {
                this.algoritmoHash = temp;
            } else {
                log.warn((Object)"No se ha encontrado un algoritmo hash v\u00e1lido para el Sello de Tiempo. Se va a utilizar el algoritmo SHA1 por defecto");
            }
        }
    }

    public static void setSSLManager(ISSLManager sslmanager) {
        Protocol authhttps = new Protocol("https", (SecureProtocolSocketFactory)new OwnSSLProtocolSocketFactory(sslmanager), 443);
        Protocol.registerProtocol((String)"https", (Protocol)authhttps);
    }

    /*
     * Loose catch block
     */
    public byte[] generarSelloTiempo(byte[] binarioaSellar) throws TSClienteError {
        if (binarioaSellar == null) {
            log.error((Object)"No se han especificado los datos sobre los que generar el sello de tiempo");
            throw new TSClienteError(I18n.getResource("libreriatsa.error1"));
        }
        log.info((Object)"Se va a generar el sello de tiempo ...");
        TimeStampRequestGenerator generadorPeticion = new TimeStampRequestGenerator();
        generadorPeticion.setCertReq(true);
        TimeStampRequest peticion = null;
        TimeStampResponse respuesta = null;
        try {
            MessageDigest resumen = MessageDigest.getInstance(this.algoritmoHash);
            resumen.update(binarioaSellar);
            peticion = generadorPeticion.generate(TSPAlgoritmos.getOID(this.algoritmoHash), resumen.digest());
            log.info((Object)"Petici\u00f3n TSA generada");
        }
        catch (Exception e) {
            log.error((Object)"Ha ocurrido un error al generar la petici\u00f3n TSA");
            throw new TSClienteError(I18n.getResource("libreriatsa.error10"));
        }
        CLIENTE.getParams().setParameter("http.socket.timeout", (Object)INT5000);
        String servidorProxy = System.getProperty("http.proxyHost");
        if (servidorProxy != null) {
            int puertoProxy = 80;
            try {
                puertoProxy = Integer.parseInt(System.getProperty("http.proxyPort"));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            CLIENTE.getHostConfiguration().setProxy(servidorProxy, puertoProxy);
            AuthenticatorProxyCredentials defaultcreds = new AuthenticatorProxyCredentials(servidorProxy, "");
            CLIENTE.getState().setProxyCredentials(AuthScope.ANY, (Credentials)defaultcreds);
        }
        PostMethod metodo = new PostMethod(this.servidorTSA);
        metodo.addRequestHeader("Content-Type", "application/timestamp-query");
        ByteArrayInputStream datos = null;
        try {
            datos = new ByteArrayInputStream(peticion.getEncoded());
        }
        catch (IOException e) {
            log.error((Object)("Error al leer la petici\u00f3n: " + e.getMessage()));
            throw new TSClienteError(I18n.getResource("libreriatsa.error11") + ": " + e.getMessage());
        }
        InputStreamRequestEntity rq = new InputStreamRequestEntity((InputStream)datos);
        metodo.setRequestEntity((RequestEntity)rq);
        metodo.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        byte[] cuerpoRespuesta = null;
        try {
            DEREncodable enc;
            block23: {
                int estadoCodigo = CLIENTE.executeMethod((HttpMethod)metodo);
                log.info((Object)"Petici\u00f3n TSA enviada.");
                if (estadoCodigo != 200) {
                    log.error((Object)("Fallo la ejecuci\u00f3n del m\u00e9todo: " + metodo.getStatusLine()));
                    throw new TSClienteError(I18n.getResource("libreriatsa.error12") + ": " + metodo.getStatusLine());
                }
                cuerpoRespuesta = metodo.getResponseBody();
                log.info((Object)"Respuesta TSA obtenida.");
                respuesta = new TimeStampResponse(cuerpoRespuesta);
                respuesta.validate(peticion);
                log.info((Object)"Respuesta TSA validada OK");
                ASN1InputStream is = new ASN1InputStream(cuerpoRespuesta);
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)is.readObject());
                enc = seq.getObjectAt(1);
                if (enc != null) break block23;
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = enc.getDERObject().getEncoded();
            return byArray;
            {
                catch (TSPException e) {
                    try {
                        try {
                            log.error((Object)("La respuesta no es v\u00e1lida para la petici\u00f3n enviada: " + e.getMessage()));
                            throw new TSClienteError(I18n.getResource("libreriatsa.error9") + ": " + e.getMessage());
                        }
                        catch (TSPException e2) {
                            log.error((Object)("La respuesta est\u00e1 mal formada: " + e2.getMessage()));
                            throw new TSClienteError(I18n.getResource("libreriatsa.error8") + ": " + e2.getMessage());
                        }
                        catch (IOException e3) {
                            log.error((Object)("La secuencia de bytes de respuesta no est\u00e1 codificada en ASN.1: " + e3.getMessage()));
                            throw new TSClienteError(I18n.getResource("libreriatsa.error7") + ": " + e3.getMessage());
                        }
                    }
                    catch (HttpException e4) {
                        log.error((Object)("Violaci\u00f3n del protocolo HTTP: " + e4.getMessage()));
                        throw new TSClienteError(I18n.getResource("libreriatsa.error6") + ": " + e4.getMessage());
                    }
                    catch (IOException e5) {
                        String mensajeError = I18n.getResource("libreriatsa.error4") + ": " + this.servidorTSA;
                        log.error((Object)("Error en la conexi\u00f3n con el servidor OCSP: " + e5.getMessage()));
                        throw new TSClienteError(mensajeError);
                    }
                }
            }
        }
        finally {
            metodo.releaseConnection();
        }
    }

    public static void main(String[] args) {
    }
}

