/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades;

import es.mityc.firmaJava.libreria.utilidades.Base64;
import es.mityc.firmaJava.libreria.utilidades.Base64Coder;
import es.mityc.firmaJava.libreria.utilidades.I18n;
import es.mityc.firmaJava.libreria.utilidades.NombreNodo;
import es.mityc.firmaJava.libreria.utilidades.URIEncoder;
import es.mityc.firmaJava.libreria.utilidades.UtilidadCertificados;
import es.mityc.firmaJava.libreria.utilidades.UtilidadFechas;
import es.mityc.firmaJava.libreria.utilidades.UtilidadFirmaElectronica;
import es.mityc.firmaJava.libreria.utilidades.UtilidadTratarNodo;
import es.mityc.firmaJava.libreria.utilidades.Utilidades;
import es.mityc.firmaJava.libreria.xades.CanonicalizationEnum;
import es.mityc.firmaJava.libreria.xades.DatosCRL;
import es.mityc.firmaJava.libreria.xades.DatosFirma;
import es.mityc.firmaJava.libreria.xades.DatosNodosFirmados;
import es.mityc.firmaJava.libreria.xades.DatosOCSP;
import es.mityc.firmaJava.libreria.xades.DatosSelloTiempo;
import es.mityc.firmaJava.libreria.xades.DatosTipoFirma;
import es.mityc.firmaJava.libreria.xades.DatosX509;
import es.mityc.firmaJava.libreria.xades.EnumFormatoFirma;
import es.mityc.firmaJava.libreria.xades.ExtraValidators;
import es.mityc.firmaJava.libreria.xades.ResultadoEnum;
import es.mityc.firmaJava.libreria.xades.ResultadoValidacion;
import es.mityc.firmaJava.libreria.xades.TipoSellosTiempo;
import es.mityc.firmaJava.libreria.xades.UtilidadXadesA;
import es.mityc.firmaJava.libreria.xades.UtilidadXadesX;
import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.Cert;
import es.mityc.firmaJava.libreria.xades.elementos.xades.CertificateValues;
import es.mityc.firmaJava.libreria.xades.elementos.xades.DataObjectFormat;
import es.mityc.firmaJava.libreria.xades.elementos.xades.EncapsulatedX509Certificate;
import es.mityc.firmaJava.libreria.xades.elementos.xades.EncodingEnum;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SignaturePolicyIdentifier;
import es.mityc.firmaJava.libreria.xades.elementos.xades.SigningTime;
import es.mityc.firmaJava.libreria.xades.errores.BadFormedSignatureException;
import es.mityc.firmaJava.libreria.xades.errores.FirmaXMLError;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import es.mityc.firmaJava.libreria.xades.logv;
import es.mityc.firmaJava.trust.ConfianzaEnum;
import es.mityc.firmaJava.ts.TSClienteError;
import es.mityc.firmaJava.ts.TSPAlgoritmos;
import es.mityc.firmaJava.ts.TSValidacion;
import es.mityc.firmaJava.ts.TSValidator;
import es.mityc.javasign.asn1.ASN1Utils;
import es.mityc.javasign.certificate.CertStatusException;
import es.mityc.javasign.certificate.ElementNotFoundException;
import es.mityc.javasign.certificate.ICertStatus;
import es.mityc.javasign.certificate.ICertStatusRecoverer;
import es.mityc.javasign.certificate.IOCSPCertStatus;
import es.mityc.javasign.certificate.IRecoverElements;
import es.mityc.javasign.certificate.OCSPResponderID;
import es.mityc.javasign.certificate.RevokedInfo;
import es.mityc.javasign.certificate.UnknownElementClassException;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.trust.NotTrustedException;
import es.mityc.javasign.trust.TrustAbstract;
import es.mityc.javasign.trust.TrustException;
import es.mityc.javasign.trust.UnknownTrustException;
import es.mityc.javasign.xml.resolvers.IPrivateData;
import es.mityc.javasign.xml.resolvers.IResourceData;
import es.mityc.javasign.xml.resolvers.MITyCResourceResolver;
import es.mityc.javasign.xml.resolvers.ResolverPrivateData;
import es.mityc.javasign.xml.resolvers.XAdESResourceResolverSpi;
import es.mityc.javasign.xml.xades.LocalFileStoreElements;
import es.mityc.javasign.xml.xades.ReferenceProxy;
import es.mityc.javasign.xml.xades.policy.IValidacionPolicy;
import es.mityc.javasign.xml.xades.policy.PoliciesManager;
import es.mityc.javasign.xml.xades.policy.PolicyResult;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CRLException;
import java.security.cert.CertPath;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.signature.Reference;
import org.apache.xml.security.signature.SignedInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.ocsp.BasicOCSPResp;
import org.bouncycastle.ocsp.CertificateID;
import org.bouncycastle.ocsp.OCSPException;
import org.bouncycastle.ocsp.OCSPResp;
import org.bouncycastle.ocsp.RevokedStatus;
import org.bouncycastle.ocsp.SingleResp;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidarFirmaXML {
    private List<String> esquemasParaValidar = new LinkedList<String>();
    private boolean esValido = false;
    private ResultadoValidacion resultado = new ResultadoValidacion();
    private DatosFirma datosFirma = null;
    private ArrayList<DatosSelloTiempo> arrayDatosSello = null;
    private ArrayList<DatosCRL> arrayDatosCRL = null;
    private ArrayList<DatosOCSP> arrayDatosOCSP = null;
    private ArrayList<PolicyResult> politicas = new ArrayList();
    private ArrayList<X509Certificate> cadenaCertificados = new ArrayList();
    private ArrayList<String> firmados = null;
    private DatosTipoFirma tipoDocFirma = null;
    private String uriXmlNS = null;
    private String nombreNodoUri = "Include";
    private String tipoUri = "URI";
    private static final Log LOGGER = LogFactory.getLog(ValidarFirmaXML.class);
    private static final II18nManager i18n = I18nFactory.getI18nManager((String)"MITyCLibXAdES");
    private IRecoverElements recoverManager;
    private ArrayList<ResourceResolverSpi> resolvers;

    public ValidarFirmaXML() {
        this.setXAdESSchema(XAdESSchemas.XAdES_111, true);
        this.setXAdESSchema(XAdESSchemas.XAdES_122, true);
        this.setXAdESSchema(XAdESSchemas.XAdES_132, true);
    }

    public void setRecoverElements(IRecoverElements recoverManager) {
        this.recoverManager = recoverManager;
    }

    public void addResolver(IPrivateData resolver) {
        this.addResolver(new ResolverPrivateData(resolver));
    }

    public void addResolver(MITyCResourceResolver resolver) {
        if (this.resolvers == null) {
            this.resolvers = new ArrayList();
        }
        this.resolvers.add(resolver);
    }

    public void addResolver(IResourceData resolver) {
        this.addResolver(new XAdESResourceResolverSpi(resolver));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResultadoValidacion> validar(File firmaParaValidar, ExtraValidators validators) throws FirmaXMLError {
        logv.createFile(firmaParaValidar.getAbsolutePath());
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(firmaParaValidar);
        }
        catch (FileNotFoundException e) {
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error58"));
            return null;
        }
        FirmaXMLError excepcion = null;
        List<ResultadoValidacion> rs = null;
        try {
            rs = this.validar(fis, firmaParaValidar.getParentFile().toURI().toString(), validators);
        }
        catch (FirmaXMLError ex) {
            excepcion = ex;
        }
        finally {
            logv.cierraLog();
            try {
                fis.close();
            }
            catch (Exception ex) {}
        }
        if (excepcion != null) {
            throw excepcion;
        }
        return rs;
    }

    public List<ResultadoValidacion> validar(byte[] bFirmaParaValidar, ExtraValidators validators) throws FirmaXMLError {
        LOGGER.debug((Object)(I18n.getResource("libreriaxades.validarfirmaxml.info2") + " " + System.getProperty("user.dir")));
        File dir = new File(System.getProperty("user.dir"));
        return this.validar(bFirmaParaValidar, dir.toURI().toString(), validators);
    }

    public List<ResultadoValidacion> validar(byte[] bFirmaParaValidar, String baseUri, ExtraValidators validators) throws FirmaXMLError {
        ByteArrayInputStream bis = new ByteArrayInputStream(bFirmaParaValidar);
        return this.validar(bis, baseUri, validators);
    }

    public List<ResultadoValidacion> validar(InputStream inputFirmaParaValidar, String baseUri, ExtraValidators validators) throws FirmaXMLError {
        if (this.recoverManager == null) {
            this.recoverManager = new LocalFileStoreElements(baseUri);
        }
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = null;
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            this.mostrarErrorValidacion(e1);
        }
        InputSource isour = null;
        Document doc = null;
        try {
            isour = new InputSource(inputFirmaParaValidar);
            doc = db.parse(isour);
        }
        catch (FileNotFoundException e1) {
            this.mostrarErrorValidacion(e1);
        }
        catch (SAXException e1) {
            this.mostrarErrorValidacion(e1);
        }
        catch (IOException e1) {
            this.mostrarErrorValidacion(e1);
        }
        dbf = null;
        isour = null;
        db = null;
        ArrayList<ResultadoValidacion> res = this.validar(doc, baseUri, validators);
        if (res != null && res.size() > 0 && validators != null) {
            TrustAbstract trusterCerts = validators.getTrusterCerts();
            TrustAbstract trusterOCSP = validators.getTrusterOCSP();
            TrustAbstract trusterCRL = validators.getTrusterCRL();
            TrustAbstract trusterTSA = validators.getTrusterTSA();
            if (trusterCerts != null || trusterOCSP != null || trusterCRL != null || trusterTSA != null) {
                for (ResultadoValidacion rv : res) {
                    DatosFirma df;
                    if (rv == null || (df = rv.getDatosFirma()) == null) continue;
                    if (trusterCerts != null) {
                        this.validateTrustCerts(trusterCerts, df);
                    }
                    if (trusterOCSP != null) {
                        this.validateTrustOCSP(trusterOCSP, df);
                    }
                    if (trusterCRL != null) {
                        this.validateTrustCRL(trusterCRL, df);
                    }
                    if (trusterTSA == null) continue;
                    this.validateTrustTSA(trusterTSA, df);
                }
            }
        }
        return res;
    }

    private void validateTrustCerts(TrustAbstract truster, DatosFirma df) {
        block4: {
            try {
                truster.isTrusted((Object)df.getCadenaFirma());
                df.setEsCadenaConfianza(ConfianzaEnum.CON_CONFIANZA);
            }
            catch (NotTrustedException ex) {
                df.setEsCadenaConfianza(ConfianzaEnum.SIN_CONFIANZA);
            }
            catch (UnknownTrustException ex) {
                df.setEsCadenaConfianza(ConfianzaEnum.NO_REVISADO);
            }
            catch (TrustException ex) {
                df.setEsCadenaConfianza(ConfianzaEnum.NO_REVISADO);
                LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.trust.1", new Object[]{ex.getMessage()}));
                if (!LOGGER.isDebugEnabled()) break block4;
                LOGGER.debug((Object)"", (Throwable)ex);
            }
        }
    }

    private void validateTrustOCSP(TrustAbstract truster, DatosFirma df) {
        ArrayList<DatosOCSP> ocsps = df.getDatosOCSP();
        if (ocsps != null && ocsps.size() > 0) {
            for (DatosOCSP docsp : ocsps) {
                OCSPResp ocspr = docsp.getRespuestaOCSP();
                if (ocspr == null) continue;
                try {
                    truster.isTrusted((Object)ocspr);
                    docsp.setEsCertConfianza(ConfianzaEnum.CON_CONFIANZA);
                }
                catch (NotTrustedException ex) {
                    docsp.setEsCertConfianza(ConfianzaEnum.SIN_CONFIANZA);
                }
                catch (UnknownTrustException ex) {
                    docsp.setEsCertConfianza(ConfianzaEnum.NO_REVISADO);
                }
                catch (TrustException ex) {
                    docsp.setEsCertConfianza(ConfianzaEnum.NO_REVISADO);
                    LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.trust.2", new Object[]{ex.getMessage()}));
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)"", (Throwable)ex);
                }
            }
        }
    }

    private void validateTrustCRL(TrustAbstract truster, DatosFirma df) {
        ArrayList<DatosCRL> crls = df.getDatosCRL();
        if (crls != null && crls.size() > 0) {
            for (DatosCRL dcrl : crls) {
                X509CRL crl = dcrl.getX509CRL();
                if (crl == null) continue;
                try {
                    truster.isTrusted((Object)crl);
                    dcrl.setEsCertConfianza(ConfianzaEnum.CON_CONFIANZA);
                }
                catch (NotTrustedException ex) {
                    dcrl.setEsCertConfianza(ConfianzaEnum.SIN_CONFIANZA);
                }
                catch (UnknownTrustException ex) {
                    dcrl.setEsCertConfianza(ConfianzaEnum.NO_REVISADO);
                }
                catch (TrustException ex) {
                    dcrl.setEsCertConfianza(ConfianzaEnum.NO_REVISADO);
                    LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.trust.3", new Object[]{ex.getMessage()}));
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)"", (Throwable)ex);
                }
            }
        }
    }

    private void validateTrustTSA(TrustAbstract truster, DatosFirma df) {
        ArrayList<DatosSelloTiempo> tsts = df.getDatosSelloTiempo();
        if (tsts != null && tsts.size() > 0) {
            for (DatosSelloTiempo dst : tsts) {
                TimeStampToken tst = dst.getTst();
                if (tst == null) continue;
                try {
                    truster.isTrusted((Object)tst);
                    dst.setEsCertConfianza(ConfianzaEnum.CON_CONFIANZA);
                }
                catch (NotTrustedException ex) {
                    dst.setEsCertConfianza(ConfianzaEnum.SIN_CONFIANZA);
                }
                catch (UnknownTrustException ex) {
                    dst.setEsCertConfianza(ConfianzaEnum.NO_REVISADO);
                }
                catch (TrustException ex) {
                    dst.setEsCertConfianza(ConfianzaEnum.NO_REVISADO);
                    LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.trust.4", new Object[]{ex.getMessage()}));
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug((Object)"", (Throwable)ex);
                }
            }
        }
    }

    public void setLocale(String locale) {
        I18n.setLocale(locale, locale.toUpperCase());
    }

    public void setXAdESSchema(XAdESSchemas schema, boolean activate) {
        if (schema != null) {
            if (activate) {
                this.esquemasParaValidar.add(schema.getSchemaUri());
            } else {
                this.esquemasParaValidar.remove(schema.getSchemaUri());
            }
        }
    }

    public ArrayList<ResultadoValidacion> validar(Document doc, String baseUri, ExtraValidators validators) throws FirmaXMLError {
        ICertStatusRecoverer certStatusRecoverer;
        ArrayList<ResultadoValidacion> resultados = new ArrayList<ResultadoValidacion>();
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.uriXmlNS = "http://www.w3.org/2000/09/xmldsig#";
        if (this.esquemasParaValidar.isEmpty()) {
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error1"));
            throw new FirmaXMLError(I18n.getResource("libreriaxades.validarfirmaxml.error1"));
        }
        Init.init();
        NodeList listaFirmas = doc.getElementsByTagNameNS(this.uriXmlNS, "Signature");
        if (listaFirmas.getLength() == 0) {
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error2"));
            throw new FirmaXMLError(I18n.getResource("libreriaxades.validarfirmaxml.error2"));
        }
        int longitud = listaFirmas.getLength();
        LOGGER.debug((Object)(I18n.getResource("libreriaxades.validarfirmaxml.info1") + " " + longitud));
        for (int i = 0; i < longitud; ++i) {
            List<IValidacionPolicy> policies = validators != null ? validators.getPolicies() : null;
            resultados.add(this.validaFirma(listaFirmas.item(i), baseUri, policies));
        }
        ResultadoValidacion rv2 = null;
        for (ResultadoValidacion rv2 : resultados) {
            String id;
            DatosFirma datos = rv2.getDatosFirma();
            rv2.setContrafirmadoPor(new ArrayList<ResultadoValidacion>());
            if (datos == null || (id = datos.getSigValueId()) == null) continue;
            for (ResultadoValidacion rv22 : resultados) {
                ArrayList<String> contrafirmaA;
                DatosFirma datos2 = rv22.getDatosFirma();
                if (datos2 == null || id.equals(datos2.getSigValueId()) || (contrafirmaA = datos2.getContraFirma()) == null || !contrafirmaA.contains(id)) continue;
                rv2.addContrafirmadoPor(rv22);
            }
        }
        if (resultados != null && resultados.size() > 0 && validators != null) {
            TrustAbstract trusterCerts = validators.getTrusterCerts();
            TrustAbstract trusterOCSP = validators.getTrusterOCSP();
            TrustAbstract trusterCRL = validators.getTrusterCRL();
            TrustAbstract trusterTSA = validators.getTrusterTSA();
            if (trusterCerts != null || trusterOCSP != null || trusterCRL != null || trusterTSA != null) {
                for (ResultadoValidacion res : resultados) {
                    DatosFirma df;
                    if (res == null || (df = res.getDatosFirma()) == null) continue;
                    if (trusterCerts != null) {
                        this.validateTrustCerts(trusterCerts, df);
                    }
                    if (trusterOCSP != null) {
                        this.validateTrustOCSP(trusterOCSP, df);
                    }
                    if (trusterCRL != null) {
                        this.validateTrustCRL(trusterCRL, df);
                    }
                    if (trusterTSA == null) continue;
                    this.validateTrustTSA(trusterTSA, df);
                }
            }
        }
        ICertStatusRecoverer iCertStatusRecoverer = certStatusRecoverer = validators != null ? validators.getCertStatus() : null;
        if (certStatusRecoverer != null) {
            for (ResultadoValidacion rv2 : resultados) {
                ArrayList<DatosSelloTiempo> listTS;
                if (!rv2.isValidate() || EnumFormatoFirma.XAdES_T.compareTo(rv2.getEnumNivel()) < 0) continue;
                Date firstTimestamp = null;
                if (EnumFormatoFirma.XAdES_T.equals((Object)rv2.getEnumNivel()) && (listTS = rv2.getDatosFirma().getDatosSelloTiempo()) != null) {
                    for (DatosSelloTiempo dst : listTS) {
                        if (firstTimestamp == null) {
                            firstTimestamp = dst.getFecha();
                            continue;
                        }
                        if (!firstTimestamp.after(dst.getFecha())) continue;
                        firstTimestamp = dst.getFecha();
                    }
                }
                CertPath cp = rv2.getDatosFirma().getCadenaFirma();
                X509Certificate certificate = (X509Certificate)cp.getCertificates().get(0);
                try {
                    ICertStatus certStatus = certStatusRecoverer.getCertStatus(certificate);
                    if (ICertStatus.CERT_STATUS.revoked.equals((Object)certStatus.getStatus())) {
                        boolean isValid = false;
                        if (firstTimestamp != null) {
                            Date revoked;
                            RevokedInfo ri = certStatus.getRevokedInfo();
                            Date date = revoked = ri != null ? ri.getRevokedDate() : null;
                            if (revoked != null && firstTimestamp.before(revoked)) {
                                isValid = true;
                            }
                        }
                        if (isValid) continue;
                        rv2.setValidate(false);
                        rv2.setResultado(ResultadoEnum.INVALID);
                        rv2.setLog(null);
                        LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error165"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error165"));
                        continue;
                    }
                    if (ICertStatus.CERT_STATUS.unknown.equals((Object)certStatus.getStatus())) {
                        rv2.setValidate(false);
                        rv2.setResultado(ResultadoEnum.UNKNOWN);
                        rv2.setLog(null);
                        LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error166"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error166"));
                        continue;
                    }
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace((Object)I18n.getResource("libreriaxades.validarfirmaxml.error167"));
                    }
                    logv.info(I18n.getResource("libreriaxades.validarfirmaxml.error167"));
                }
                catch (CertStatusException ex) {
                    throw new FirmaXMLError(ex.getMessage(), ex);
                }
            }
        }
        doc = null;
        return resultados;
    }

    private ResultadoValidacion validaFirma(Node firma, String baseUri, List<IValidacionPolicy> policies) {
        Node padre;
        String id;
        if (baseUri == null) {
            baseUri = new File("./").getAbsolutePath();
        }
        this.politicas = new ArrayList();
        if (policies != null && policies.size() > 0) {
            for (IValidacionPolicy valPol : policies) {
                if (valPol == null) continue;
                PolicyResult pr = new PolicyResult();
                pr.setPolicyVal(valPol);
                this.politicas.add(pr);
            }
        }
        this.resultado = new ResultadoValidacion();
        X509Certificate cert = null;
        XMLSignature firmaDocumento = null;
        String uriDS = null;
        try {
            firmaDocumento = new XMLSignature((Element)firma, baseUri);
            if (this.resolvers != null) {
                Iterator<ResourceResolverSpi> it = this.resolvers.iterator();
                while (it.hasNext()) {
                    firmaDocumento.addResourceResolver(it.next());
                }
            }
            uriDS = firmaDocumento.getBaseNamespace();
        }
        catch (XMLSignatureException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error7") + ": " + e.getMessage());
            this.resultado.setValidate(false);
            this.resultado.setResultado(ResultadoEnum.INVALID);
            return this.resultado;
        }
        catch (XMLSecurityException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error7") + ": " + e.getMessage());
            this.resultado.setValidate(false);
            return this.resultado;
        }
        try {
            this.resultado.setBaseURI(new URI(URIEncoder.encode(baseUri, "UTF-8")));
        }
        catch (URISyntaxException ex) {
            LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
        }
        catch (UnsupportedEncodingException ex) {
            LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
        }
        this.datosFirma = new DatosFirma();
        this.firmados = new ArrayList();
        this.arrayDatosSello = new ArrayList();
        this.arrayDatosCRL = new ArrayList();
        this.arrayDatosOCSP = new ArrayList();
        ArrayList<String> cfA = new ArrayList<String>();
        this.resultado.setDatosFirma(this.datosFirma);
        this.resultado.setDoc(firma.getOwnerDocument());
        this.resultado.setFirmados(this.firmados);
        EstructuraFirma estructuraFirma = this.obtenerEsquema((Element)firma);
        if (estructuraFirma == null || estructuraFirma.esquema == null) {
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error1"));
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error1"));
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error1"));
            this.resultado.setValidate(false);
            this.resultado.setResultado(ResultadoEnum.UNKNOWN);
        } else {
            estructuraFirma.xmlSig = firmaDocumento;
            this.datosFirma.setEsquema(estructuraFirma.esquema);
            logv.info("Xml Schema: " + estructuraFirma.esquema);
        }
        ArrayList<Element> signatureValues = null;
        try {
            signatureValues = UtilidadTratarNodo.obtenerNodos((Element)firma, 2, new NombreNodo(this.uriXmlNS, "SignatureValue"));
        }
        catch (FirmaXMLError e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            logv.error(e.getMessage());
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error5"));
            this.resultado.setValidate(false);
            this.resultado.setResultado(ResultadoEnum.INVALID);
            return this.resultado;
        }
        if (signatureValues != null && signatureValues.size() > 0 && (id = signatureValues.get(0).getAttribute("Id")) != null && !"".equals(id)) {
            this.datosFirma.setSigValueId(id);
        }
        this.getConstantesEsquema(estructuraFirma.esquema);
        if (estructuraFirma != null && estructuraFirma.esquema != null) {
            this.obtenerCadenaCertificados(estructuraFirma);
        }
        ArrayList<Element> nodosReference = new ArrayList<Element>();
        SignedInfo si = firmaDocumento.getSignedInfo();
        for (int i = 0; i < si.getLength(); ++i) {
            try {
                Reference ref = si.item(i);
                nodosReference.add(si.item(i).getElement());
                DatosNodosFirmados dnf = new DatosNodosFirmados();
                dnf.setReference(new ReferenceProxy(ref));
                this.datosFirma.addDatosNodoFirmado(dnf);
                continue;
            }
            catch (XMLSecurityException ex) {
                LOGGER.warn((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.7", new Object[]{ex.getMessage()}));
            }
        }
        int nodeFileReferenceLength = nodosReference.size();
        for (int f = 0; f < nodeFileReferenceLength; ++f) {
            Element nodo;
            Element elementReference = (Element)nodosReference.get(f);
            String referenceUri = elementReference.getAttribute("URI");
            if (referenceUri != null) {
                this.firmados.add(referenceUri);
            }
            if (referenceUri == "" || !referenceUri.startsWith("#") || (nodo = UtilidadTratarNodo.getElementById(firma.getOwnerDocument(), referenceUri.substring(1))) == null || !nodo.getLocalName().equals("SignatureValue") || referenceUri.substring(1).equals(this.datosFirma.getSigValueId())) continue;
            Node cs = firma.getParentNode();
            if (cs.getNodeType() == 1 && ((Element)cs).getLocalName().equals("CounterSignature") && (cs.getChildNodes() == null || cs.getChildNodes().getLength() != 1)) {
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error172"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error173"));
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error173"));
                this.resultado.setValidate(false);
                this.resultado.setResultado(ResultadoEnum.INVALID);
                return this.resultado;
            }
            cfA.add(referenceUri.substring(1));
        }
        if (cfA != null && cfA.size() > 0) {
            this.datosFirma.setContraFirma(cfA);
        }
        if ((padre = firma.getParentNode()) != null && "CounterSignature".equals(padre.getLocalName())) {
            boolean hayReferencia = false;
            Node sigNode = padre.getParentNode().getParentNode().getParentNode().getParentNode().getParentNode();
            NodeList hijosSigNode = sigNode.getChildNodes();
            Element sigValueNode = null;
            for (int i = 0; i < hijosSigNode.getLength(); ++i) {
                if (!"SignatureValue".equals(hijosSigNode.item(i).getLocalName())) continue;
                sigValueNode = (Element)hijosSigNode.item(i);
            }
            if (sigValueNode == null) {
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                this.resultado.setValidate(false);
                this.resultado.setResultado(ResultadoEnum.INVALID);
                return this.resultado;
            }
            for (int f = 0; f < nodeFileReferenceLength; ++f) {
                String tipo;
                Element nodoSigValue;
                Element elementReference = (Element)nodosReference.get(f);
                String uri = elementReference.getAttribute("URI");
                if (uri == null || uri == "" || !uri.startsWith("#") || (nodoSigValue = UtilidadTratarNodo.getElementById(firma.getOwnerDocument(), uri.substring(1))) == null || !nodoSigValue.equals(sigValueNode)) continue;
                hayReferencia = true;
                if (!XAdESSchemas.XAdES_132.equals(estructuraFirma.esquema) || "http://uri.etsi.org/01903#CountersignedSignature".equals(tipo = elementReference.getAttribute("Type"))) continue;
                LOGGER.warn((Object)"Atenci\u00f3n. Nodo Reference no est\u00e1 incluyendo tipo Contrafirma (ETSI TS 101 903 v1.3.2 7.2.4.1");
            }
            if (!hayReferencia) {
                LOGGER.error((Object)("Contrafirma mal formada: No se encuentra una referencia bien formada al nodo \"" + sigValueNode.getAttribute("Id") + "\""));
                logv.error("La contrafirma no esta firmando el nodo SignatureValue de la firma que lo contiene");
                this.resultado.setLog("Contrafirma inv\u00e1lida. La firma validada no contrafirma a la firma que lo contiene");
                this.resultado.setValidate(false);
                this.resultado.setResultado(ResultadoEnum.INVALID);
                return this.resultado;
            }
        }
        if (this.cadenaCertificados == null || this.cadenaCertificados.size() == 0) {
            if (estructuraFirma.esquema != null) {
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                this.resultado.setValidate(false);
                this.resultado.setResultado(ResultadoEnum.INVALID);
                return this.resultado;
            }
            return this.resultado;
        }
        cert = this.cadenaCertificados.get(0);
        logv.info("Signing Certificate: " + ((Object)cert.getSubjectDN()).toString());
        if (cert != null) {
            try {
                this.esValido = firmaDocumento.checkSignatureValue(cert);
            }
            catch (XMLSignatureException ex) {
                LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error105"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error105"));
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error105"));
                this.resultado.setValidate(false);
                this.resultado.setResultado(ResultadoEnum.INVALID);
                return this.resultado;
            }
            if (this.esValido) {
                logv.info("XMLDSig Core Validation: Passed");
            } else {
                LOGGER.debug((Object)"XMLDSig Core Validation: Not passed");
                logv.error("XMLDSig Core Validation: Not passed");
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error105"));
                this.resultado.setValidate(false);
                this.resultado.setResultado(ResultadoEnum.INVALID);
            }
        } else {
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error5"));
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error5"));
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error5"));
            this.resultado.setValidate(false);
            this.resultado.setResultado(ResultadoEnum.INVALID);
            return this.resultado;
        }
        this.getDataObjectFormat(firma.getOwnerDocument(), estructuraFirma);
        try {
            this.tipoDocFirma = this.tipoFirma(estructuraFirma);
            logv.info("XAdES type: " + this.tipoDocFirma.getTipoXAdES().name());
            this.datosFirma.setTipoFirma(this.tipoDocFirma);
        }
        catch (BadFormedSignatureException e) {
            LOGGER.error((Object)e.getMessage());
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error4"));
            this.resultado.setValidate(false);
            this.resultado.setResultado(ResultadoEnum.INVALID);
            logv.error("Bad XAdES format. Invalid Signature: " + e.getMessage());
            this.esValido = false;
            this.tipoDocFirma = new DatosTipoFirma(EnumFormatoFirma.XMLSignature, false, false);
        }
        if (this.esValido) {
            if (this.validarXadesBes(estructuraFirma)) {
                if (this.tipoDocFirma.esXAdES_EPES()) {
                    LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.texto5"));
                    logv.info("XAdES-EPES validation: Valid");
                    this.resultado.setNivelValido(I18n.getResource("libreriaxades.validarfirmaxml.texto5"));
                } else {
                    LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.texto1"));
                    logv.info("XAdES-BES validation: Valid");
                    this.resultado.setNivelValido(I18n.getResource("libreriaxades.validarfirmaxml.texto1"));
                }
                this.resultado.setEnumNivel(EnumFormatoFirma.XAdES_BES);
                this.resultado.setLog(i18n.getLocalMessage("i18n.mityc.xades.validate.14"));
                this.datosFirma.setRoles(this.obtenerRoles(estructuraFirma));
                if (this.tipoDocFirma.getTipoXAdES().compareTo(EnumFormatoFirma.XAdES_BES) > 0) {
                    if (this.validarSelloTiempoXadesT(estructuraFirma)) {
                        LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.texto2"));
                        this.resultado.setEnumNivel(EnumFormatoFirma.XAdES_T);
                        this.resultado.setNivelValido(I18n.getResource("libreriaxades.validarfirmaxml.texto2"));
                        this.datosFirma.setDatosSelloTiempo(this.arrayDatosSello);
                        if (this.tipoDocFirma.getTipoXAdES().compareTo(EnumFormatoFirma.XAdES_T) > 0 && this.validarXadesC(uriDS, cert, estructuraFirma)) {
                            LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.texto4"));
                            logv.info("XAdES-C validation: Valid");
                            this.resultado.setEnumNivel(EnumFormatoFirma.XAdES_C);
                            this.resultado.setNivelValido(I18n.getResource("libreriaxades.validarfirmaxml.texto4"));
                            this.resultado.setLog("");
                            this.datosFirma.setDatosOCSP(this.arrayDatosOCSP);
                            this.datosFirma.setDatosCRL(this.arrayDatosCRL);
                            if (this.tipoDocFirma.getTipoXAdES().compareTo(EnumFormatoFirma.XAdES_X) >= 0 && (this.validarSelloTiempoXadesXTipo1(estructuraFirma) || this.validarSelloTiempoXadesXTipo2(estructuraFirma))) {
                                this.resultado.setEnumNivel(this.tipoDocFirma.getTipoXAdES());
                                if (EnumFormatoFirma.XAdES_X.compareTo(this.tipoDocFirma.getTipoXAdES()) == 0) {
                                    this.resultado.setNivelValido(I18n.getResource("libreriaxades.validarfirmaxml.texto7"));
                                    LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.texto7"));
                                    logv.info("XAdES-X validation: Valid");
                                } else {
                                    this.resultado.setNivelValido(I18n.getResource("libreriaxades.validarfirmaxml.texto3"));
                                    LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.texto3"));
                                    logv.info("XAdES-XL validation: Valid");
                                }
                                this.datosFirma.setDatosSelloTiempo(this.arrayDatosSello);
                                this.datosFirma.setDatosOCSP(this.arrayDatosOCSP);
                            }
                        }
                    } else {
                        String sello = "";
                        if (this.tipoDocFirma.getTipoXAdES().compareTo(EnumFormatoFirma.XAdES_XL) == 0) {
                            sello = "XAdES T ";
                        }
                        LOGGER.info((Object)(I18n.getResource("libreriaxades.validarfirmaxml.error8") + " " + sello + " " + I18n.getResource("libreriaxades.validarfirmaxml.error9") + " " + (Object)((Object)this.tipoDocFirma.getTipoXAdES()) + " " + I18n.getResource("libreriaxades.validarfirmaxml.error10")));
                        if (i18n.getLocalMessage("i18n.mityc.xades.validate.14").equals(this.resultado.getLog())) {
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error8") + " " + sello + " " + I18n.getResource("libreriaxades.validarfirmaxml.error9") + " " + this.tipoDocFirma.getTipoXAdES().name() + " " + I18n.getResource("libreriaxades.validarfirmaxml.error10"));
                        }
                        this.esValido = false;
                    }
                }
            }
            this.resultado.setValidate(this.esValido);
            this.resultado.setResultado(this.esValido ? ResultadoEnum.VALID : ResultadoEnum.INVALID);
            if (this.tipoDocFirma.esXAdES_A()) {
                try {
                    if (!this.validaXadesA(estructuraFirma)) {
                        LOGGER.info((Object)"La firma contiene un sello de tiempo XAdES-A NO v\u00e1lido");
                        logv.info("La firma contiene un sello de tiempo del tipo XAdES-A NO v\u00e1lido");
                        this.resultado.setLog("Un sello de tiempo de tipo A es inv\u00e1lido");
                        this.resultado.setValidate(false);
                        this.resultado.setResultado(ResultadoEnum.INVALID);
                        return this.resultado;
                    }
                    LOGGER.info((Object)"La firma contiene un sello de tiempo XAdES-A v\u00e1lido");
                }
                catch (Exception e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            if (this.esValido) {
                this.buscaXadesEpes(estructuraFirma);
            }
        }
        if (this.esValido && this.politicas.size() > 0) {
            for (PolicyResult pr : this.politicas) {
                int i;
                if (pr.getPolicyVal() != null) {
                    try {
                        IValidacionPolicy valPol = pr.getPolicyVal();
                        PolicyResult prTemp = valPol.validaPolicy((Element)firma, this.resultado);
                        pr.copy(prTemp);
                    }
                    catch (Throwable th) {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error109"), th);
                        this.resultado.setValidate(false);
                        this.resultado.setResultado(ResultadoEnum.INVALID);
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error71"));
                        pr.setResult(PolicyResult.StatusValidation.unknown);
                        pr.setDescriptionResult(th.getMessage());
                        break;
                    }
                    if (PolicyResult.StatusValidation.invalid.equals((Object)pr.getResult())) {
                        this.resultado.setValidate(false);
                        this.resultado.setResultado(ResultadoEnum.INVALID);
                        this.resultado.setLog(pr.getDescriptionResult());
                    } else if (PolicyResult.StatusValidation.unknown.equals((Object)pr.getResult())) {
                        this.resultado.setValidate(false);
                        this.resultado.setResultado(ResultadoEnum.UNKNOWN);
                        this.resultado.setLog(pr.getDescriptionResult());
                    }
                }
                PolicyResult.StatusValidation sv = pr.getResult();
                String policyDescResult = pr.getDescriptionResult();
                PolicyResult.DownloadPolicy[] policyDownload = pr.getDownloable();
                String[] policyNotices = pr.getNotices();
                boolean valido = false;
                String policyID = null;
                if (PolicyResult.StatusValidation.valid.equals((Object)sv)) {
                    policyID = "Accomplished policy: " + pr.getPolicyID();
                    valido = true;
                } else if (PolicyResult.StatusValidation.invalid.equals((Object)sv)) {
                    policyID = "Unaccomplished policy: " + pr.getPolicyID();
                } else if (PolicyResult.StatusValidation.unknown.equals((Object)sv)) {
                    policyID = pr.getPolicyID() == null ? "Implied policy" : "Unkown policy";
                    valido = true;
                }
                logv.abreTag(valido);
                logv.info(policyID, 2);
                if (!valido && policyDescResult != null) {
                    logv.info(policyDescResult, 2);
                }
                for (i = 0; policyDownload != null && i < policyDownload.length; ++i) {
                    String value = policyDownload[i].uri.toString();
                    if (PolicyResult.StatusValidation.unknown.equals((Object)policyDownload[i].status)) {
                        value = "(Unknown integrity): ".concat(value);
                    } else {
                        if (!PolicyResult.StatusValidation.valid.equals((Object)policyDownload[i].status)) continue;
                        value = "(Checked integrity): ".concat(value);
                    }
                    logv.info("Download URI " + value, 2);
                }
                for (i = 0; policyNotices != null && i < policyNotices.length; ++i) {
                    logv.info("Notice: " + policyNotices[i].toString(), 2);
                }
                logv.cierraTag(valido);
            }
        }
        if (this.politicas.size() > 0) {
            this.datosFirma.setPoliticas(this.politicas);
        }
        return this.resultado;
    }

    private void buscaXadesEpes(EstructuraFirma estructuraFirma) {
        Element firma = estructuraFirma.firma;
        String esquemaURI = estructuraFirma.esquema.getSchemaUri();
        ArrayList<Element> signaturePolicyList = null;
        try {
            signaturePolicyList = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "SignaturePolicyIdentifier"));
        }
        catch (FirmaXMLError e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            logv.error(e.getMessage());
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error5"));
            this.resultado.setValidate(false);
            this.resultado.setResultado(ResultadoEnum.INVALID);
            return;
        }
        int numNodosSigPolicy = 0;
        if (signaturePolicyList != null) {
            numNodosSigPolicy = signaturePolicyList.size();
        }
        if (numNodosSigPolicy == 0 && "http://uri.etsi.org/01903/v1.1.1#".equals(esquemaURI)) {
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error110"));
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error111"));
            this.esValido = false;
            this.resultado.setValidate(false);
            this.resultado.setResultado(ResultadoEnum.INVALID);
            return;
        }
        if (numNodosSigPolicy == 1) {
            IValidacionPolicy valPol;
            SignaturePolicyIdentifier spi;
            Element signaturePolicyIdentifierNode = signaturePolicyList.get(0);
            try {
                spi = new SignaturePolicyIdentifier(estructuraFirma.esquema);
                if (!spi.isThisNode(signaturePolicyIdentifierNode)) {
                    throw new InvalidInfoNodeException(I18n.getResource("libreriaxades.validarfirmaxml.error112"));
                }
                spi.load(signaturePolicyIdentifierNode);
            }
            catch (InvalidInfoNodeException ex) {
                LOGGER.error((Object)(I18n.getResource("libreriaxades.validarfirmaxml.error164") + " " + ex.getMessage()), (Throwable)ex);
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error164") + " " + ex.getMessage());
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error114"));
                this.esValido = false;
                this.resultado.setValidate(false);
                this.resultado.setResultado(ResultadoEnum.INVALID);
                return;
            }
            PoliciesManager policiesManager = PoliciesManager.getInstance();
            PoliciesManager.PolicyKey clave = policiesManager.newPolicyKey(null, "implied");
            if (!spi.isImplied()) {
                clave.hash = Utilidades.binary2String(Base64Coder.decode(spi.getSignaturePolicyId().getSigPolicyHash().getDigestValue().getValue()));
                clave.uri = spi.getSignaturePolicyId().getSigPolicyId().getIdentifier().getUri();
            }
            if ((valPol = policiesManager.getValidadorPolicy(clave)) == null) {
                PolicyResult pr = new PolicyResult();
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error104"));
                pr.setResult(PolicyResult.StatusValidation.unknown);
                pr.setPolicyID(clave.uri);
                this.politicas.add(pr);
            } else if (!this.politicas.contains(valPol)) {
                PolicyResult pr = new PolicyResult();
                pr.setPolicyVal(valPol);
                this.politicas.add(pr);
            }
        } else if (numNodosSigPolicy > 1) {
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error115"));
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error115"));
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error116"));
            this.esValido = false;
            this.resultado.setValidate(false);
            this.resultado.setResultado(ResultadoEnum.INVALID);
            return;
        }
    }

    private void mostrarErrorValidacion(Exception ex) throws FirmaXMLError {
        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error28"), (Throwable)ex);
        throw new FirmaXMLError(I18n.getResource("libreriaxades.validarfirmaxml.error28"));
    }

    private void getDataObjectFormat(Document doc, EstructuraFirma estructuraFirma) {
        DatosNodosFirmados datos = null;
        ArrayList<Element> signedDataObjectProperties = null;
        DataObjectFormat dof = null;
        Element dataOF = null;
        Node attId = null;
        try {
            signedDataObjectProperties = UtilidadTratarNodo.obtenerNodos(estructuraFirma.firma, 4, new NombreNodo(estructuraFirma.esquema.getSchemaUri(), "SignedDataObjectProperties"));
        }
        catch (FirmaXMLError e) {
            LOGGER.debug((Object)"No se pudo recoger el nodo SignedDataObjectProperties", (Throwable)e);
        }
        if (signedDataObjectProperties != null && signedDataObjectProperties.size() == 1) {
            Element signedDOP = signedDataObjectProperties.get(0);
            NodeList dataOFs = signedDOP.getChildNodes();
            int dofLength = dataOFs.getLength();
            for (int i = 0; i < dofLength; ++i) {
                dataOF = (Element)dataOFs.item(i);
                dof = new DataObjectFormat(estructuraFirma.esquema);
                try {
                    dof.load(dataOF);
                }
                catch (InvalidInfoNodeException e) {
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    continue;
                }
                if (dataOF.getAttributes() != null && dataOF.getAttributes().getLength() > 0) {
                    String uri;
                    if (dataOF.getAttributes() != null) {
                        attId = dataOF.getAttributes().getNamedItem("ObjectReference");
                    }
                    if (attId != null && (uri = attId.getTextContent()) != null && uri.startsWith("#")) {
                        datos = this.datosFirma.getDatosNodoFimadoByReferenceId(uri.substring(1));
                        if (datos != null) {
                            if (dof.getObjectIdentifier() != null) {
                                datos.setObjectIdentifier(dof.getObjectIdentifier());
                            }
                            if (dof.getDescription() != null) {
                                datos.setDescription(dof.getDescription().getValue());
                            }
                            if (dof.getMimeType() != null) {
                                datos.setMimeType(dof.getMimeType().getValue());
                            }
                            if (dof.getEnconding() != null) {
                                datos.setEncoding(dof.getEnconding().getValue());
                            }
                        } else {
                            LOGGER.warn((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.8", new Object[]{uri}));
                        }
                    }
                }
                if (datos != null) continue;
            }
        } else {
            LOGGER.debug((Object)"El nodo SignedDataObjectProperties no existe o no es \u00fanico");
        }
    }

    private boolean validarXadesBes(EstructuraFirma estructuraFirma) {
        int i;
        if (estructuraFirma.firma == null) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error76"));
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error76"));
            return false;
        }
        Element firma = estructuraFirma.firma;
        String esquemaURI = estructuraFirma.esquema.getSchemaUri();
        Date fechaFirma = this.obtenerFechaFirma(estructuraFirma);
        this.datosFirma.setFechaFirma(fechaFirma);
        if (fechaFirma != null) {
            if (fechaFirma.after(new Date())) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error170"));
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error170"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error170"));
                return false;
            }
            X509Certificate cert = this.cadenaCertificados.get(0);
            Date notAfter = cert.getNotAfter();
            Date notBefore = cert.getNotBefore();
            if (fechaFirma.after(notAfter) || fechaFirma.before(notBefore)) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error159"));
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error159"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error159"));
                return false;
            }
        }
        ArrayList<DatosX509> certificadosSigning = new ArrayList<DatosX509>();
        DatosX509 datos = new DatosX509();
        ArrayList<Element> nodosSigningCertificate = UtilidadTratarNodo.obtenerNodos(estructuraFirma.signedSignatureProperties, null, new NombreNodo(esquemaURI, "SigningCertificate"));
        if (nodosSigningCertificate.size() > 0) {
            Node nodoSigningCertificate = nodosSigningCertificate.get(0);
            ArrayList<Element> nodosCert = UtilidadTratarNodo.getElementChildNodes((Element)nodoSigningCertificate, false);
            if (nodosCert == null) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                return false;
            }
            int nodosCertSize = nodosCert.size();
            Element nodoCert = null;
            for (i = 0; i < nodosCertSize; ++i) {
                nodoCert = nodosCert.get(i);
                Cert cert = new Cert(estructuraFirma.esquema);
                try {
                    cert.load(nodoCert);
                }
                catch (InvalidInfoNodeException ex) {
                    this.esValido = false;
                    this.resultado.setLog(i18n.getLocalMessage("i18n.mityc.xades.validate.13"));
                    LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.11", new Object[]{ex.getMessage()}));
                    logv.error(i18n.getLocalMessage("i18n.mityc.xades.validate.13") + ex.getMessage());
                    return false;
                }
                datos.setAlgMethod(cert.getCertDigest().getDigestMethod().getAlgorithm());
                datos.setDigestValue(cert.getCertDigest().getDigestValue().getValue());
                try {
                    datos.setIssuer(new X500Principal(cert.getIssuerSerial().getIssuerName()));
                }
                catch (IllegalArgumentException ex) {
                    this.esValido = false;
                    this.resultado.setLog(i18n.getLocalMessage("i18n.mityc.xades.validate.13"));
                    LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.12", new Object[]{ex.getMessage()}));
                    logv.error(i18n.getLocalMessage("i18n.mityc.xades.validate.13") + ex.getMessage());
                    return false;
                }
                datos.setSerial(cert.getIssuerSerial().getSerialNumber());
                certificadosSigning.add(datos);
            }
        }
        if (certificadosSigning.size() > 0) {
            X509Certificate certFirmante = this.cadenaCertificados.get(0);
            X500Principal certFirmIssuer = certFirmante.getIssuerX500Principal();
            BigInteger certFirmSerial = certFirmante.getSerialNumber();
            boolean coincidencia = false;
            for (i = 0; i < certificadosSigning.size(); ++i) {
                Element nodoKeyInfo;
                Element primerNodoX509Data;
                NodeList nodosIssuerSerial;
                DatosX509 certAComparar = (DatosX509)certificadosSigning.get(i);
                if (!UtilidadCertificados.isSameName(certFirmIssuer, certAComparar.getIssuer()) || !certFirmSerial.equals(certAComparar.getSerial())) continue;
                ArrayList<Object> nodosKeyInfo = new ArrayList();
                try {
                    nodosKeyInfo = UtilidadTratarNodo.obtenerNodos(firma, 2, new NombreNodo(this.uriXmlNS, "KeyInfo"));
                }
                catch (FirmaXMLError e) {
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error3") + e.getMessage());
                    return false;
                }
                if (nodosKeyInfo.size() > 0 && (nodosIssuerSerial = (primerNodoX509Data = (Element)(nodoKeyInfo = (Element)nodosKeyInfo.get(0)).getElementsByTagNameNS(this.uriXmlNS, "X509Data").item(0)).getElementsByTagNameNS(this.uriXmlNS, "X509IssuerSerial")).getLength() > 0) {
                    NodeList serialVals;
                    X500Principal issuer = null;
                    BigInteger serial = null;
                    Element nodoIssuerSerial = (Element)nodosIssuerSerial.item(0);
                    NodeList issuerVals = nodoIssuerSerial.getElementsByTagNameNS(this.uriXmlNS, "X509IssuerName");
                    if (issuerVals != null) {
                        Element issuerValElement = (Element)issuerVals.item(0);
                        String issuerName = issuerValElement.getFirstChild().getNodeValue();
                        try {
                            issuer = new X500Principal(issuerName);
                        }
                        catch (IllegalArgumentException ex) {
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error23"), (Throwable)ex);
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error3") + ex.getMessage());
                            return false;
                        }
                        catch (NullPointerException ex) {
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error23"), (Throwable)ex);
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error3") + ex.getMessage());
                            return false;
                        }
                    }
                    if ((serialVals = nodoIssuerSerial.getElementsByTagNameNS(this.uriXmlNS, "X509SerialNumber")) != null) {
                        Element serialValElement = (Element)serialVals.item(0);
                        serial = new BigInteger(serialValElement.getFirstChild().getNodeValue());
                    }
                    if (!UtilidadCertificados.isSameName(certAComparar.getIssuer(), issuer) || !certAComparar.getSerial().equals(serial)) {
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error85"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error85"));
                        return false;
                    }
                }
                MessageDigest haseador = UtilidadFirmaElectronica.getMessageDigest(certAComparar.getAlgMethod());
                byte[] digestCertFirmante = null;
                try {
                    digestCertFirmante = haseador.digest(certFirmante.getEncoded());
                }
                catch (CertificateEncodingException e) {
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error52"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error52"));
                    return false;
                }
                if (Utilidades.isEqual(digestCertFirmante, Base64Coder.decode(certAComparar.getDigestValue()))) {
                    coincidencia = true;
                    certificadosSigning.remove(i);
                    logv.info("Signing certificate is valid");
                    break;
                }
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error136"));
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error86"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error86"));
                return false;
            }
            if (!coincidencia) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error136"));
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error87"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error87") + " because it not match the information contained in the SigningCertificate node.");
                return false;
            }
            int validos = 0;
            for (int i2 = 0; i2 < certificadosSigning.size(); ++i2) {
                DatosX509 certAComparar = (DatosX509)certificadosSigning.get(i2);
                for (int x = 0; x < this.cadenaCertificados.size(); ++x) {
                    X509Certificate certContenidos = this.cadenaCertificados.get(x);
                    X500Principal certContIssuer = certContenidos.getIssuerX500Principal();
                    BigInteger certContSerial = certContenidos.getSerialNumber();
                    if (!UtilidadCertificados.isSameName(certContIssuer, certAComparar.getIssuer()) || !certContSerial.equals(certAComparar.getSerial())) continue;
                    MessageDigest haseador = UtilidadFirmaElectronica.getMessageDigest(certAComparar.getAlgMethod());
                    byte[] digestCertContenidos = null;
                    try {
                        digestCertContenidos = haseador.digest(certContenidos.getEncoded());
                    }
                    catch (CertificateEncodingException e) {
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error52"));
                        LOGGER.error((Object)I18n.getResource("libreriaxades.firmaxml.error8"), (Throwable)e);
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error52") + e.getMessage());
                        return false;
                    }
                    if (Utilidades.isEqual(digestCertContenidos, Base64Coder.decode(certAComparar.getDigestValue()))) {
                        ++validos;
                        continue;
                    }
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error136"));
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error88"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error88"));
                    return false;
                }
            }
            if (validos < certificadosSigning.size()) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error89"));
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error89"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error89"));
                return false;
            }
        }
        ArrayList<Object> nodosSignedProperties = new ArrayList();
        try {
            nodosSignedProperties = UtilidadTratarNodo.obtenerNodos(firma, 3, new NombreNodo(esquemaURI, "SignedProperties"));
        }
        catch (FirmaXMLError e) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error139"));
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error77"));
            return false;
        }
        if (nodosSignedProperties.size() == 0) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error139"));
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error77"));
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error77"));
            return false;
        }
        Element nodoSignedProperties = (Element)nodosSignedProperties.get(0);
        Node signedPropertiesId = nodoSignedProperties.getAttributes().getNamedItem("Id");
        if (signedPropertiesId == null) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error140"));
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error78"));
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error78"));
            return false;
        }
        String nodoId = signedPropertiesId.getNodeValue();
        List<DatosNodosFirmados> references = this.datosFirma.getDatosNodosFirmados();
        if (references.size() == 0) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error141"));
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error79"));
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error79"));
            return false;
        }
        String tipoEsperado = UtilidadFirmaElectronica.obtenerTipoReference(esquemaURI);
        for (DatosNodosFirmados dnf : references) {
            Node referenceType;
            Element reference;
            String id = dnf.getId();
            if (id == null || !id.equals(nodoId) || (reference = dnf.getElementReference()) == null || (referenceType = reference.getAttributes().getNamedItem("Type")) == null || !tipoEsperado.equals(referenceType.getNodeValue()) || dnf.canBeModifiedByTransforms()) continue;
            return true;
        }
        this.esValido = false;
        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error142"));
        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error80"));
        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error80"));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validarSelloTiempoXadesT(EstructuraFirma estructuraFirma) {
        block51: {
            String sello;
            Element firma = estructuraFirma.firma;
            String esquemaURI = estructuraFirma.esquema.getSchemaUri();
            ArrayList<Object> nodosSignatureTimeStamp = new ArrayList();
            NodeList nodesEncapsulatedTimeStamp = null;
            Element encapsulatedTimeStampElement = null;
            String encapsulatedTS = null;
            byte[] timeStampBytes = null;
            TSValidacion tsv1 = null;
            DatosSelloTiempo datosSelloTiempo = new DatosSelloTiempo();
            try {
                Date fechaSello;
                String enc;
                EncodingEnum encoding;
                NodeList nodosTransforms;
                boolean transformsLenght;
                try {
                    nodosSignatureTimeStamp = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "SignatureTimeStamp"));
                }
                catch (FirmaXMLError e) {
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error143"));
                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error91"));
                    boolean bl = this.esValido;
                    nodesEncapsulatedTimeStamp = null;
                    encapsulatedTimeStampElement = null;
                    encapsulatedTS = null;
                    timeStampBytes = null;
                    tsv1 = null;
                    return bl;
                }
                if (nodosSignatureTimeStamp.size() <= 0) {
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error143"));
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error91"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error91"));
                    boolean e = this.esValido;
                    return e;
                }
                Element nodoSigTimeStamp = (Element)nodosSignatureTimeStamp.get(0);
                NodeList nodosUri = nodoSigTimeStamp.getElementsByTagNameNS(esquemaURI, this.nombreNodoUri);
                int nodosLenght = nodosUri.getLength();
                if (nodosLenght == 0 && !esquemaURI.equals("http://uri.etsi.org/01903/v1.3.2#") || nodosLenght > 1) {
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error144"));
                    LOGGER.error((Object)(I18n.getResource("libreriaxades.validarfirmaxml.error94") + " " + nodosLenght));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error94") + " " + nodosLenght);
                    boolean bl = this.esValido;
                    return bl;
                }
                if (esquemaURI.equals("http://uri.etsi.org/01903/v1.1.1#") && (transformsLenght = (nodosTransforms = ((Element)nodosUri.item(0)).getElementsByTagNameNS(this.uriXmlNS, "Transforms")).getLength()) > false) {
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error145"));
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error93"));
                    boolean bl = this.esValido;
                    return bl;
                }
                if (nodosLenght != 0 || !esquemaURI.equals("http://uri.etsi.org/01903/v1.3.2#")) {
                    NamedNodeMap nodosUriAttrb = nodosUri.item(0).getAttributes();
                    if (nodosUriAttrb == null || nodosUriAttrb.getLength() != 1 || nodosUriAttrb.getNamedItem(this.tipoUri) == null) {
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error146"));
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error92"));
                        transformsLenght = this.esValido;
                        return transformsLenght;
                    }
                    String timeStampUri = null;
                    try {
                        timeStampUri = URLDecoder.decode(nodosUriAttrb.getNamedItem(this.tipoUri).getNodeValue(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException ex) {
                        this.esValido = false;
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error30"), (Throwable)ex);
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error146"));
                        boolean bl = this.esValido;
                        nodesEncapsulatedTimeStamp = null;
                        encapsulatedTimeStampElement = null;
                        encapsulatedTS = null;
                        timeStampBytes = null;
                        tsv1 = null;
                        return bl;
                    }
                    Element nodoReferenciado = UtilidadTratarNodo.getElementById(firma, timeStampUri.substring(1));
                    if (nodoReferenciado == null || !"SignatureValue".equals(nodoReferenciado.getLocalName()) || !nodoReferenciado.getParentNode().equals(firma)) {
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error147"));
                        LOGGER.error((Object)(I18n.getResource("libreriaxades.validarfirmaxml.error95") + " " + "SignatureValue" + " " + I18n.getResource("libreriaxades.validarfirmaxml.error100")));
                        boolean bl = this.esValido;
                        return bl;
                    }
                }
                NodeList nodosCanonicalizationMethod = nodoSigTimeStamp.getElementsByTagNameNS(this.uriXmlNS, "CanonicalizationMethod");
                int numNodosCanonicalization = nodosCanonicalizationMethod.getLength();
                CanonicalizationEnum canonicalization = CanonicalizationEnum.C14N_OMIT_COMMENTS;
                if (numNodosCanonicalization > 0) {
                    if ("http://uri.etsi.org/01903/v1.1.1#".equals(esquemaURI)) {
                        this.esValido = false;
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error102"));
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error102"));
                        boolean bl = this.esValido;
                        return bl;
                    }
                    Element nodoCanonicalizationMethod = (Element)nodosCanonicalizationMethod.item(0);
                    String method = nodoCanonicalizationMethod.getAttribute("Algorithm");
                    canonicalization = CanonicalizationEnum.getCanonicalization(method);
                    if (canonicalization.equals((Object)CanonicalizationEnum.UNKNOWN)) {
                        this.esValido = false;
                        LOGGER.error((Object)(I18n.getResource("libreriaxades.validarfirmaxml.error103") + " " + method));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error103") + " " + method);
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error103") + " " + method);
                        boolean bl = this.esValido;
                        return bl;
                    }
                }
                nodesEncapsulatedTimeStamp = nodoSigTimeStamp.getElementsByTagNameNS(esquemaURI, "EncapsulatedTimeStamp");
                encapsulatedTimeStampElement = (Element)nodesEncapsulatedTimeStamp.item(0);
                if (("http://uri.etsi.org/01903/v1.2.2#".equals(esquemaURI) || "http://uri.etsi.org/01903/v1.3.2#".equals(esquemaURI)) && (encoding = EncodingEnum.getEncoding(enc = encapsulatedTimeStampElement.getAttribute("Encoding"))) == null) {
                    this.esValido = false;
                    LOGGER.error((Object)("Encoding del sello de tiempo T desconocido: " + enc));
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error143"));
                    boolean bl = this.esValido;
                    return bl;
                }
                encapsulatedTS = encapsulatedTimeStampElement.getFirstChild().getNodeValue();
                timeStampBytes = Base64.decode(encapsulatedTS);
                byte[] nodeSignatureValue = UtilidadTratarNodo.obtenerByteNodo(firma, this.uriXmlNS, "SignatureValue", canonicalization, 5);
                tsv1 = TSValidator.validarSelloTiempo((byte[])nodeSignatureValue, (byte[])timeStampBytes);
                if (!tsv1.isRespuesta()) {
                    this.esValido = false;
                }
                if ((fechaSello = tsv1.getFechaDate()) != null && fechaSello.after(new Date())) {
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error81"));
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error81"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error81"));
                    boolean bl = false;
                    return bl;
                }
                if (this.esValido) {
                    try {
                        datosSelloTiempo.setFecha(fechaSello);
                        datosSelloTiempo.setEmisor(tsv1.getEmisor());
                        datosSelloTiempo.setAlgoritmo(TSPAlgoritmos.getAlgName((String)tsv1.getSelloAlg()));
                        datosSelloTiempo.setPrecision(tsv1.getPrecisionLong());
                        datosSelloTiempo.setTipoSello(TipoSellosTiempo.CLASE_T);
                        datosSelloTiempo.setTst(tsv1.getTst());
                        logv.abreTag(true);
                        logv.info("XAdES-T TimeStamp validation: VALID", 2);
                        logv.info("Date: " + fechaSello, 2);
                        logv.info("Issuer: " + tsv1.getEmisor(), 2);
                        logv.cierraTag(true);
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error64"));
                    }
                    this.arrayDatosSello.add(datosSelloTiempo);
                    break block51;
                }
                logv.abreTag(false);
                logv.info("XAdES-T TimeStamp validation: INVALID", 2);
                logv.info("Date: " + fechaSello, 2);
                logv.info("Issuer: " + tsv1.getEmisor(), 2);
                logv.cierraTag(false);
            }
            catch (NoSuchAlgorithmException e) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error12"));
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                logv.error(e.getMessage());
            }
            catch (NoSuchProviderException e) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error12"));
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                logv.error(e.getMessage());
            }
            catch (CertStoreException e) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error12"));
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                logv.error(e.getMessage());
            }
            catch (FirmaXMLError e) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error12"));
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                logv.error(e.getMessage());
            }
            catch (TSPException e) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error12"));
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                logv.error(e.getMessage());
            }
            catch (IOException e) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error12"));
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                logv.error(e.getMessage());
            }
            catch (TSClienteError e) {
                sello = "";
                if (this.tipoDocFirma.getTipoXAdES().compareTo(EnumFormatoFirma.XAdES_XL) == 0) {
                    sello = "XAdES T ";
                }
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error8") + " " + sello + I18n.getResource("libreriaxades.validarfirmaxml.error9") + " " + (Object)((Object)this.tipoDocFirma.getTipoXAdES()) + " " + I18n.getResource("libreriaxades.validarfirmaxml.error13"));
                LOGGER.error((Object)e.getMessage());
                logv.error(e.getMessage());
            }
            catch (Exception e) {
                sello = "";
                if (this.tipoDocFirma.getTipoXAdES().compareTo(EnumFormatoFirma.XAdES_XL) == 0) {
                    sello = "XAdES T ";
                }
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error8") + " " + sello + I18n.getResource("libreriaxades.validarfirmaxml.error9") + " " + (Object)((Object)this.tipoDocFirma.getTipoXAdES()) + " " + I18n.getResource("libreriaxades.validarfirmaxml.error13"));
                LOGGER.error((Object)e.getMessage());
                logv.error(e.getMessage());
            }
            finally {
                nodesEncapsulatedTimeStamp = null;
                encapsulatedTimeStampElement = null;
                encapsulatedTS = null;
                timeStampBytes = null;
                tsv1 = null;
            }
        }
        return this.esValido;
    }

    private boolean validarSelloTiempoXadesXTipo1(EstructuraFirma estructuraFirma) {
        ArrayList<Object> nodesSigAndRefsTimeStamp = new ArrayList();
        try {
            nodesSigAndRefsTimeStamp = UtilidadTratarNodo.obtenerNodos(estructuraFirma.firma, 5, new NombreNodo(estructuraFirma.esquema.getSchemaUri(), "SigAndRefsTimeStamp"));
        }
        catch (FirmaXMLError e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        int numSigAndRefs = nodesSigAndRefsTimeStamp.size();
        if (numSigAndRefs == 0) {
            return false;
        }
        for (int i = 0; i < numSigAndRefs; ++i) {
            this.esValido = this.validarSegundoSelloTiempo((Element)nodesSigAndRefsTimeStamp.get(i), estructuraFirma);
            if (!this.esValido) break;
        }
        return this.esValido;
    }

    private boolean validarSelloTiempoXadesXTipo2(EstructuraFirma estructuraFirma) {
        ArrayList<Object> nodesRefsOnlyTimeStamp = new ArrayList();
        try {
            nodesRefsOnlyTimeStamp = UtilidadTratarNodo.obtenerNodos(estructuraFirma.firma, 5, new NombreNodo(estructuraFirma.esquema.getSchemaUri(), "RefsOnlyTimeStamp"));
        }
        catch (FirmaXMLError e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        int numRefsOnly = nodesRefsOnlyTimeStamp.size();
        if (numRefsOnly == 0) {
            return false;
        }
        for (int i = 0; i < numRefsOnly; ++i) {
            this.esValido = this.validarSegundoSelloTiempo((Element)nodesRefsOnlyTimeStamp.get(i), estructuraFirma);
            if (!this.esValido) break;
        }
        return this.esValido;
    }

    private boolean validarSegundoSelloTiempo(Element selloTiempo, EstructuraFirma estructuraFirma) {
        String enc;
        EncodingEnum encoding;
        Element nodoCanonicalizationMethod;
        String method;
        NodeList nodosInclude;
        int numNodosInclude;
        Element firma = estructuraFirma.firma;
        String esquemaURI = estructuraFirma.esquema.getSchemaUri();
        TSValidacion tsv2 = null;
        DatosSelloTiempo datosSelloTiempo = new DatosSelloTiempo();
        TipoSellosTiempo tipoSello = TipoSellosTiempo.CLASE_X_TIPO_1;
        if (new NombreNodo(esquemaURI, "SigAndRefsTimeStamp").equals(new NombreNodo(selloTiempo.getNamespaceURI(), selloTiempo.getLocalName()))) {
            tipoSello = TipoSellosTiempo.CLASE_X_TIPO_1;
        } else if (new NombreNodo(esquemaURI, "RefsOnlyTimeStamp").equals(new NombreNodo(selloTiempo.getNamespaceURI(), selloTiempo.getLocalName()))) {
            tipoSello = TipoSellosTiempo.CLASE_X_TIPO_2;
        } else {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error15"));
            LOGGER.error((Object)(I18n.getResource("libreriaxades.validarfirmaxml.error8") + " " + I18n.getResource("libreriaxades.validarfirmaxml.error9") + " " + selloTiempo.getLocalName() + " " + I18n.getResource("libreriaxades.validarfirmaxml.error10")));
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error8") + " " + I18n.getResource("libreriaxades.validarfirmaxml.error9") + " " + selloTiempo.getLocalName() + " " + I18n.getResource("libreriaxades.validarfirmaxml.error10"));
            return this.esValido;
        }
        ArrayList<Element> elementosSelloX = null;
        try {
            elementosSelloX = TipoSellosTiempo.CLASE_X_TIPO_1.equals((Object)tipoSello) ? UtilidadXadesX.obtenerListadoXADESX1imp(esquemaURI, firma, selloTiempo) : UtilidadXadesX.obtenerListadoXADESX2exp(esquemaURI, firma, selloTiempo);
        }
        catch (BadFormedSignatureException e) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error148"));
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            logv.error(e.getMessage());
            return this.esValido;
        }
        catch (FirmaXMLError e) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error148"));
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            logv.error(e.getMessage());
            return this.esValido;
        }
        if ("http://uri.etsi.org/01903/v1.1.1#".equals(esquemaURI) || "http://uri.etsi.org/01903/v1.2.2#".equals(esquemaURI)) {
            int j;
            ArrayList<String> elementosIdSelloX = UtilidadTratarNodo.obtenerIDs(elementosSelloX);
            NodeList nodosUriRef = selloTiempo.getElementsByTagNameNS(esquemaURI, this.nombreNodoUri);
            int numNodosUriRef = nodosUriRef.getLength();
            ArrayList<String> urisRef = new ArrayList<String>(numNodosUriRef);
            Node nodoUriRef = null;
            for (j = 0; j < numNodosUriRef; ++j) {
                NodeList nodosTransforms;
                int transformsLenght;
                nodoUriRef = j == 0 ? (Element)selloTiempo.getFirstChild() : (Element)nodoUriRef.getNextSibling();
                if (nodoUriRef == null || !this.nombreNodoUri.equals(nodoUriRef.getLocalName())) {
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error146"));
                    LOGGER.error((Object)(I18n.getResource("libreriaxades.validarfirmaxml.error95") + " " + this.nombreNodoUri));
                    return this.esValido;
                }
                if ("http://uri.etsi.org/01903/v1.1.1#".equals(esquemaURI) && (transformsLenght = (nodosTransforms = nodoUriRef.getElementsByTagNameNS(this.uriXmlNS, "Transforms")).getLength()) > 0) {
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error145"));
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error93"));
                    return this.esValido;
                }
                NamedNodeMap atributosNodo = nodoUriRef.getAttributes();
                if (atributosNodo == null || atributosNodo.getNamedItem(this.tipoUri) == null) {
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error143"));
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error92"));
                    return this.esValido;
                }
                String uriReferencia = atributosNodo.getNamedItem(this.tipoUri).getNodeValue();
                urisRef.add(uriReferencia);
            }
            for (j = 0; j < numNodosUriRef; ++j) {
                String idUri = ((String)urisRef.get(j)).substring(1);
                if (idUri.equals(elementosIdSelloX.get(j))) continue;
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error97") + " " + idUri + " " + I18n.getResource("libreriaxades.validarfirmaxml.error98"));
                LOGGER.error((Object)(I18n.getResource("libreriaxades.validarfirmaxml.error97") + " " + idUri + " " + I18n.getResource("libreriaxades.validarfirmaxml.error98")));
                return this.esValido;
            }
        } else if ("http://uri.etsi.org/01903/v1.3.2#".equals(esquemaURI) && (numNodosInclude = (nodosInclude = selloTiempo.getElementsByTagNameNS(esquemaURI, "Include")).getLength()) > 0) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error101"));
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error101"));
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error101"));
            return this.esValido;
        }
        NodeList nodosCanonicalizationMethod = selloTiempo.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "CanonicalizationMethod");
        int numNodosCanonicalization = nodosCanonicalizationMethod.getLength();
        CanonicalizationEnum canonicalization = CanonicalizationEnum.C14N_OMIT_COMMENTS;
        if (numNodosCanonicalization > 0 && (canonicalization = CanonicalizationEnum.getCanonicalization(method = (nodoCanonicalizationMethod = (Element)nodosCanonicalizationMethod.item(0)).getAttribute("Algorithm"))).equals((Object)CanonicalizationEnum.UNKNOWN)) {
            this.esValido = false;
            LOGGER.error((Object)(I18n.getResource("libreriaxades.validarfirmaxml.error103") + " " + method));
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error103") + " " + method);
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error103") + " " + method);
            return this.esValido;
        }
        byte[] byteData = null;
        try {
            byteData = UtilidadTratarNodo.obtenerByte(elementosSelloX, canonicalization);
        }
        catch (FirmaXMLError e) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error14"));
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error14"));
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        NodeList nodesEncapsulatedTimeStamp = selloTiempo.getElementsByTagNameNS(esquemaURI, "EncapsulatedTimeStamp");
        if (nodesEncapsulatedTimeStamp.getLength() != 1) {
            this.esValido = false;
            LOGGER.error((Object)(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "EncapsulatedTimeStamp" + I18n.getResource("libreriaxades.firmaxml.error37") + " " + nodesEncapsulatedTimeStamp.getLength()));
            logv.error(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "EncapsulatedTimeStamp" + I18n.getResource("libreriaxades.firmaxml.error37") + " " + nodesEncapsulatedTimeStamp.getLength());
            this.resultado.setLog(I18n.getResource("libreriaxades.firmaxml.error15"));
            return this.esValido;
        }
        Element encapsulatedTimeStampElement = (Element)nodesEncapsulatedTimeStamp.item(0);
        if (("http://uri.etsi.org/01903/v1.2.2#".equals(esquemaURI) || "http://uri.etsi.org/01903/v1.3.2#".equals(esquemaURI)) && (encoding = EncodingEnum.getEncoding(enc = encapsulatedTimeStampElement.getAttribute("Encoding"))) == null) {
            this.esValido = false;
            LOGGER.error((Object)("Encoding del sello de tiempo X desconocido: " + enc));
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error148"));
            return this.esValido;
        }
        String encapsulatedTS = encapsulatedTimeStampElement.getFirstChild().getNodeValue();
        byte[] timeStampBytes = Base64.decode(encapsulatedTS);
        try {
            tsv2 = TSValidator.validarSelloTiempo((byte[])byteData, (byte[])timeStampBytes);
        }
        catch (NoSuchAlgorithmException e) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error149"));
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            logv.error(e.getMessage());
            return this.esValido;
        }
        catch (NoSuchProviderException e) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error149"));
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            logv.error(e.getMessage());
            return this.esValido;
        }
        catch (CertStoreException e) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error149"));
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            logv.error(e.getMessage());
            return this.esValido;
        }
        catch (TSPException e) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error149"));
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            logv.error(e.getMessage());
            return this.esValido;
        }
        catch (IOException e) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error149"));
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            logv.error(e.getMessage());
            return this.esValido;
        }
        catch (TSClienteError e) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error17"));
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            logv.error(e.getMessage());
            return this.esValido;
        }
        if (!tsv2.isRespuesta()) {
            this.esValido = false;
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error15"));
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error15"));
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error15"));
            return this.esValido;
        }
        Date fechaSello = tsv2.getFechaDate();
        if (fechaSello != null && fechaSello.after(new Date(System.currentTimeMillis()))) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error82"));
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error82"));
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error82"));
            return this.esValido;
        }
        try {
            datosSelloTiempo.setFecha(fechaSello);
            datosSelloTiempo.setEmisor(tsv2.getEmisor());
            datosSelloTiempo.setAlgoritmo(TSPAlgoritmos.getAlgName((String)tsv2.getSelloAlg()));
            datosSelloTiempo.setPrecision(tsv2.getPrecisionLong());
            datosSelloTiempo.setTipoSello(tipoSello);
            datosSelloTiempo.setTst(tsv2.getTst());
            if (this.esValido) {
                logv.abreTag(true);
                logv.info("XAdES-X TimeStamp validation: VALID", 2);
                logv.info("Date: " + fechaSello, 2);
                logv.info("Issuer: " + tsv2.getEmisor(), 2);
                logv.cierraTag(true);
            } else {
                logv.abreTag(false);
                logv.info("XAdES-X TimeStamp validation: INVALID", 2);
                logv.info("Date: " + fechaSello, 2);
                logv.info("Issuer: " + tsv2.getEmisor(), 2);
                logv.cierraTag(false);
            }
        }
        catch (Exception e) {
            this.esValido = false;
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error64"), (Throwable)e);
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error64"));
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error64"));
            return this.esValido;
        }
        this.arrayDatosSello.add(datosSelloTiempo);
        return true;
    }

    private boolean validarXadesC(String uriDS, X509Certificate certFirma, EstructuraFirma estructuraFirma) {
        byte[] resumenMensajeByte;
        MessageDigest resumenCertificadoTemp;
        HashMap<String, Object> props;
        String uri;
        Node ocspRefs;
        Element firma = estructuraFirma.firma;
        String esquemaURI = estructuraFirma.esquema.getSchemaUri();
        ArrayList<Object> completeCertificateRefs = new ArrayList();
        ArrayList<Object> completeRevocationRefs = new ArrayList();
        ArrayList<String> certURI = null;
        ArrayList<String> digestAlg = null;
        ArrayList<String> digestValue = null;
        ArrayList<X500Principal> issuerName = null;
        ArrayList<String> issuerSerial = null;
        ArrayList<String> ocspURI = null;
        ArrayList<OCSPResponderID> identifierOCSP = null;
        ArrayList<Date> identifierTime = null;
        ArrayList<String> ocspDigestAlg = null;
        ArrayList<String> ocspDigestValue = null;
        ArrayList<OCSPResp> respuestasOCSP = null;
        ArrayList<String> crlURI = null;
        ArrayList<String> crlDigestAlg = null;
        ArrayList<String> crlDigestValue = null;
        ArrayList<String> crlIssuer = null;
        ArrayList<Date> crlIssuerTime = null;
        ArrayList<BigInteger> crlNumber = null;
        ArrayList<X509CRL> crlList = null;
        try {
            completeCertificateRefs = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CompleteCertificateRefs"));
            completeRevocationRefs = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CompleteRevocationRefs"));
        }
        catch (FirmaXMLError e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            logv.error(I18n.getResource("libreriaxades.firmaxml.error29"));
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error135"));
            this.esValido = false;
        }
        if (completeCertificateRefs.size() == 0 || completeRevocationRefs.size() == 0) {
            LOGGER.error((Object)I18n.getResource("libreriaxades.firmaxml.error29"));
            logv.error(I18n.getResource("libreriaxades.firmaxml.error29"));
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error135"));
            this.esValido = false;
            return this.esValido;
        }
        Node certRefs = ((Element)completeCertificateRefs.get(0)).getElementsByTagNameNS(esquemaURI, "CertRefs").item(0);
        if (certRefs != null) {
            ArrayList<Element> certs = UtilidadTratarNodo.getElementChildNodes((Element)certRefs, false);
            if (certs == null) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                return false;
            }
            int l = certs.size();
            certURI = new ArrayList<String>(l);
            digestAlg = new ArrayList<String>(l);
            digestValue = new ArrayList<String>(l);
            issuerName = new ArrayList<X500Principal>(l);
            issuerSerial = new ArrayList<String>(l);
            for (int i = 0; i < l && this.esValido; ++i) {
                Element certificate = certs.get(i);
                if (certificate == null) continue;
                String uri2 = null;
                try {
                    uri2 = URLDecoder.decode(certificate.getAttributes().getNamedItem(this.tipoUri).getNodeValue(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error30"));
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error31"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error31"));
                }
                catch (Exception e) {
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error65"));
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error65"));
                }
                if (uri2 != null) {
                    certURI.add(uri2);
                }
                Element certDigest = (Element)certificate.getElementsByTagNameNS(esquemaURI, "CertDigest").item(0);
                Node algorithm = certDigest.getElementsByTagNameNS(uriDS, "DigestMethod").item(0);
                Node value = certDigest.getElementsByTagNameNS(uriDS, "DigestValue").item(0);
                digestAlg.add(algorithm.getAttributes().getNamedItem("Algorithm").getNodeValue());
                digestValue.add(value.getFirstChild().getNodeValue());
                Element issuer = (Element)certificate.getElementsByTagNameNS(esquemaURI, "IssuerSerial").item(0);
                Node name = issuer.getElementsByTagNameNS(uriDS, "X509IssuerName").item(0);
                Node serial = issuer.getElementsByTagNameNS(uriDS, "X509SerialNumber").item(0);
                String issuerRef = name.getFirstChild().getNodeValue();
                if (issuerRef == null) {
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error169"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error169"));
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error36"));
                } else {
                    try {
                        issuerName.add(new X500Principal(issuerRef));
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error169"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error169"));
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error29"));
                    }
                }
                issuerSerial.add(serial.getFirstChild().getNodeValue());
            }
        }
        if ((ocspRefs = ((Element)completeRevocationRefs.get(0)).getElementsByTagNameNS(esquemaURI, "OCSPRefs").item(0)) != null && this.esValido) {
            ArrayList<Element> refs = UtilidadTratarNodo.getElementChildNodes((Element)ocspRefs, false);
            if (refs == null) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error95 OCSPRefs"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error95 OCSPRefs"));
                return false;
            }
            int l = refs.size();
            ocspURI = new ArrayList<String>(l);
            identifierOCSP = new ArrayList<OCSPResponderID>(l);
            OCSPResponderID responderData = null;
            identifierTime = new ArrayList<Date>(l);
            ocspDigestAlg = new ArrayList<String>(l);
            ocspDigestValue = new ArrayList<String>(l);
            String noURIOCSPidentifier = I18n.getResource("libreriaxades.validarfirmaxml.error32") + " " + I18n.getResource("libreriaxades.validarfirmaxml.error62");
            for (int i = 0; i < l && this.esValido; ++i) {
                Element ocspRef = refs.get(i);
                if (ocspRef == null) continue;
                NodeList list = ocspRef.getElementsByTagNameNS(esquemaURI, "OCSPIdentifier");
                if (list.getLength() != 0) {
                    try {
                        ocspURI.add(URLDecoder.decode(((Element)list.item(0)).getAttributes().getNamedItem(this.tipoUri).getNodeValue(), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error30"));
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error32"));
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error32"));
                    }
                    catch (NullPointerException e) {
                        LOGGER.warn((Object)I18n.getResource("libreriaxades.validarfirmaxml.error160"));
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error30"));
                        this.esValido = false;
                        this.resultado.setLog(noURIOCSPidentifier);
                        logv.error(noURIOCSPidentifier);
                    }
                    try {
                        Element certDigest = (Element)ocspRef.getElementsByTagNameNS(esquemaURI, "OCSPIdentifier").item(0);
                        Node responder = certDigest.getElementsByTagNameNS(esquemaURI, "ResponderID").item(0);
                        Node time = certDigest.getElementsByTagNameNS(esquemaURI, "ProducedAt").item(0);
                        responderData = null;
                        if ("http://uri.etsi.org/01903/v1.1.1#".equals(esquemaURI) || "http://uri.etsi.org/01903/v1.2.2#".equals(esquemaURI)) {
                            responderData = OCSPResponderID.getOCSPresponderID((String)responder.getFirstChild().getNodeValue());
                        } else {
                            Node responderBy = responder.getFirstChild();
                            if ("ByName".equals(responderBy.getLocalName())) {
                                try {
                                    X500Principal prin = new X500Principal(responderBy.getFirstChild().getNodeValue());
                                    responderData = OCSPResponderID.getOCSPResponderID((X500Principal)prin);
                                }
                                catch (IllegalArgumentException ex) {
                                    this.esValido = false;
                                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error23"), (Throwable)ex);
                                    this.resultado.setLog(I18n.getResource("libreriaxades.firmaxml.error27"));
                                    logv.error(I18n.getResource("libreriaxades.firmaxml.error27"));
                                    return false;
                                }
                                catch (NullPointerException ex) {
                                    this.esValido = false;
                                    this.resultado.setLog(I18n.getResource("libreriaxades.firmaxml.error27"));
                                    logv.error(I18n.getResource("libreriaxades.firmaxml.error27"));
                                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error23"), (Throwable)ex);
                                    return false;
                                }
                            }
                            if ("ByKey".equals(responderBy.getLocalName())) {
                                String hash = responderBy.getFirstChild().getNodeValue();
                                try {
                                    responderData = OCSPResponderID.getOCSPResponderID((byte[])es.mityc.javasign.utils.Base64Coder.decode((String)hash));
                                }
                                catch (IllegalArgumentException ex) {
                                    LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.5", new Object[]{hash}));
                                }
                            }
                            if (responderData == null) {
                                this.esValido = false;
                                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error101"));
                                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error101"));
                                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error101"));
                                return false;
                            }
                        }
                        identifierOCSP.add(responderData);
                        Date fecha = UtilidadFechas.parseaFechaXML(time.getFirstChild().getNodeValue());
                        if (fecha != null) {
                            identifierTime.add(fecha);
                        } else {
                            this.esValido = false;
                            LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error63"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error63"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error40"));
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error40"));
                        }
                        Element ocspDigest = (Element)ocspRef.getElementsByTagNameNS(esquemaURI, "DigestAlgAndValue").item(0);
                        Node algorithm = ocspDigest.getElementsByTagNameNS(uriDS, "DigestMethod").item(0);
                        Node value = ocspDigest.getElementsByTagNameNS(uriDS, "DigestValue").item(0);
                        ocspDigestAlg.add(algorithm.getAttributes().getNamedItem("Algorithm").getNodeValue());
                        ocspDigestValue.add(value.getFirstChild().getNodeValue());
                    }
                    catch (Exception ex) {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error66"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error66"));
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error66"));
                    }
                    continue;
                }
                LOGGER.debug((Object)I18n.getResource("libreriaxades.validarfirmaxml.error72"));
            }
        }
        Node crlRefs = null;
        NodeList crlRefsList = ((Element)completeRevocationRefs.get(0)).getElementsByTagNameNS(esquemaURI, "CRLRefs");
        if (crlRefsList != null) {
            crlRefs = crlRefsList.item(0);
        }
        if (crlRefs != null && this.esValido) {
            ArrayList<Element> crls = UtilidadTratarNodo.getElementChildNodes((Element)crlRefs, false);
            if (crls == null) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error95 CRLRefs"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error95 CRLRefs"));
                return false;
            }
            int l = crls.size();
            crlURI = new ArrayList<String>(l);
            crlDigestAlg = new ArrayList<String>(l);
            crlDigestValue = new ArrayList<String>(l);
            crlIssuer = new ArrayList<String>(l);
            crlIssuerTime = new ArrayList<Date>(l);
            crlNumber = new ArrayList<BigInteger>(l);
            for (int i = 0; i < l; ++i) {
                Element crl = crls.get(i);
                if (crl == null) continue;
                Element crlDigest = (Element)crl.getElementsByTagNameNS(esquemaURI, "DigestAlgAndValue").item(0);
                Node algorithm = crlDigest.getElementsByTagNameNS(uriDS, "DigestMethod").item(0);
                Node value = crlDigest.getElementsByTagNameNS(uriDS, "DigestValue").item(0);
                crlDigestAlg.add(algorithm.getAttributes().getNamedItem("Algorithm").getNodeValue());
                crlDigestValue.add(value.getFirstChild().getNodeValue());
                Element identifier = (Element)crl.getElementsByTagNameNS(esquemaURI, "CRLIdentifier").item(0);
                try {
                    crlURI.add(URLDecoder.decode(identifier.getAttributes().getNamedItem(this.tipoUri).getNodeValue(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error30"), (Throwable)e);
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error33"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error33"));
                }
                catch (NullPointerException e) {
                    LOGGER.warn((Object)I18n.getResource("libreriaxades.validarfirmaxml.error161"));
                }
                catch (Exception e) {
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error30"), (Throwable)e);
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error33"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error33"));
                }
                try {
                    Node issuer = identifier.getElementsByTagNameNS(esquemaURI, "Issuer").item(0);
                    Node issuerTime = identifier.getElementsByTagNameNS(esquemaURI, "IssueTime").item(0);
                    Node number = identifier.getElementsByTagNameNS(esquemaURI, "Number").item(0);
                    String crlIssuerName = issuer.getFirstChild().getNodeValue();
                    try {
                        X500Principal prin = new X500Principal(crlIssuerName);
                        crlIssuer.add(prin.getName());
                    }
                    catch (IllegalArgumentException ex) {
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.firmaxml.error44"));
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error23"), (Throwable)ex);
                        logv.error(I18n.getResource("libreriaxades.firmaxml.error44"));
                        return false;
                    }
                    catch (NullPointerException ex) {
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.firmaxml.error44"));
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error23"), (Throwable)ex);
                        logv.error(I18n.getResource("libreriaxades.firmaxml.error44"));
                        return false;
                    }
                    Date fecha = UtilidadFechas.parseaFechaXML(issuerTime.getFirstChild().getNodeValue());
                    if (fecha != null) {
                        crlIssuerTime.add(fecha);
                    } else {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error63"));
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error40"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error63"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error40"));
                    }
                    if (number != null) {
                        crlNumber.add(new BigInteger(number.getFirstChild().getNodeValue()));
                        continue;
                    }
                    crlNumber.add(null);
                    continue;
                }
                catch (Exception ex) {
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error66"), (Throwable)ex);
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error66"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error66"));
                }
            }
        }
        ArrayList<Object> certificateValues = new ArrayList();
        ArrayList<Object> revocationValues = new ArrayList();
        try {
            certificateValues = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CertificateValues"));
            revocationValues = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "RevocationValues"));
        }
        catch (FirmaXMLError e) {
            LOGGER.debug((Object)e.getMessage(), (Throwable)e);
        }
        boolean certsYOcspInterno = false;
        if (certificateValues.size() != 0 && revocationValues.size() != 0) {
            certsYOcspInterno = true;
        }
        if (ocspDigestValue != null && ocspDigestValue.size() != 0 && this.esValido) {
            int ocspNum = ocspDigestValue.size();
            OCSPResponderID responderData = null;
            byte[] respuesta = null;
            respuestasOCSP = new ArrayList<OCSPResp>(ocspNum);
            for (int x = 0; x < ocspNum && this.esValido; ++x) {
                if (certsYOcspInterno) {
                    Node ocsp = null;
                    if (ocspURI != null && ocspURI.size() == ocspNum && (uri = (String)ocspURI.get(x)).startsWith("#")) {
                        ocsp = UtilidadTratarNodo.getElementById(firma.getElementsByTagNameNS(esquemaURI, "EncapsulatedOCSPValue"), uri.substring(1));
                    }
                    if (ocsp == null) {
                        ocsp = this.buscarRevocationValueOCSP((String)ocspDigestValue.get(x), (String)ocspDigestAlg.get(x), estructuraFirma);
                        if (ocsp == null) {
                            LOGGER.info((Object)(I18n.getResource("libreriaxades.validarfirmaxml.error95") + " " + "RevocationValues"));
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error34"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error95") + " " + "RevocationValues");
                            return this.esValido;
                        }
                        respuesta = Base64.decode(ocsp.getFirstChild().getNodeValue());
                    } else {
                        respuesta = Base64.decode(ocsp.getFirstChild().getNodeValue());
                    }
                } else if (this.recoverManager != null) {
                    props = new HashMap();
                    if (ocspURI != null && ocspURI.size() == ocspNum && ocspURI.get(x) != null) {
                        props.put("uri", ocspURI.get(x));
                    } else {
                        props.put("emission.date", identifierTime.get(x));
                        props.put("digest.algorithm", ocspDigestAlg.get(x));
                        props.put("digest.value", Base64.decode((String)ocspDigestValue.get(x)));
                        OCSPResponderID ocspData = (OCSPResponderID)identifierOCSP.get(x);
                        IOCSPCertStatus.TYPE_RESPONDER typeResponder = ocspData.getTypeResponderID();
                        if (typeResponder != null) {
                            switch (typeResponder) {
                                case BY_NAME: {
                                    props.put("issuer.name", (X500Principal)ocspData.getIdentifierData());
                                    break;
                                }
                                case BY_KEY: {
                                    props.put("issuer.hash", (byte[])ocspData.getIdentifierData());
                                }
                            }
                        } else {
                            try {
                                props.put("issuer.name", new X500Principal((String)ocspData.getIdentifierData()));
                            }
                            catch (IllegalArgumentException ex) {
                                try {
                                    props.put("issuer.hash", Base64.decode((String)ocspData.getIdentifierData()));
                                }
                                catch (IllegalArgumentException ex1) {
                                    LOGGER.warn((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.6"));
                                }
                            }
                        }
                    }
                    IOCSPCertStatus ocsp = null;
                    try {
                        ocsp = (IOCSPCertStatus)this.recoverManager.getElement(props, IOCSPCertStatus.class);
                    }
                    catch (ElementNotFoundException ex) {
                        LOGGER.warn((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.2"), (Throwable)ex);
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace(props);
                        }
                    }
                    catch (UnknownElementClassException ex) {
                        LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.3", new Object[]{"IOCSP"}), (Throwable)ex);
                    }
                    if (ocsp == null) {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error34"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error34"));
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error36"));
                    } else {
                        respuesta = ocsp.getEncoded();
                    }
                }
                String digestOCSPResponse = null;
                if (this.esValido) {
                    resumenCertificadoTemp = UtilidadFirmaElectronica.getMessageDigest((String)ocspDigestAlg.get(x));
                    resumenMensajeByte = resumenCertificadoTemp.digest(respuesta);
                    digestOCSPResponse = new String(Base64Coder.encode(resumenMensajeByte));
                    if (!((String)ocspDigestValue.get(x)).equals(digestOCSPResponse)) {
                        this.esValido = false;
                        LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error38"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error38"));
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error38"));
                    }
                }
                OCSPResp resp = null;
                if (!this.esValido) continue;
                try {
                    resp = new OCSPResp(respuesta);
                }
                catch (IOException e) {
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error150"), (Throwable)e);
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error18"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error18"));
                }
                BasicOCSPResp respuestaBasica = null;
                OCSPResponderID respuestaOCSP = null;
                Date tiempoRespuesta = null;
                try {
                    try {
                        respuestaBasica = (BasicOCSPResp)resp.getResponseObject();
                    }
                    catch (ClassCastException e) {
                        continue;
                    }
                    tiempoRespuesta = respuestaBasica.getProducedAt();
                    ResponderID respID = respuestaBasica.getResponderId().toASN1Object();
                    respuestaOCSP = ASN1Utils.getResponderID(respID);
                }
                catch (OCSPException e) {
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error150"), (Throwable)e);
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error18"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error18"));
                }
                responderData = (OCSPResponderID)identifierOCSP.get(x);
                if (!responderData.equals(respuestaOCSP)) {
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error39"));
                    LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error39"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error39"));
                }
                if (!((Date)identifierTime.get(x)).equals(tiempoRespuesta)) {
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error40"));
                    LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error40"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error40"));
                }
                if (!this.esValido) continue;
                respuestasOCSP.add(resp);
            }
        }
        if (crlDigestValue != null && crlDigestValue.size() != 0 && this.esValido) {
            int crlNum = crlDigestValue.size();
            X509CRL x509CRL = null;
            crlList = new ArrayList<X509CRL>(crlNum);
            for (int x = 0; x < crlNum && this.esValido; ++x) {
                if (certsYOcspInterno) {
                    byte[] crl = null;
                    Node crlValue = null;
                    if (crlURI != null && crlURI.size() == crlNum && (uri = (String)crlURI.get(x)).startsWith("#")) {
                        crlValue = UtilidadTratarNodo.getElementById(firma.getElementsByTagNameNS(esquemaURI, "EncapsulatedCRLValue"), uri.substring(1));
                    }
                    if (crlValue == null) {
                        crlValue = this.buscarRevocationValueCRL((String)crlDigestValue.get(x), (String)crlDigestAlg.get(x), estructuraFirma);
                        if (crlValue == null) {
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error151"));
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error41"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error41"));
                            return this.esValido;
                        }
                        crl = Base64.decode(crlValue.getFirstChild().getNodeValue());
                    } else {
                        crl = Base64.decode(crlValue.getFirstChild().getNodeValue());
                    }
                    if (crl != null) {
                        try {
                            ByteArrayInputStream bais = new ByteArrayInputStream(crl);
                            CertificateFactory certificatefactory = CertificateFactory.getInstance("X.509");
                            x509CRL = (X509CRL)certificatefactory.generateCRL(bais);
                        }
                        catch (CertificateException e) {
                            LOGGER.error((Object)I18n.getResource("libreriaxades.firmaxml.error23"), (Throwable)e);
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error154"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error154"));
                        }
                        catch (CRLException e) {
                            LOGGER.error((Object)I18n.getResource("libreriaxades.firmaxml.error44"), (Throwable)e);
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error154"));
                            logv.error(I18n.getResource("libreriaxades.firmaxml.error44"));
                        }
                    } else {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error151"));
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error41"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error41"));
                    }
                } else if (this.recoverManager != null) {
                    HashMap props2 = new HashMap();
                    if (crlURI != null && crlURI.size() == crlNum && crlURI.get(x) != null) {
                        props2.put("uri", crlURI.get(x));
                    }
                    X509CRL x509crl = null;
                    try {
                        x509crl = (X509CRL)this.recoverManager.getElement(props2, X509CRL.class);
                    }
                    catch (ElementNotFoundException ex) {
                        LOGGER.warn((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.2"));
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace(props2);
                        }
                    }
                    catch (UnknownElementClassException ex) {
                        LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.3", new Object[]{"X509CRL"}), (Throwable)ex);
                    }
                    if (x509crl == null) {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error152"));
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error42"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error152"));
                    } else {
                        x509CRL = x509crl;
                    }
                }
                String digestCRLResponse = null;
                if (this.esValido) {
                    MessageDigest resumenCRLTemp = UtilidadFirmaElectronica.getMessageDigest((String)crlDigestAlg.get(x));
                    try {
                        byte[] resumenMensajeByte2 = resumenCRLTemp.digest(x509CRL.getEncoded());
                        digestCRLResponse = new String(Base64Coder.encode(resumenMensajeByte2));
                        if (!((String)crlDigestValue.get(x)).equals(digestCRLResponse)) {
                            this.esValido = false;
                            LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error43"));
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error43"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error43"));
                        }
                    }
                    catch (CRLException ex) {
                        this.esValido = false;
                        LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error43"));
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error43"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error43"));
                    }
                }
                if (this.esValido && x509CRL != null) {
                    BigInteger numeroNodo;
                    X509Principal prin2;
                    X509Principal prin1 = new X509Principal((String)crlIssuer.get(x));
                    if (!prin1.equals((Object)(prin2 = new X509Principal(x509CRL.getIssuerX500Principal().getName())))) {
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error45"));
                        LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error45"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error45"));
                    }
                    Date time = x509CRL.getThisUpdate();
                    if (!((Date)crlIssuerTime.get(x)).equals(time)) {
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error46"));
                        LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error46"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error46"));
                    }
                    if ((numeroNodo = (BigInteger)crlNumber.get(x)) != null) {
                        BigInteger numeroRecuperado = null;
                        DERInteger derInt = null;
                        ASN1InputStream ais = new ASN1InputStream(x509CRL.getExtensionValue("2.5.29.20"));
                        try {
                            ais = new ASN1InputStream(((DEROctetString)ais.readObject()).getOctets());
                            derInt = (DERInteger)ais.readObject();
                        }
                        catch (IOException e) {
                            this.esValido = false;
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error47"), (Throwable)e);
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error47"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error47"));
                        }
                        numeroRecuperado = derInt.getValue();
                        if (!numeroNodo.equals(numeroRecuperado)) {
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error48"));
                            LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error48"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error48"));
                        }
                    }
                }
                if (!this.esValido) continue;
                crlList.add(x509CRL);
            }
        }
        int numCert = digestValue.size();
        ArrayList<Certificate> certsDeURI = new ArrayList<Certificate>();
        Certificate certificado = null;
        for (int x = 0; x < numCert && this.esValido; ++x) {
            if (certsYOcspInterno) {
                Node certValue = null;
                if (certURI != null && certURI.size() == numCert && (uri = (String)certURI.get(x)).startsWith("#")) {
                    certValue = UtilidadTratarNodo.getElementById(firma.getElementsByTagNameNS(esquemaURI, "EncapsulatedX509Certificate"), ((String)certURI.get(x)).substring(1));
                }
                if (certValue == null) {
                    certificado = this.buscarCertificateValue((X500Principal)issuerName.get(x), new BigInteger((String)issuerSerial.get(x)), estructuraFirma);
                    if (certificado == null) {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error155"));
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error49"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error155"));
                        return this.esValido;
                    }
                } else {
                    try {
                        ByteArrayInputStream bais = new ByteArrayInputStream(Base64.decode(certValue.getFirstChild().getNodeValue()));
                        CertificateFactory cf = CertificateFactory.getInstance("X.509");
                        certificado = (X509Certificate)cf.generateCertificate(bais);
                    }
                    catch (CertificateException e1) {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.firmaxml.error23"), (Throwable)e1);
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error156"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error156"));
                    }
                }
            } else if (this.recoverManager != null) {
                props = new HashMap<String, Object>();
                if (certURI != null && certURI.size() == numCert && certURI.get(x) != null) {
                    props.put("uri", certURI.get(x));
                }
                X509Certificate x509cert = null;
                try {
                    x509cert = (X509Certificate)this.recoverManager.getElement(props, X509Certificate.class);
                }
                catch (ElementNotFoundException ex) {
                    LOGGER.warn((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.2"));
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace(props);
                    }
                }
                catch (UnknownElementClassException ex) {
                    LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.3", new Object[]{"X509Certificate"}), (Throwable)ex);
                }
                if (x509cert == null) {
                    LOGGER.error((Object)i18n.getLocalMessage("i18n.mityc.xades.validate.4", new Object[]{certURI, x}));
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error50"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error50"));
                } else {
                    certificado = x509cert;
                }
            }
            String resumenCertificado = "";
            try {
                resumenCertificadoTemp = UtilidadFirmaElectronica.getMessageDigest((String)digestAlg.get(x));
                if (resumenCertificadoTemp == null) {
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.firmaxml.error16") + ": " + (String)digestAlg.get(x));
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error52"));
                    logv.error(I18n.getResource("libreriaxades.firmaxml.error16") + ": " + (String)digestAlg.get(x));
                    return false;
                }
                resumenMensajeByte = resumenCertificadoTemp.digest(certificado.getEncoded());
                resumenCertificado = new String(Base64Coder.encode(resumenMensajeByte));
            }
            catch (CertificateEncodingException e) {
                LOGGER.error((Object)(I18n.getResource("libreriaxades.firmaxml.error23") + ": " + e.getMessage()), (Throwable)e);
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error52"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error52"));
            }
            if (!((String)digestValue.get(x)).equals(resumenCertificado)) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error53"));
                LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error53"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error53"));
            }
            if (!((String)issuerSerial.get(x)).equals(((X509Certificate)certificado).getSerialNumber().toString())) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error54"));
                LOGGER.info((Object)I18n.getResource("libreriaxades.validarfirmaxml.error54"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error54"));
            }
            if (!this.esValido) continue;
            certsDeURI.add(certificado);
        }
        this.cadenaCertificados.addAll(certsDeURI);
        ArrayList<ArrayList<X509Certificate>> certChains = UtilidadCertificados.filterCertPathsArrays(UtilidadCertificados.getCertPathsArray(this.cadenaCertificados), UtilidadCertificados.Filter.SIGN_SIGNER);
        if (certChains.size() > 1) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error84"));
            LOGGER.info((Object)(I18n.getResource("libreriaxades.validarfirmaxml.error84") + ": " + certChains.size()));
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error84") + ": " + certChains.size());
            return false;
        }
        this.cadenaCertificados = certChains.get(0);
        Iterator<X509Certificate> certGenIter = this.cadenaCertificados.iterator();
        ArrayList<X509Certificate> cadenaClon = new ArrayList<X509Certificate>(this.cadenaCertificados);
        cadenaClon.remove(0);
        certGenIter.next();
        int certRefLenght = digestValue.size();
        block78: while (certGenIter.hasNext()) {
            X509Certificate certAValidar = certGenIter.next();
            for (int i = 0; i < certRefLenght && this.esValido; ++i) {
                X500Principal issuer = (X500Principal)issuerName.get(i);
                BigInteger serial = new BigInteger((String)issuerSerial.get(i));
                String alg = (String)digestAlg.get(i);
                byte[] value = Base64Coder.decode((String)digestValue.get(i));
                if (!issuer.equals(certAValidar.getIssuerX500Principal()) || !serial.equals(certAValidar.getSerialNumber())) continue;
                MessageDigest haseador = UtilidadFirmaElectronica.getMessageDigest(alg);
                byte[] digestCert = null;
                try {
                    digestCert = haseador.digest(certAValidar.getEncoded());
                }
                catch (CertificateEncodingException e) {
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error52"));
                    LOGGER.error((Object)(I18n.getResource("libreriaxades.validarfirmaxml.error23") + ": " + e.getMessage()), (Throwable)e);
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error52"));
                    return false;
                }
                if (!Utilidades.isEqual(digestCert, value)) continue;
                cadenaClon.remove(certAValidar);
                continue block78;
            }
        }
        if (cadenaClon.size() > 0) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error67"));
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error67"));
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error67"));
            return false;
        }
        this.datosFirma.setCadenaFirma(UtilidadCertificados.convertCertPath(this.cadenaCertificados));
        if (this.esValido) {
            boolean tieneError = false;
            int numCadenaCerts = this.cadenaCertificados.size();
            for (int i = 0; i < numCadenaCerts; ++i) {
                boolean hasNext;
                X509Certificate certAValidar = this.cadenaCertificados.get(i);
                X509Certificate certIssuer = null;
                certIssuer = i < numCadenaCerts - 1 ? this.cadenaCertificados.get(i + 1) : certAValidar;
                CertificateID certificadoId = null;
                try {
                    certificadoId = new CertificateID("1.3.14.3.2.26", certIssuer, certAValidar.getSerialNumber());
                }
                catch (OCSPException ex) {
                    LOGGER.error((Object)(I18n.getResource("libreriaxades.validarfirmaxml.error158") + ": " + ex.getMessage()), (Throwable)ex);
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error56"));
                    if (i == 0) {
                        logv.abreTag(false);
                        logv.info("Certificate chain status:", 2);
                        tieneError = true;
                    }
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error158") + ": " + ex.getMessage(), 2);
                    break;
                }
                int good = 0;
                int revoked = 0;
                DatosOCSP datosOCSP = null;
                DatosCRL datosCRL = null;
                BasicOCSPResp basicOcsp = null;
                if (respuestasOCSP != null) {
                    Iterator itRespOCSP = respuestasOCSP.iterator();
                    hasNext = itRespOCSP.hasNext();
                    while (hasNext && this.esValido) {
                        OCSPResp respuestaOCSP = (OCSPResp)itRespOCSP.next();
                        try {
                            basicOcsp = (BasicOCSPResp)respuestaOCSP.getResponseObject();
                        }
                        catch (OCSPException e) {
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error118"), (Throwable)e);
                            if (i == 0) {
                                logv.abreTag(false);
                                logv.info("Certificate chain status:", 2);
                                tieneError = true;
                            }
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error118"), 2);
                            break;
                        }
                        hasNext = itRespOCSP.hasNext();
                        SingleResp[] singleResps = basicOcsp.getResponses();
                        int numSingleResps = singleResps.length;
                        for (int j = 0; j < numSingleResps; ++j) {
                            if (!certificadoId.equals((Object)singleResps[j].getCertID())) continue;
                            Object obj = singleResps[j].getCertStatus();
                            if (obj == null) {
                                ++good;
                                if (i == 0) {
                                    logv.abreTag(true);
                                    logv.info("Certificate chain status:", 2);
                                }
                                logv.info("Certificate: " + certAValidar.getSubjectDN() + " is VALID (OCSP response: " + ((OCSPResponderID)identifierOCSP.get(i)).toString() + ")", 2);
                                datosOCSP = new DatosOCSP();
                                datosOCSP.setResponderId(basicOcsp.getResponderId().toASN1Object());
                                datosOCSP.setCertConsultado(certAValidar.getSubjectX500Principal().toString());
                                datosOCSP.setFechaConsulta(basicOcsp.getProducedAt());
                                datosOCSP.setRespuestaOCSP(respuestaOCSP);
                                try {
                                    datosOCSP.setCertOCSPResponder(basicOcsp.getCerts("SUN"));
                                }
                                catch (NoSuchProviderException e) {
                                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                                }
                                catch (OCSPException e) {
                                    LOGGER.error((Object)e.getMessage(), (Throwable)e);
                                }
                                this.arrayDatosOCSP.add(datosOCSP);
                                continue;
                            }
                            if (!(obj instanceof RevokedStatus)) continue;
                            ++revoked;
                            if (i == 0) {
                                logv.abreTag(false);
                                logv.info("Certificate chain status:", 2);
                                tieneError = true;
                            }
                            logv.error("Certificate: " + certificadoId + " is REVOKED (OCSP response: " + basicOcsp.getResponderId() + ")", 2);
                            break;
                        }
                        if (revoked <= 0) continue;
                        break;
                    }
                }
                if (crlList != null) {
                    Iterator itCRLList = crlList.iterator();
                    hasNext = itCRLList.hasNext();
                    while (hasNext && this.esValido) {
                        X509CRL x509CRL = (X509CRL)itCRLList.next();
                        hasNext = itCRLList.hasNext();
                        if (!x509CRL.getIssuerX500Principal().getName().equals(certIssuer.getSubjectX500Principal().getName()) || ((Object)certAValidar.getSubjectDN()).equals(certAValidar.getIssuerDN())) continue;
                        if (x509CRL.isRevoked(certAValidar)) {
                            ++revoked;
                            if (i == 0) {
                                logv.abreTag(false);
                                logv.info("Certificate chain status:", 2);
                                tieneError = true;
                            }
                            logv.error("Certificate: " + certAValidar.getSubjectDN() + " is REVOKED (CRL response: " + x509CRL.getIssuerX500Principal().getName() + ")", 2);
                            break;
                        }
                        ++good;
                        if (i == 0) {
                            logv.abreTag(true);
                            logv.info("Certificate chain status:", 2);
                        }
                        logv.info("Certificate: " + certAValidar.getSubjectDN() + " is VALID (CRL response: " + x509CRL.getIssuerX500Principal().getName() + ")", 2);
                        datosCRL = new DatosCRL();
                        datosCRL.setIssuer(x509CRL.getIssuerX500Principal().getName());
                        datosCRL.setFechaEmision(x509CRL.getThisUpdate());
                        datosCRL.setFechaCaducidad(x509CRL.getNextUpdate());
                        datosCRL.setX509CRL(x509CRL);
                        this.arrayDatosCRL.add(datosCRL);
                    }
                    if (revoked > 0) break;
                }
                if (revoked == 0 && good == 0) {
                    if (((Object)certAValidar.getSubjectDN()).equals(certAValidar.getIssuerDN())) continue;
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error67"));
                    if (i == 0) {
                        logv.abreTag(false);
                        logv.info("Certificate chain status:", 2);
                        tieneError = true;
                    }
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error67"), 2);
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error67"));
                    break;
                }
                if (revoked <= 0 && good != 0) continue;
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error57"));
                if (i == 0) {
                    logv.abreTag(false);
                    logv.info("Certificate chain status:", 2);
                    tieneError = true;
                }
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error57"), 2);
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error57"));
                break;
            }
            logv.cierraTag(!tieneError);
        }
        return this.esValido;
    }

    private boolean validaXadesA(EstructuraFirma estructuraFirma) throws Exception {
        Element firma = estructuraFirma.firma;
        String esquemaURI = estructuraFirma.esquema.getSchemaUri();
        Element archiveTimeStampNode = null;
        ArrayList<Object> nodesArchiveTimeStamp = new ArrayList();
        try {
            nodesArchiveTimeStamp = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "ArchiveTimeStamp"));
        }
        catch (FirmaXMLError e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        int numNodes = nodesArchiveTimeStamp.size();
        if (numNodes == 0) {
            this.esValido = false;
            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error15"));
            LOGGER.error((Object)"El sello de tiempo del nivel XAdES-A, no es v\u00e1lido");
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error8") + " " + I18n.getResource("libreriaxades.validarfirmaxml.error9") + " " + I18n.getResource("libreriaxades.validarfirmaxml.error10"));
            return this.esValido;
        }
        TSValidacion tsv2 = null;
        DatosSelloTiempo datosSelloTiempo = null;
        byte[] byteData = null;
        for (int i = 0; i < numNodes; ++i) {
            archiveTimeStampNode = (Element)nodesArchiveTimeStamp.get(i);
            datosSelloTiempo = new DatosSelloTiempo();
            if ("http://uri.etsi.org/01903/v1.1.1#".equals(esquemaURI) || "http://uri.etsi.org/01903/v1.2.2#".equals(esquemaURI)) {
                ArrayList<String> inc = UtilidadXadesA.obtenerListadoIdsElementosXadesA(esquemaURI, estructuraFirma.xmlSig, archiveTimeStampNode);
                ArrayList<Element> incNodes = UtilidadTratarNodo.obtenerNodos(archiveTimeStampNode, 1, new NombreNodo(esquemaURI, "Include"));
                String uriIncludeObtenida = null;
                Element incNode = null;
                String uriIncludeLeida = null;
                for (int j = 0; j < inc.size(); ++j) {
                    uriIncludeObtenida = inc.get(j);
                    if (uriIncludeObtenida.equals(uriIncludeLeida = (incNode = incNodes.get(j)).getAttribute("URI"))) continue;
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error15"));
                    LOGGER.error((Object)"El sello de tiempo del nivel XAdES-A, no es v\u00e1lido. Los nodos Include no coinciden con los esperados");
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error15"));
                    return this.esValido;
                }
            }
            byteData = UtilidadXadesA.obtenerListadoXadesA(esquemaURI, estructuraFirma.xmlSig, archiveTimeStampNode);
            NodeList nodesEncapsulatedTimeStamp = archiveTimeStampNode.getElementsByTagNameNS(esquemaURI, "EncapsulatedTimeStamp");
            if (nodesEncapsulatedTimeStamp.getLength() != 1) {
                this.esValido = false;
                LOGGER.error((Object)(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "EncapsulatedTimeStamp" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + nodesEncapsulatedTimeStamp.getLength()));
                logv.error(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "EncapsulatedTimeStamp" + I18n.getResource("libreriaxades.firmaxml.error37") + " " + nodesEncapsulatedTimeStamp.getLength());
                this.resultado.setLog("El sello de tiempo XAdES-A no es v\u00e1lido");
                return this.esValido;
            }
            Element encapsulatedTimeStampElement = (Element)nodesEncapsulatedTimeStamp.item(0);
            String enc = encapsulatedTimeStampElement.getAttribute("Encoding");
            EncodingEnum encoding = EncodingEnum.getEncoding(enc);
            if (encoding == null) {
                this.esValido = false;
                LOGGER.error((Object)("Encoding del sello de tiempo A desconocido: " + enc));
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error171"));
                return this.esValido;
            }
            String encapsulatedTS = encapsulatedTimeStampElement.getFirstChild().getNodeValue();
            byte[] timeStampBytes = Base64.decode(encapsulatedTS);
            try {
                tsv2 = TSValidator.validarSelloTiempo((byte[])byteData, (byte[])timeStampBytes);
            }
            catch (NoSuchAlgorithmException e) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error149"));
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                logv.error(e.getMessage());
                return this.esValido;
            }
            catch (NoSuchProviderException e) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error149"));
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                logv.error(e.getMessage());
                return this.esValido;
            }
            catch (CertStoreException e) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error149"));
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                logv.error(e.getMessage());
                return this.esValido;
            }
            catch (TSPException e) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error149"));
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                logv.error(e.getMessage());
                return this.esValido;
            }
            catch (IOException e) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error149"));
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                logv.error(e.getMessage());
                return this.esValido;
            }
            catch (TSClienteError e) {
                this.esValido = false;
                this.resultado.setLog(e.getMessage());
                LOGGER.error((Object)e.getMessage(), (Throwable)e);
                logv.error(e.getMessage());
                return this.esValido;
            }
            if (!tsv2.isRespuesta()) {
                this.esValido = false;
                LOGGER.info((Object)"El sello de tiempo XAdES-A no es v\u00e1lido");
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error15"));
                this.resultado.setLog("El sello de tiempo XAdES-A no es v\u00e1lido");
                return this.esValido;
            }
            Date fechaSello = tsv2.getFechaDate();
            if (fechaSello != null && fechaSello.after(new Date(System.currentTimeMillis()))) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error82"));
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error82"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error82"));
                return this.esValido;
            }
            try {
                datosSelloTiempo.setFecha(fechaSello);
                datosSelloTiempo.setEmisor(tsv2.getEmisor());
                datosSelloTiempo.setAlgoritmo(TSPAlgoritmos.getAlgName((String)tsv2.getSelloAlg()));
                datosSelloTiempo.setPrecision(tsv2.getPrecisionLong());
                datosSelloTiempo.setTipoSello(TipoSellosTiempo.CLASE_A);
                datosSelloTiempo.setTst(tsv2.getTst());
                if (this.esValido) {
                    logv.abreTag(true);
                    logv.info("XAdES-A TimeStamp validation: VALID", 2);
                    logv.info("Date: " + fechaSello, 2);
                    logv.info("Issuer: " + tsv2.getEmisor(), 2);
                    logv.cierraTag(true);
                } else {
                    logv.abreTag(false);
                    logv.info("XAdES-A TimeStamp validation: INVALID", 2);
                    logv.info("Date: " + fechaSello, 2);
                    logv.info("Issuer: " + tsv2.getEmisor(), 2);
                    logv.cierraTag(false);
                }
            }
            catch (Exception e) {
                this.esValido = false;
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error64"), (Throwable)e);
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error64"));
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error64"));
                return this.esValido;
            }
            this.arrayDatosSello.add(datosSelloTiempo);
        }
        return true;
    }

    private X509Certificate buscarCertificateValue(X500Principal certIssuer, BigInteger serialNumber, EstructuraFirma estructuraFirma) {
        Element firma = estructuraFirma.firma;
        String esquemaURI = estructuraFirma.esquema.getSchemaUri();
        X509Certificate certificado = null;
        CertificateValues certificateValues = new CertificateValues(estructuraFirma.esquema);
        ArrayList<Object> certificateValuesNodeList = new ArrayList();
        try {
            certificateValuesNodeList = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CertificateValues"));
        }
        catch (FirmaXMLError e) {
            LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        int certLength = certificateValuesNodeList.size();
        for (int i = 0; i < certLength; ++i) {
            try {
                certificateValues.load((Element)certificateValuesNodeList.get(i));
            }
            catch (InvalidInfoNodeException e) {
                LOGGER.debug((Object)e.getMessage(), (Throwable)e);
                return null;
            }
            ArrayList<EncapsulatedX509Certificate> certificados = certificateValues.getCertificates();
            int certificadosLength = certificados.size();
            for (int j = 0; j < certificadosLength; ++j) {
                EncapsulatedX509Certificate certEncapsulated = certificados.get(j);
                try {
                    certificado = certEncapsulated.getX509Certificate();
                }
                catch (CertificateException e) {
                    LOGGER.debug((Object)e.getMessage(), (Throwable)e);
                    return null;
                }
                if (!certIssuer.equals(certificado.getIssuerX500Principal()) || !serialNumber.equals(certificado.getSerialNumber())) continue;
                return certificado;
            }
        }
        return null;
    }

    private Element buscarRevocationValueOCSP(String digest, String method, EstructuraFirma estructuraFirma) {
        Element firma = estructuraFirma.firma;
        String esquemaURI = estructuraFirma.esquema.getSchemaUri();
        ArrayList<Object> revocationValuesNodeList = new ArrayList();
        try {
            revocationValuesNodeList = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "RevocationValues"));
        }
        catch (FirmaXMLError e) {
            LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        int revocationLength = revocationValuesNodeList.size();
        block4: for (int i = 0; i < revocationLength; ++i) {
            Element revocationValuesElement = (Element)revocationValuesNodeList.get(i);
            NodeList ocspValues = revocationValuesElement.getElementsByTagNameNS(esquemaURI, "OCSPValues");
            if (ocspValues.getLength() != 1) {
                LOGGER.error((Object)(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "OCSPValues" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + ocspValues.getLength()));
                logv.error(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "OCSPValues" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + ocspValues.getLength());
                return null;
            }
            ArrayList<Element> respuestasOCSP = UtilidadTratarNodo.getElementChildNodes((Element)ocspValues.item(0), false);
            if (respuestasOCSP == null) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error95 OCSPValues"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error95 OCSPValues"));
                return null;
            }
            int respuestasOCSPLength = respuestasOCSP.size();
            for (int j = 0; j < respuestasOCSPLength; ++j) {
                byte[] data;
                Element respuestaOCSPElement;
                block10: {
                    respuestaOCSPElement = respuestasOCSP.get(j);
                    if (!new NombreNodo(esquemaURI, "EncapsulatedOCSPValue").equals(new NombreNodo(respuestaOCSPElement.getNamespaceURI(), respuestaOCSPElement.getLocalName()))) {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error119"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error119"));
                        return null;
                    }
                    data = null;
                    String encapsulatedValue = respuestaOCSPElement.getFirstChild().getNodeValue();
                    if (encapsulatedValue != null) {
                        try {
                            data = Base64Coder.decode(encapsulatedValue);
                            break block10;
                        }
                        catch (IllegalArgumentException ex) {
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error120"), (Throwable)ex);
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error120"));
                            continue block4;
                        }
                    }
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error121"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error121"));
                    return null;
                }
                MessageDigest resumenTemp = UtilidadFirmaElectronica.getMessageDigest(method);
                byte[] resumenMensajeByte = resumenTemp.digest(data);
                String digestLeido = new String(Base64Coder.encode(resumenMensajeByte));
                if (!digest.equals(digestLeido)) continue;
                return respuestaOCSPElement;
            }
        }
        return null;
    }

    private Element buscarRevocationValueCRL(String digest, String method, EstructuraFirma estructuraFirma) {
        Element firma = estructuraFirma.firma;
        String esquemaURI = estructuraFirma.esquema.getSchemaUri();
        ArrayList<Object> revocationValuesNodeList = new ArrayList();
        try {
            revocationValuesNodeList = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "RevocationValues"));
        }
        catch (FirmaXMLError e) {
            LOGGER.debug((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        int revocationLength = revocationValuesNodeList.size();
        block4: for (int i = 0; i < revocationLength; ++i) {
            Element revocationValuesElement = (Element)revocationValuesNodeList.get(i);
            NodeList crlValues = revocationValuesElement.getElementsByTagNameNS(esquemaURI, "CRLValues");
            if (crlValues.getLength() != 1) {
                LOGGER.error((Object)(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "CRLValues" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + crlValues.getLength()));
                logv.error(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "CRLValues" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + crlValues.getLength());
                return null;
            }
            ArrayList<Element> crls = UtilidadTratarNodo.getElementChildNodes((Element)crlValues.item(0), false);
            if (crls == null) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error95 CRLValues"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error95 CRLValues"));
                return null;
            }
            int crlsLength = crls.size();
            for (int j = 0; j < crlsLength; ++j) {
                byte[] data;
                Element crlElement;
                block10: {
                    crlElement = crls.get(j);
                    if (!new NombreNodo(esquemaURI, "EncapsulatedCRLValue").equals(new NombreNodo(crlElement.getNamespaceURI(), crlElement.getLocalName()))) {
                        LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error122"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error122"));
                        return null;
                    }
                    data = null;
                    String encapsulatedValue = crlElement.getFirstChild().getNodeValue();
                    if (encapsulatedValue != null) {
                        try {
                            data = Base64Coder.decode(encapsulatedValue);
                            break block10;
                        }
                        catch (IllegalArgumentException ex) {
                            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error123"), (Throwable)ex);
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error123"));
                            continue block4;
                        }
                    }
                    LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error124"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error124"));
                    return null;
                }
                MessageDigest resumenTemp = UtilidadFirmaElectronica.getMessageDigest(method);
                byte[] resumenMensajeByte = resumenTemp.digest(data);
                String digestLeido = new String(Base64Coder.encode(resumenMensajeByte));
                if (!digest.equals(digestLeido)) continue;
                return crlElement;
            }
        }
        return null;
    }

    private DatosTipoFirma tipoFirma(EstructuraFirma estructuraFirma) throws BadFormedSignatureException {
        Element firma = estructuraFirma.firma;
        String esquema = estructuraFirma.esquema.getSchemaUri();
        DatosTipoFirma datosTipoFirma = new DatosTipoFirma();
        boolean esXAdES_C = false;
        boolean esXAdES_X = false;
        datosTipoFirma.setTipoXAdES(EnumFormatoFirma.XAdES_BES);
        ArrayList<Element> nodosObject = UtilidadTratarNodo.obtenerNodos(firma, null, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "Object"));
        Iterator<Element> itObject = nodosObject.iterator();
        int numQualifyingProperties = 0;
        while (itObject.hasNext()) {
            ArrayList<Element> nodosQualifyingProperties = UtilidadTratarNodo.obtenerNodos(itObject.next(), null, new NombreNodo(esquema, "QualifyingProperties"));
            numQualifyingProperties += nodosQualifyingProperties.size();
        }
        if (numQualifyingProperties != 1) {
            LOGGER.error((Object)(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "QualifyingProperties" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + numQualifyingProperties));
            logv.error(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "QualifyingProperties" + " " + I18n.getResource("libreriaxades.firmaxml.error37") + " " + numQualifyingProperties);
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error125"));
        }
        ArrayList<Object> nodosSignaturePolicyIdentifier = new ArrayList();
        try {
            nodosSignaturePolicyIdentifier = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquema, "SignaturePolicyIdentifier"));
        }
        catch (FirmaXMLError e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error126"));
        }
        int numSignaturePolicyIdentifier = nodosSignaturePolicyIdentifier.size();
        if (numSignaturePolicyIdentifier > 1) {
            LOGGER.error((Object)(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "SignaturePolicyIdentifier" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + numSignaturePolicyIdentifier));
            logv.error(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "SignaturePolicyIdentifier" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + numSignaturePolicyIdentifier);
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error126"));
        }
        if ("http://uri.etsi.org/01903/v1.1.1#".equals(esquema) && numSignaturePolicyIdentifier < 1) {
            LOGGER.error((Object)(I18n.getResource("libreriaxades.firmaxml.error33") + " " + "SignaturePolicyIdentifier"));
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error126"));
        }
        if (numSignaturePolicyIdentifier == 1) {
            datosTipoFirma.setEsXAdES_EPES(true);
        }
        ArrayList<Object> nodosSignatureTimeStamp = new ArrayList();
        try {
            nodosSignatureTimeStamp = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquema, "SignatureTimeStamp"));
        }
        catch (FirmaXMLError e) {
            LOGGER.debug((Object)e.getMessage(), (Throwable)e);
        }
        int numSignatureTimeStamp = nodosSignatureTimeStamp.size();
        if (numSignatureTimeStamp > 0) {
            datosTipoFirma.setTipoXAdES(EnumFormatoFirma.XAdES_T);
        }
        ArrayList<Object> nodosCompleteCertificateRefs = new ArrayList();
        ArrayList<Object> nodosCompleteRevocationRefs = new ArrayList();
        try {
            nodosCompleteCertificateRefs = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquema, "CompleteCertificateRefs"));
            nodosCompleteRevocationRefs = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquema, "CompleteRevocationRefs"));
        }
        catch (FirmaXMLError e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error127"));
        }
        int numCompleteCertificateRefs = nodosCompleteCertificateRefs.size();
        int numCompleteRevocationRefs = nodosCompleteRevocationRefs.size();
        if (numCompleteCertificateRefs > 1 || numCompleteCertificateRefs != numCompleteRevocationRefs) {
            if (numCompleteCertificateRefs > 1) {
                LOGGER.error((Object)(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "CompleteCertificateRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + numCompleteCertificateRefs));
                logv.error(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "CompleteCertificateRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + numCompleteCertificateRefs);
            } else {
                LOGGER.error((Object)(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "CompleteRevocationRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + numCompleteRevocationRefs));
                logv.error(I18n.getResource("libreriaxades.firmaxml.error36") + " " + "CompleteRevocationRefs" + " " + I18n.getResource("libreriaxades.firmaxml.error38") + " " + numCompleteRevocationRefs);
            }
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error127"));
        }
        if (numCompleteCertificateRefs == 1 && numCompleteCertificateRefs == numCompleteRevocationRefs) {
            if ("http://uri.etsi.org/01903/v1.1.1#".equals(esquema) && !EnumFormatoFirma.XAdES_T.equals((Object)datosTipoFirma.getTipoXAdES())) {
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error131"));
                throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error127"));
            }
            esXAdES_C = true;
            datosTipoFirma.setTipoXAdES(EnumFormatoFirma.XAdES_C);
        }
        ArrayList<Object> nodosArchiveTimeStamp = new ArrayList();
        ArrayList<Object> nodosCertificateValues = new ArrayList();
        ArrayList<Object> nodosRevocationValues = new ArrayList();
        try {
            nodosArchiveTimeStamp = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquema, "ArchiveTimeStamp"));
            nodosCertificateValues = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquema, "CertificateValues"));
            nodosRevocationValues = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquema, "RevocationValues"));
        }
        catch (FirmaXMLError e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        int numArchiveTimeStamp = nodosArchiveTimeStamp.size();
        int numCertificateValues = nodosCertificateValues.size();
        int numRevocationValues = nodosRevocationValues.size();
        if (numArchiveTimeStamp > 0) {
            if (numCertificateValues < 1 || numRevocationValues < 1) {
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error132"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error132"));
                throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error128"));
            }
            if (numCertificateValues > 1 || numRevocationValues > 1) {
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error133"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error133"));
                throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error128"));
            }
            if ("http://uri.etsi.org/01903/v1.1.1#".equals(esquema) && !esXAdES_C) {
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error134"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error134"));
                throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error128"));
            }
            datosTipoFirma.setEsXAdES_A(true);
        }
        ArrayList<Object> nodosSigAndRefTimeStamp = new ArrayList();
        ArrayList<Object> nodosRefsOnlyTimeStamp = new ArrayList();
        try {
            nodosSigAndRefTimeStamp = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquema, "SigAndRefsTimeStamp"));
            nodosRefsOnlyTimeStamp = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquema, "RefsOnlyTimeStamp"));
        }
        catch (FirmaXMLError e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        int numSigAndRefsTimeStamp = nodosSigAndRefTimeStamp.size();
        int numRefsOnlyTimeStamp = nodosRefsOnlyTimeStamp.size();
        if (numSigAndRefsTimeStamp > 0 || numRefsOnlyTimeStamp > 0) {
            if (!esXAdES_C) {
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error135"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error135"));
                throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error129"));
            }
            esXAdES_X = true;
            datosTipoFirma.setTipoXAdES(EnumFormatoFirma.XAdES_X);
        }
        if (numCertificateValues > 1 || numRevocationValues > 1) {
            LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error133"));
            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error133"));
            throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error128"));
        }
        if (numCertificateValues == 1 && numRevocationValues == 1) {
            if (esXAdES_X) {
                datosTipoFirma.setTipoXAdES(EnumFormatoFirma.XAdES_XL);
            } else if (!datosTipoFirma.esXAdES_A()) {
                LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error137"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error137"));
                throw new BadFormedSignatureException(I18n.getResource("libreriaxades.validarfirmaxml.error130"));
            }
        }
        LOGGER.debug((Object)datosTipoFirma.getTipoXAdES());
        return datosTipoFirma;
    }

    private Date obtenerFechaFirma(EstructuraFirma estructuraFirma) {
        ArrayList<Object> nodesSignTimeValue = new ArrayList();
        Date fechaFirma = null;
        SigningTime momentoFirma = new SigningTime(estructuraFirma.esquema);
        try {
            nodesSignTimeValue = UtilidadTratarNodo.obtenerNodos(estructuraFirma.firma, 5, new NombreNodo(estructuraFirma.esquema.getSchemaUri(), "SigningTime"));
        }
        catch (FirmaXMLError e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
        }
        if (nodesSignTimeValue.size() != 0) {
            try {
                momentoFirma.load((Element)nodesSignTimeValue.get(0));
            }
            catch (InvalidInfoNodeException e) {
                LOGGER.warn((Object)I18n.getResource("libreriaxades.validarfirmaxml.error63"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error63"));
                return null;
            }
            fechaFirma = momentoFirma.getValue();
        }
        if (fechaFirma == null) {
            if (nodesSignTimeValue.size() != 0) {
                LOGGER.warn((Object)I18n.getResource("libreriaxades.validarfirmaxml.error63"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error63"));
            } else {
                LOGGER.warn((Object)I18n.getResource("libreriaxades.validarfirmaxml.error163"));
                logv.info(I18n.getResource("libreriaxades.validarfirmaxml.error163"));
            }
        }
        return fechaFirma;
    }

    private ArrayList<String> obtenerRoles(EstructuraFirma estructuraFirma) {
        String esquemaURI = estructuraFirma.esquema.getSchemaUri();
        ArrayList<String> roles = new ArrayList<String>();
        ArrayList<Element> lst = UtilidadTratarNodo.obtenerNodos(estructuraFirma.signedSignatureProperties, null, new NombreNodo(esquemaURI, "SignerRole"));
        Iterator<Element> it = lst.iterator();
        while (it.hasNext()) {
            NodeList nodesClaimedRoles = it.next().getElementsByTagNameNS(esquemaURI, "ClaimedRole");
            int nodesClaimedRolesLength = nodesClaimedRoles.getLength();
            for (int i = 0; i < nodesClaimedRolesLength; ++i) {
                Element stElement = (Element)nodesClaimedRoles.item(i);
                roles.add(stElement.getTextContent());
            }
        }
        return roles.size() > 0 ? roles : null;
    }

    private EstructuraFirma obtenerEsquema(Element firma) {
        String esquema = null;
        Iterator<String> it = this.esquemasParaValidar.iterator();
        while (it.hasNext()) {
            ArrayList<Element> unsignedSignatureProperties;
            esquema = it.next().trim();
            Element qualifyingElement = null;
            ArrayList<Element> nodosObject = UtilidadTratarNodo.obtenerNodos(firma, null, new NombreNodo("http://www.w3.org/2000/09/xmldsig#", "Object"));
            Iterator<Element> itObject = nodosObject.iterator();
            while (itObject.hasNext()) {
                ArrayList<Element> nodosQualifyingProperties = UtilidadTratarNodo.obtenerNodos(itObject.next(), null, new NombreNodo(esquema, "QualifyingProperties"));
                if (nodosQualifyingProperties.size() <= 0) continue;
                qualifyingElement = nodosQualifyingProperties.get(0);
                break;
            }
            if (qualifyingElement == null) continue;
            EstructuraFirma ef = new EstructuraFirma();
            ef.firma = firma;
            ArrayList<Element> signedProperties = UtilidadTratarNodo.obtenerNodos(qualifyingElement, null, new NombreNodo(esquema, "SignedProperties"));
            if (signedProperties.size() != 1) {
                return null;
            }
            ArrayList<Element> signedSignatureProperties = UtilidadTratarNodo.obtenerNodos(signedProperties.get(0), null, new NombreNodo(esquema, "SignedSignatureProperties"));
            if (signedSignatureProperties.size() != 1) {
                return null;
            }
            ef.signedSignatureProperties = signedSignatureProperties.get(0);
            ArrayList<Element> unsignedProperties = UtilidadTratarNodo.obtenerNodos(qualifyingElement, null, new NombreNodo(esquema, "UnsignedProperties"));
            ef.unsignedSignatureProperties = unsignedProperties.size() != 1 ? null : ((unsignedSignatureProperties = UtilidadTratarNodo.obtenerNodos(unsignedProperties.get(0), null, new NombreNodo(esquema, "UnsignedSignatureProperties"))).size() != 1 ? null : unsignedSignatureProperties.get(0));
            ef.esquema = XAdESSchemas.getXAdESSchema(esquema);
            return ef;
        }
        EstructuraFirma ef = new EstructuraFirma();
        ef.firma = firma;
        return ef;
    }

    /*
     * Unable to fully structure code
     */
    private boolean obtenerCadenaCertificados(EstructuraFirma estructuraFirma) {
        block54: {
            block53: {
                firma = estructuraFirma.firma;
                esquemaURI = estructuraFirma.esquema.getSchemaUri();
                if (firma == null) {
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error76"));
                    ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error76"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error76"));
                    return false;
                }
                certificadoFirma = null;
                certificadosKeyInfo = new ArrayList<X509Certificate>();
                nodosKeyInfo = new ArrayList<E>();
                try {
                    nodosKeyInfo = UtilidadTratarNodo.obtenerNodos(firma, 2, new NombreNodo(this.uriXmlNS, "KeyInfo"));
                }
                catch (FirmaXMLError e) {
                    ValidarFirmaXML.LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
                if (nodosKeyInfo.size() > 0) {
                    nodoKeyInfo = (Element)nodosKeyInfo.get(0);
                    nodosX509Data = nodoKeyInfo.getElementsByTagNameNS(this.uriXmlNS, "X509Data");
                    nodosX509DataLenght = nodosX509Data.getLength();
                    for (i = 0; i < nodosX509DataLenght; ++i) {
                        nodoX509Data = (Element)nodosX509Data.item(i);
                        x509Cert = nodoX509Data.getElementsByTagNameNS(this.uriXmlNS, "X509Certificate");
                        x509CertLenght = x509Cert.getLength();
                        for (x = 0; x < x509CertLenght; ++x) {
                            nodoX509Certificate = x509Cert.item(x);
                            try {
                                bais = new ByteArrayInputStream(Base64.decode(nodoX509Certificate.getFirstChild().getNodeValue()));
                                cf = CertificateFactory.getInstance("X.509");
                                certificadosKeyInfo.add((X509Certificate)cf.generateCertificate(bais));
                                continue;
                            }
                            catch (CertificateException e1) {
                                this.esValido = false;
                                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                                ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error23"), (Throwable)e1);
                                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                                return false;
                            }
                        }
                    }
                } else {
                    certificadoFirma = new DatosX509();
                    nodosSigningCertificate = new ArrayList<E>();
                    try {
                        nodosSigningCertificate = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "SigningCertificate"));
                    }
                    catch (FirmaXMLError e) {
                        ValidarFirmaXML.LOGGER.error((Object)e.getMessage(), (Throwable)e);
                    }
                    if (nodosSigningCertificate.size() == 1) {
                        nodoSigningCertificate = (Node)nodosSigningCertificate.get(0);
                        nodosCert = UtilidadTratarNodo.getElementChildNodes((Element)nodoSigningCertificate, false);
                        if (nodosCert == null) {
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error95 Cert"));
                            logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error95 Cert"));
                            return false;
                        }
                        algoritmo = null;
                        digest = null;
                        nodoCert = nodosCert.get(0);
                        certDigest = (Element)nodoCert.getElementsByTagNameNS(esquemaURI, "CertDigest").item(0);
                        if (certDigest != null) {
                            digAlgs = certDigest.getElementsByTagNameNS(this.uriXmlNS, "DigestMethod");
                            if (digAlgs != null) {
                                certDigestAlgElement = (Element)digAlgs.item(0);
                                algoritmo = certDigestAlgElement.getAttributes().getNamedItem("Algorithm").getNodeValue();
                            }
                            if ((digValues = certDigest.getElementsByTagNameNS(this.uriXmlNS, "DigestValue")) != null) {
                                certDigestValElement = (Element)digValues.item(0);
                                digest = certDigestValElement.getFirstChild().getNodeValue();
                            }
                            certificadoFirma.setAlgMethod(algoritmo);
                            certificadoFirma.setDigestValue(digest);
                        }
                    } else {
                        ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error138"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error138"));
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                        return false;
                    }
                }
                certificadosRef = new ArrayList<X509Certificate>();
                nodosCertValue = new ArrayList<E>();
                try {
                    nodosCertValue = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CertificateValues"));
                }
                catch (FirmaXMLError e) {
                    ValidarFirmaXML.LOGGER.error((Object)e.getMessage(), (Throwable)e);
                }
                if (nodosCertValue.size() <= 0) break block53;
                nodoCertValue = (Element)nodosCertValue.get(0);
                nodosX509Cert = nodoCertValue.getElementsByTagNameNS(esquemaURI, "EncapsulatedX509Certificate");
                nodosX509DataLenght = nodosX509Cert.getLength();
                for (i = 0; i < nodosX509DataLenght; ++i) {
                    nodoX509Cert = (Element)nodosX509Cert.item(i);
                    try {
                        bais = new ByteArrayInputStream(Base64.decode(nodoX509Cert.getFirstChild().getNodeValue()));
                        cf = CertificateFactory.getInstance("X.509");
                        certificadosRef.add((X509Certificate)cf.generateCertificate(bais));
                        continue;
                    }
                    catch (CertificateException e1) {
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                        ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error23"), (Throwable)e1);
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                        return false;
                    }
                }
                break block54;
            }
            nodosCompCertRef = new ArrayList<E>();
            try {
                nodosCompCertRef = UtilidadTratarNodo.obtenerNodos(firma, 5, new NombreNodo(esquemaURI, "CompleteCertificateRefs"));
            }
            catch (FirmaXMLError e) {
                ValidarFirmaXML.LOGGER.error((Object)e.getMessage(), (Throwable)e);
            }
            if (nodosCompCertRef.size() <= 0) break block54;
            nodoCertRefs = UtilidadTratarNodo.getFirstElementChild((Element)nodosCompCertRef.get(0), false);
            if (nodoCertRefs == null) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error95 CertRefs"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error95 CertRefs"));
                return false;
            }
            nodosCert = UtilidadTratarNodo.getElementChildNodes(nodoCertRefs, false);
            if (nodosCert == null) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error95 Cert"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error95 Cert"));
                return false;
            }
            nodosCertSize = nodosCert.size();
            for (i = 0; i < nodosCertSize; ++i) {
                nodoCert = nodosCert.get(i);
                uri = null;
                try {
                    uri = URLDecoder.decode(nodoCert.getAttributes().getNamedItem(this.tipoUri).getNodeValue(), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error30"), (Throwable)e);
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                }
                catch (Exception e) {
                    ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error65"), (Throwable)e);
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error65"));
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                }
                if (uri == null || uri.startsWith("#")) ** GOTO lbl201
                certFile = null;
                if (this.recoverManager != null) {
                    props = new HashMap<String, String>();
                    props.put("uri", uri);
                    try {
                        certFile = (X509Certificate)this.recoverManager.getElement(props, X509Certificate.class);
                    }
                    catch (ElementNotFoundException ex) {
                        ValidarFirmaXML.LOGGER.warn((Object)ValidarFirmaXML.i18n.getLocalMessage("i18n.mityc.xades.validate.2"));
                        if (ValidarFirmaXML.LOGGER.isTraceEnabled()) {
                            ValidarFirmaXML.LOGGER.trace(props);
                        }
                    }
                    catch (UnknownElementClassException ex) {
                        ValidarFirmaXML.LOGGER.error((Object)ValidarFirmaXML.i18n.getLocalMessage("i18n.mityc.xades.validate.3", new Object[]{"X509Certificate"}), (Throwable)ex);
                    }
                }
                if (certFile == null) {
                    ValidarFirmaXML.LOGGER.error((Object)ValidarFirmaXML.i18n.getLocalMessage("i18n.mityc.xades.validate.1", new Object[]{uri}));
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                    logv.error(ValidarFirmaXML.i18n.getLocalMessage("i18n.mityc.xades.validate.1", new Object[]{uri}));
                    return false;
                }
                certElement = (Element)nodoCert;
                certDigest = (Element)certElement.getElementsByTagNameNS(esquemaURI, "CertDigest").item(0);
                alg = null;
                digest = null;
                resumenCertificado = "";
                if (certDigest != null) {
                    algorithm = certDigest.getElementsByTagNameNS(this.uriXmlNS, "DigestMethod").item(0);
                    value = certDigest.getElementsByTagNameNS(this.uriXmlNS, "DigestValue").item(0);
                    alg = algorithm.getAttributes().getNamedItem("Algorithm").getNodeValue();
                    digest = value.getFirstChild().getNodeValue();
                    try {
                        haseador = UtilidadFirmaElectronica.getMessageDigest(alg);
                        if (haseador == null) {
                            this.esValido = false;
                            this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error52"));
                            ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.firmaxml.error16"));
                            logv.error(I18n.getResource("libreriaxades.firmaxml.error16"));
                            return false;
                        }
                        resumenMensajeByte = haseador.digest(certFile.getEncoded());
                        resumenCertificado = new String(Base64Coder.encode(resumenMensajeByte));
                    }
                    catch (CertificateEncodingException e) {
                        ValidarFirmaXML.LOGGER.error((Object)(I18n.getResource("libreriaxades.firmaxml.error23") + " " + e.getMessage()), (Throwable)e);
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error52"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error52") + "\n" + I18n.getResource("libreriaxades.firmaxml.error23") + " " + e.getMessage());
                        return false;
                    }
                    if (!digest.equals(resumenCertificado)) {
                        this.esValido = false;
                        this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error53"));
                        ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error53"));
                        logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error53"));
                        return false;
                    }
                } else {
                    ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error66"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error66"));
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                    this.esValido = false;
                    return false;
lbl201:
                    // 1 sources

                    ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error83"));
                    logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error83"));
                    this.esValido = false;
                    this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error3"));
                    return false;
                }
                certificadosRef.add(certFile);
            }
        }
        certificadosRef.addAll(certificadosKeyInfo);
        certChains = UtilidadCertificados.filterCertPathsArrays(UtilidadCertificados.getCertPathsArray(certificadosRef), UtilidadCertificados.Filter.SIGN_SIGNER);
        certChainsSize = certChains.size();
        if (certChainsSize > 1) {
            encontrado = false;
            if (certificadosKeyInfo.size() != 0) {
                for (i = 0; i < certChainsSize; ++i) {
                    cadena = certChains.get(i);
                    cert = cadena.get(0);
                    if (!cert.equals(certificadosKeyInfo.get(0))) continue;
                    this.cadenaCertificados = cadena;
                    this.datosFirma.setCadenaFirma(UtilidadCertificados.convertCertPath(this.cadenaCertificados));
                    encontrado = true;
                }
            } else if (certificadoFirma != null) {
                haseador = null;
                haseador = UtilidadFirmaElectronica.getMessageDigest(certificadoFirma.getAlgMethod());
                for (i = 0; i < certChainsSize && haseador != null; ++i) {
                    cadena = certChains.get(i);
                    cert = cadena.get(0);
                    digest = null;
                    try {
                        resumenMensajeByte = haseador.digest(cert.getEncoded());
                        digest = new String(Base64Coder.encode(resumenMensajeByte));
                    }
                    catch (CertificateEncodingException e) {
                        ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.firmaxml.error23"), (Throwable)e);
                        logv.error(I18n.getResource("libreriaxades.firmaxml.error23") + " " + e.getMessage());
                    }
                    if (!certificadoFirma.getDigestValue().equals(digest)) continue;
                    this.cadenaCertificados = cadena;
                    this.datosFirma.setCadenaFirma(UtilidadCertificados.convertCertPath(this.cadenaCertificados));
                    encontrado = true;
                }
            }
            if (!encontrado) {
                this.esValido = false;
                this.resultado.setLog(I18n.getResource("libreriaxades.validarfirmaxml.error84"));
                ValidarFirmaXML.LOGGER.error((Object)I18n.getResource("libreriaxades.validarfirmaxml.error84"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error84"));
                return false;
            }
        } else {
            if (certChainsSize == 0) {
                this.esValido = false;
                this.resultado.setLog(ValidarFirmaXML.i18n.getLocalMessage("i18n.mityc.xades.validate.10"));
                ValidarFirmaXML.LOGGER.error((Object)ValidarFirmaXML.i18n.getLocalMessage("i18n.mityc.xades.validate.10"));
                logv.error(I18n.getResource("libreriaxades.validarfirmaxml.error84"));
                return false;
            }
            this.cadenaCertificados = certChains.get(0);
            this.datosFirma.setCadenaFirma(UtilidadCertificados.convertCertPath(this.cadenaCertificados));
        }
        return true;
    }

    private void getConstantesEsquema(XAdESSchemas esquema) {
        if (esquema != null && "http://uri.etsi.org/01903/v1.1.1#".equals(esquema.getSchemaUri())) {
            this.nombreNodoUri = "HashDataInfo";
            this.tipoUri = "uri";
        } else {
            this.nombreNodoUri = "Include";
            this.tipoUri = "URI";
        }
    }

    protected class EstructuraFirma {
        XAdESSchemas esquema;
        Element firma;
        Element signedSignatureProperties;
        Element unsignedSignatureProperties;
        XMLSignature xmlSig;

        protected EstructuraFirma() {
        }
    }
}

