/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos.xades;

import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.XMLDataStringType;
import es.mityc.firmaJava.libreria.xades.elementos.xades.AbstractXADESElement;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractXadesStringElement
extends AbstractXADESElement {
    private XMLDataStringType data;
    private String nameElement;

    public AbstractXadesStringElement(XAdESSchemas schema, String nameElement, String data) {
        super(schema);
        this.nameElement = nameElement;
        this.data = new XMLDataStringType(data);
    }

    public AbstractXadesStringElement(XAdESSchemas schema, String nameElement) {
        super(schema);
        this.nameElement = nameElement;
    }

    protected Element createElement(Document doc) throws InvalidInfoNodeException {
        if (this.data == null) {
            throw new InvalidInfoNodeException("Informaci\u00f3n insuficiente para escribir elemento " + this.nameElement);
        }
        Element res = doc.createElementNS(this.schema.getSchemaUri(), this.namespaceXAdES + ":" + this.nameElement);
        this.data.addContent(res);
        return res;
    }

    public Element createElement(Document doc, String namespaceXAdES) throws InvalidInfoNodeException {
        return super.createElement(doc, namespaceXAdES);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbstractXadesStringElement) {
            AbstractXadesStringElement desc = (AbstractXadesStringElement)obj;
            return this.nameElement.equals(desc.nameElement) && this.data.equals(desc.data);
        }
        return this.data.equals(obj);
    }

    public void load(Element element) throws InvalidInfoNodeException {
        this.checkElementName(element, this.schema.getSchemaUri(), this.nameElement);
        this.data = new XMLDataStringType(null);
        this.data.load(element);
    }

    public void setValue(String value) {
        if (this.data == null) {
            this.data = new XMLDataStringType(value);
        } else {
            this.data.setValue(value);
        }
    }

    public String getValue() {
        if (this.data != null) {
            return this.data.getValue();
        }
        return null;
    }

    public boolean isThisNode(Node node) {
        return this.isElementName(this.nodeToElement(node), this.schema.getSchemaUri(), this.nameElement);
    }
}

