/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos.xades;

import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.AbstractXADESElement;
import es.mityc.firmaJava.libreria.xades.elementos.xades.EncapsulatedX509Certificate;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateValuesType
extends AbstractXADESElement {
    private ArrayList<EncapsulatedX509Certificate> certificates;
    private String id;

    public CertificateValuesType(XAdESSchemas schema) {
        super(schema);
    }

    public CertificateValuesType(XAdESSchemas schema, ArrayList<EncapsulatedX509Certificate> certificates) {
        super(schema);
        this.certificates = certificates;
    }

    public void addEncapsulatedX509Certificate(EncapsulatedX509Certificate certificate) {
        if (this.certificates == null) {
            this.certificates = new ArrayList();
        }
        this.certificates.add(certificate);
    }

    public ArrayList<EncapsulatedX509Certificate> getCertificates() {
        return this.certificates;
    }

    public void setCertificates(ArrayList<EncapsulatedX509Certificate> certificates) {
        this.certificates = certificates;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public EncapsulatedX509Certificate getEncapsulatedX509CertificateById(String id) {
        if (this.certificates != null && id != null) {
            for (EncapsulatedX509Certificate cert : this.certificates) {
                String idCert = cert.getId();
                if (!id.equals(idCert)) continue;
                return cert;
            }
        }
        return null;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CertificateValuesType) {
            CertificateValuesType cvt = (CertificateValuesType)obj;
            ArrayList<EncapsulatedX509Certificate> comp = cvt.certificates;
            if ((this.certificates == null || this.certificates.isEmpty()) && (comp == null || comp.isEmpty())) {
                return true;
            }
            if (this.certificates != null && comp != null && this.certificates.size() == comp.size()) {
                Iterator<EncapsulatedX509Certificate> itThis = this.certificates.iterator();
                Iterator<EncapsulatedX509Certificate> itComp = comp.iterator();
                while (itThis.hasNext()) {
                    if (itThis.next().equals(itComp.next())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void load(Element element) throws InvalidInfoNodeException {
        if (element.hasAttribute("Id")) {
            this.id = element.getAttribute("Id");
        }
        NodeList nodos = element.getChildNodes();
        ArrayList<EncapsulatedX509Certificate> temp = new ArrayList<EncapsulatedX509Certificate>(nodos.getLength());
        for (int i = 0; i < nodos.getLength(); ++i) {
            Node nodo = nodos.item(i);
            if (CertificateValuesType.isDecorationNode(nodo)) continue;
            if (nodo.getNodeType() != 1) {
                throw new InvalidInfoNodeException("Hijo de CertificateValuesType no es un elemento");
            }
            EncapsulatedX509Certificate certificate = new EncapsulatedX509Certificate(this.schema);
            certificate.load((Element)nodo);
            temp.add(certificate);
        }
        this.certificates = temp;
    }

    @Override
    protected void addContent(Element element) throws InvalidInfoNodeException {
        if (this.certificates != null) {
            Iterator<EncapsulatedX509Certificate> it = this.certificates.iterator();
            while (it.hasNext()) {
                element.appendChild(it.next().createElement(element.getOwnerDocument(), this.namespaceXAdES));
            }
        }
        if (this.id != null) {
            element.setAttributeNS(null, "Id", this.id);
        }
    }

    @Override
    public void addContent(Element element, String namespaceXAdES) throws InvalidInfoNodeException {
        super.addContent(element, namespaceXAdES);
    }
}

