/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos.xades;

import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.AbstractXADESElement;
import es.mityc.firmaJava.libreria.xades.elementos.xades.Int;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerListType
extends AbstractXADESElement {
    private ArrayList<Int> ints;

    public IntegerListType(XAdESSchemas schema) {
        super(schema);
    }

    public IntegerListType(XAdESSchemas schema, ArrayList<Int> ints) {
        super(schema);
        this.ints = ints;
    }

    public IntegerListType(XAdESSchemas schema, int[] ints) {
        super(schema);
        if (ints != null) {
            this.ints = new ArrayList(ints.length);
            for (int i = 0; i < ints.length; ++i) {
                this.ints.add(new Int(schema, new BigInteger(Integer.toString(ints[i]))));
            }
        }
    }

    public ArrayList<Int> getInts() {
        return this.ints;
    }

    public void setInts(ArrayList<Int> ints) {
        this.ints = ints;
    }

    public void addInt(BigInteger integer) {
        if (this.ints == null) {
            this.ints = new ArrayList();
        }
        this.ints.add(new Int(this.schema, integer));
    }

    public void addInt(Int integer) {
        if (this.ints == null) {
            this.ints = new ArrayList();
        }
        this.ints.add(integer);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IntegerListType) {
            IntegerListType cvt = (IntegerListType)obj;
            ArrayList<Int> comp = cvt.ints;
            if ((this.ints == null || this.ints.isEmpty()) && (comp == null || comp.isEmpty())) {
                return true;
            }
            if (this.ints != null && comp != null && this.ints.size() == comp.size()) {
                Iterator<Int> itThis = this.ints.iterator();
                Iterator<Int> itComp = comp.iterator();
                while (itThis.hasNext()) {
                    if (itThis.next().equals(itComp.next())) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public void load(Element element) throws InvalidInfoNodeException {
        NodeList nodos = element.getChildNodes();
        ArrayList<Int> temp = new ArrayList<Int>(nodos.getLength());
        for (int i = 0; i < nodos.getLength(); ++i) {
            Node nodo = nodos.item(i);
            if (IntegerListType.isDecorationNode(nodo)) continue;
            if (nodo.getNodeType() != 1) {
                throw new InvalidInfoNodeException("Hijo de CertificateValuesType no es un elemento");
            }
            Int integer = new Int(this.schema);
            integer.load((Element)nodo);
            temp.add(integer);
        }
        this.ints = temp;
    }

    @Override
    public void addContent(Element element, String namespaceXAdES) throws InvalidInfoNodeException {
        super.addContent(element, namespaceXAdES);
    }

    @Override
    protected void addContent(Element element) throws InvalidInfoNodeException {
        if (this.ints != null) {
            Iterator<Int> it = this.ints.iterator();
            while (it.hasNext()) {
                element.appendChild(it.next().createElement(element.getOwnerDocument(), this.namespaceXAdES));
            }
        }
    }
}

