/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos.xades;

import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.AbstractXADESElement;
import es.mityc.firmaJava.libreria.xades.elementos.xades.Description;
import es.mityc.firmaJava.libreria.xades.elementos.xades.DocumentationReferences;
import es.mityc.firmaJava.libreria.xades.elementos.xades.Identifier;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import java.net.URI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ObjectIdentifierType
extends AbstractXADESElement {
    private Identifier identifier;
    private Description description;
    private DocumentationReferences references;

    public ObjectIdentifierType(XAdESSchemas schema, URI uri, String description) {
        super(schema);
        this.identifier = new Identifier(schema, uri);
        if (description != null) {
            this.description = new Description(schema, description);
        }
    }

    public ObjectIdentifierType(XAdESSchemas schema) {
        super(schema);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ObjectIdentifierType) {
            ObjectIdentifierType oit = (ObjectIdentifierType)obj;
            if (this.identifier.equals(oit.identifier)) {
                return true;
            }
        }
        return false;
    }

    public void load(Element element) throws InvalidInfoNodeException {
        Node node = ObjectIdentifierType.getFirstNonvoidNode(element);
        if (node == null || node.getNodeType() != 1) {
            throw new InvalidInfoNodeException("Se esperaba elemento como hijo de ObjectIdentifierType");
        }
        Identifier identifier = new Identifier(this.schema);
        identifier.load((Element)node);
        node = ObjectIdentifierType.getNextNonvoidNode(node);
        Description description = null;
        if (node != null) {
            if (node.getNodeType() != 1) {
                throw new InvalidInfoNodeException("Se esperaba elemento como hijo de ObjectIdentifierType");
            }
            description = new Description(this.schema);
            if (description.isThisNode(node)) {
                description.load((Element)node);
                node = ObjectIdentifierType.getNextNonvoidNode(node);
            }
        }
        DocumentationReferences references = null;
        if (node != null) {
            if (node.getNodeType() != 1) {
                throw new InvalidInfoNodeException("Se esperaba elemento como hijo de ObjectIdentifierType");
            }
            references = new DocumentationReferences(this.schema);
            if (references.isThisNode(node)) {
                references.load((Element)node);
            }
        }
        this.identifier = identifier;
        this.description = description;
        this.references = references;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public Description getDescription() {
        return this.description;
    }

    public void setDescription(Description description) {
        this.description = description;
    }

    public DocumentationReferences getReferences() {
        return this.references;
    }

    public void setReferences(DocumentationReferences references) {
        this.references = references;
    }

    public void addContent(Element element, String namespaceXAdES) throws InvalidInfoNodeException {
        super.addContent(element, namespaceXAdES);
    }

    protected void addContent(Element element) throws InvalidInfoNodeException {
        if (this.identifier == null) {
            throw new InvalidInfoNodeException("Informaci\u00f3n insuficiente para escribir nodo ObjectIdentifierType");
        }
        element.appendChild(this.identifier.createElement(element.getOwnerDocument(), this.namespaceXAdES));
        if (this.description != null) {
            element.appendChild(this.description.createElement(element.getOwnerDocument(), this.namespaceXAdES));
        }
    }
}

