/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.bridge;

import es.mityc.javasign.bridge.ISignFacade;
import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SignFactory {
    private static final Log LOG = LogFactory.getLog(SignFactory.class);
    private static final II18nManager I18N = I18nFactory.getI18nManager("MITyCLibAPI");
    private static SignFactory instance = SignFactory.getInstance();
    private Properties props = null;
    private static final String SIGN_FILE_CONF = "bridge/sign.properties";
    private static final String PROP_FACADE_CLASS = "facade.sign.class";

    private SignFactory() {
        InputStream is = SignFactory.getClassLoader().getResourceAsStream(SIGN_FILE_CONF);
        if (is != null) {
            try {
                this.props = new Properties();
                this.props.load(is);
            }
            catch (IOException ex) {
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.bridge.1"));
            }
        } else {
            LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.bridge.1"));
        }
    }

    private static ClassLoader getClassLoader() {
        try {
            ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    ClassLoader classLoader = null;
                    try {
                        classLoader = Thread.currentThread().getContextClassLoader();
                    }
                    catch (SecurityException securityException) {
                        // empty catch block
                    }
                    return classLoader;
                }
            });
            if (cl != null) {
                return cl;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return SignFactory.class.getClassLoader();
    }

    public static SignFactory getInstance() {
        if (instance == null) {
            instance = new SignFactory();
        }
        return instance;
    }

    public ISignFacade getSignFacade() {
        ISignFacade signFacade;
        block16: {
            signFacade = null;
            if (this.props != null) {
                String classname = this.props.getProperty(PROP_FACADE_CLASS);
                if (classname != null && !"".equals(classname.trim())) {
                    try {
                        ClassLoader cl = SignFactory.getClassLoader();
                        Class<?> classTemp = null;
                        classTemp = cl != null ? cl.loadClass(classname) : Class.forName(classname);
                        if (classTemp != null) {
                            signFacade = (ISignFacade)classTemp.getConstructor(null).newInstance(new Object[0]);
                        }
                        break block16;
                    }
                    catch (InstantiationException ex) {
                        LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.bridge.2"));
                        if (LOG.isDebugEnabled()) {
                            LOG.error((Object)"", (Throwable)ex);
                        }
                        break block16;
                    }
                    catch (InvocationTargetException ex) {
                        LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.bridge.2"));
                        if (LOG.isDebugEnabled()) {
                            LOG.error((Object)"", (Throwable)ex);
                        }
                        break block16;
                    }
                    catch (IllegalAccessException ex) {
                        LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.bridge.3"));
                        if (LOG.isDebugEnabled()) {
                            LOG.error((Object)"", (Throwable)ex);
                        }
                        break block16;
                    }
                    catch (ClassNotFoundException ex) {
                        LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.bridge.4", classname));
                        if (LOG.isDebugEnabled()) {
                            LOG.error((Object)"", (Throwable)ex);
                        }
                        break block16;
                    }
                    catch (ClassCastException ex) {
                        LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.bridge.5"));
                        if (LOG.isDebugEnabled()) {
                            LOG.error((Object)"", (Throwable)ex);
                        }
                        break block16;
                    }
                    catch (NoSuchMethodException ex) {
                        LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.bridge.5"));
                        if (LOG.isDebugEnabled()) {
                            LOG.error((Object)"", (Throwable)ex);
                        }
                        break block16;
                    }
                }
                LOG.error((Object)I18N.getLocalMessage("i18n.mityc.api.bridge.6"));
            }
        }
        return signFacade;
    }
}

