/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.utilidades;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.util.BitSet;
import sun.security.action.GetPropertyAction;

public final class URIEncoder {
    static BitSet dontNeedEncoding;
    static final int caseDiff = 32;
    static String dfltEncName;

    private URIEncoder() {
    }

    @Deprecated
    public static String encode(String s) {
        String str = null;
        try {
            str = URIEncoder.encode(s, dfltEncName);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return str;
    }

    public static String encode(String s, String enc) throws UnsupportedEncodingException {
        boolean needToChange = false;
        boolean wroteUnencodedChar = false;
        int maxBytesPerChar = 10;
        StringBuffer out = new StringBuffer(s.length());
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)buf, enc);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (dontNeedEncoding.get(c)) {
                out.append(c);
                wroteUnencodedChar = true;
                continue;
            }
            try {
                char d;
                if (wroteUnencodedChar) {
                    writer = new OutputStreamWriter((OutputStream)buf, enc);
                    wroteUnencodedChar = false;
                }
                writer.write(c);
                if (c >= '\ud800' && c <= '\udbff' && i + 1 < s.length() && (d = s.charAt(i + 1)) >= '\udc00' && d <= '\udfff') {
                    writer.write(d);
                    ++i;
                }
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.toByteArray();
            for (int j = 0; j < ba.length; ++j) {
                out.append('%');
                char ch = Character.forDigit(ba[j] >> 4 & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
                ch = Character.forDigit(ba[j] & 0xF, 16);
                if (Character.isLetter(ch)) {
                    ch = (char)(ch - 32);
                }
                out.append(ch);
            }
            buf.reset();
            needToChange = true;
        }
        return needToChange ? out.toString() : s;
    }

    public static String relativize(String base, String object) {
        String res = "";
        int i = base.indexOf("/");
        int j = object.indexOf("/");
        int l = 0;
        while (i == j && i >= 0 && object.startsWith(base.substring(0, i))) {
            i = base.indexOf("/", i + 1);
            l = j + 1;
            j = object.indexOf("/", j + 1);
        }
        if (i == -1 && j >= 0) {
            res = res.concat("./");
        }
        while (i >= 0) {
            i = base.indexOf("/", i + 1);
            res = res.concat("../");
        }
        res = res + object.substring(l);
        res = res.replace("./", "");
        return res;
    }

    static {
        int i;
        dfltEncName = null;
        dontNeedEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            dontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            dontNeedEncoding.set(i);
        }
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(33);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(126);
        dontNeedEncoding.set(39);
        dontNeedEncoding.set(40);
        dontNeedEncoding.set(41);
        dontNeedEncoding.set(42);
        dontNeedEncoding.set(44);
        dontNeedEncoding.set(59);
        dontNeedEncoding.set(58);
        dontNeedEncoding.set(36);
        dontNeedEncoding.set(38);
        dontNeedEncoding.set(43);
        dontNeedEncoding.set(61);
        dontNeedEncoding.set(63);
        dontNeedEncoding.set(47);
        dontNeedEncoding.set(91);
        dontNeedEncoding.set(93);
        dontNeedEncoding.set(64);
        dfltEncName = AccessController.doPrivileged(new GetPropertyAction("file.encoding"));
    }
}

