/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos.xades;

import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.AbstractXADESElement;
import es.mityc.firmaJava.libreria.xades.elementos.xades.EncodingEnum;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncapsulatedPKIDataType
extends AbstractXADESElement {
    private String id;
    private EncodingEnum encoding;
    private String value;

    public EncapsulatedPKIDataType(XAdESSchemas schema) {
        super(schema);
    }

    public EncapsulatedPKIDataType(XAdESSchemas schema, String id) {
        super(schema);
        this.id = id;
    }

    public EncapsulatedPKIDataType(XAdESSchemas schema, String id, EncodingEnum encoding) {
        this(schema, id);
        this.encoding = encoding;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public EncodingEnum getEncoding() {
        if (!this.schema.equals(XAdESSchemas.XAdES_111)) {
            return this.encoding;
        }
        return null;
    }

    public void setEncoding(EncodingEnum encoding) {
        this.encoding = encoding;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EncapsulatedPKIDataType) {
            EncapsulatedPKIDataType epdt = (EncapsulatedPKIDataType)obj;
            if (this.value.equals(epdt.value)) {
                return true;
            }
        }
        return false;
    }

    public void addContent(Element element, String namespaceXAdES) throws InvalidInfoNodeException {
        super.addContent(element, namespaceXAdES);
    }

    public void load(Element element) throws InvalidInfoNodeException {
        Node node;
        if (element.hasAttribute("Id")) {
            this.id = element.getAttribute("Id");
        }
        if (element.hasAttribute("Encoding")) {
            if (this.schema.equals(XAdESSchemas.XAdES_111)) {
                throw new InvalidInfoNodeException("Atributo inv\u00e1lido para nodo EncapsulatedPKIDataType en esquema XAdES: " + this.schema.getSchemaUri());
            }
            this.encoding = EncodingEnum.getEncoding(element.getAttribute("Encoding"));
            if (this.encoding == null) {
                throw new InvalidInfoNodeException("Encoding de nodo EncapsulatedPKIDataType desconocido: " + element.getAttribute("Encoding"));
            }
        }
        if ((node = element.getFirstChild()).getNodeType() != 3) {
            throw new InvalidInfoNodeException("Nodo EncapsulatedPKIDataType no contiene CDATA como primer valor");
        }
        this.value = node.getNodeValue();
        if (this.value == null) {
            throw new InvalidInfoNodeException("Contenido de valor de EncapsulatedPKIDataType vac\u00edo");
        }
    }

    protected void addContent(Element element) throws InvalidInfoNodeException {
        if (this.value == null) {
            throw new InvalidInfoNodeException("Informaci\u00f3n insuficiente para escribir nodo EncapsulatedPKIDataType");
        }
        if (this.id != null) {
            element.setAttributeNS(null, "Id", this.id);
        }
        EncodingEnum encoding = this.getEncoding();
        if (!this.schema.equals(XAdESSchemas.XAdES_111) && encoding != null) {
            element.setAttributeNS(null, "Encoding", encoding.getEncodingUri().toString());
        }
        element.setTextContent(this.value);
    }
}

