/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos.xades;

import es.mityc.firmaJava.libreria.utilidades.Base64Coder;
import es.mityc.firmaJava.libreria.xades.XAdESSchemas;
import es.mityc.firmaJava.libreria.xades.elementos.xades.EncapsulatedPKIDataType;
import es.mityc.firmaJava.libreria.xades.elementos.xades.EncodingEnum;
import es.mityc.firmaJava.libreria.xades.errores.InvalidInfoNodeException;
import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncapsulatedX509Certificate
extends EncapsulatedPKIDataType {
    public EncapsulatedX509Certificate(XAdESSchemas schema) {
        super(schema);
    }

    public EncapsulatedX509Certificate(XAdESSchemas schema, String id) {
        super(schema, id);
    }

    public void load(Element element) throws InvalidInfoNodeException {
        X509Certificate cert;
        this.checkElementName(element, this.schema.getSchemaUri(), "EncapsulatedX509Certificate");
        super.load(element);
        EncodingEnum encoding = this.getEncoding();
        if (encoding != null && !encoding.equals((Object)EncodingEnum.DER_ENCODED)) {
            throw new InvalidInfoNodeException("El contenido de EncapsulatedX509Certificate debe estar en la codificaci\u00f3n " + EncodingEnum.DER_ENCODED.getEncodingUri().toString());
        }
        try {
            cert = this.getX509Certificate();
        }
        catch (CertificateException ex) {
            throw new InvalidInfoNodeException("El contenido de EncapsulatedX509Certificate no es un certificado X509 v\u00e1lido", ex);
        }
        if (cert == null) {
            throw new InvalidInfoNodeException("El contenido de EncapsulatedX509Certificate no es un certificado X509 v\u00e1lido");
        }
    }

    public X509Certificate getX509Certificate() throws CertificateException {
        String value = this.getValue();
        if (value != null) {
            byte[] data;
            try {
                data = Base64Coder.decode(value);
            }
            catch (IllegalArgumentException ex) {
                throw new CertificateException("Contenido base64 de EncapsulatedX509Certificate inv\u00e1lido", ex);
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate cert = cf.generateCertificate(bais);
            if (cert instanceof X509Certificate) {
                return (X509Certificate)cert;
            }
            throw new CertificateException("Contenido base64 de EncapsulatedX509Certificate no es un certificado tipo X.509");
        }
        return null;
    }

    public void setX509Certificate(X509Certificate certificate) throws CertificateException {
        this.setValue(new String(Base64Coder.encode(certificate.getEncoded())));
    }

    public boolean isThisNode(Node node) {
        return this.isElementName(this.nodeToElement(node), this.schema.getSchemaUri(), "EncapsulatedX509Certificate");
    }

    public Element createElement(Document doc, String namespaceXAdES) throws InvalidInfoNodeException {
        return super.createElement(doc, namespaceXAdES);
    }

    protected Element createElement(Document doc) throws InvalidInfoNodeException {
        Element res = doc.createElementNS(this.schema.getSchemaUri(), this.namespaceXAdES + ":" + "EncapsulatedX509Certificate");
        super.addContent(res, this.namespaceXAdES);
        return res;
    }
}

