/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.libreria.xades.elementos.xades;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum EncodingEnum {
    DER_ENCODED("http://uri.etsi.org/01903/v1.2.2#DER"),
    BER_ENCODED("http://uri.etsi.org/01903/v1.2.2#BER"),
    CER_ENCODED("http://uri.etsi.org/01903/v1.2.2#CER"),
    PER_ENCODED("http://uri.etsi.org/01903/v1.2.2#PER"),
    XER_ENCODED("http://uri.etsi.org/01903/v1.2.2#XER");

    private static final Log logger;
    private URI uri;

    private EncodingEnum(String uri) {
        try {
            this.uri = new URI(uri);
        }
        catch (URISyntaxException ex) {
            Log logger = LogFactory.getLog(EncodingEnum.class);
            logger.error((Object)"Error creando enumerado de encoding", (Throwable)ex);
        }
    }

    public URI getEncodingUri() {
        return this.uri;
    }

    public static EncodingEnum getEncoding(String uri) {
        try {
            if (uri == null || "".equals(uri.trim())) {
                return DER_ENCODED;
            }
            URI temp = new URI(uri);
            if (temp.equals(EncodingEnum.DER_ENCODED.uri)) {
                return DER_ENCODED;
            }
            if (temp.equals(EncodingEnum.BER_ENCODED.uri)) {
                return BER_ENCODED;
            }
            if (temp.equals(EncodingEnum.CER_ENCODED.uri)) {
                return CER_ENCODED;
            }
            if (temp.equals(EncodingEnum.PER_ENCODED.uri)) {
                return PER_ENCODED;
            }
            if (temp.equals(EncodingEnum.XER_ENCODED.uri)) {
                return XER_ENCODED;
            }
        }
        catch (URISyntaxException ex) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Encoding indicado no es una URI", (Throwable)ex);
            }
            return null;
        }
        return null;
    }

    static {
        logger = LogFactory.getLog(EncodingEnum.class);
    }
}

