/*
 * Decompiled with CFR 0.152.
 */
package com.github.lgooddatepicker.components;

import com.github.lgooddatepicker.components.CalendarPanel;
import com.github.lgooddatepicker.components.DatePicker;
import com.github.lgooddatepicker.optionalusertools.CalendarBorderProperties;
import com.github.lgooddatepicker.optionalusertools.DateHighlightPolicy;
import com.github.lgooddatepicker.optionalusertools.DateInterval;
import com.github.lgooddatepicker.optionalusertools.DateVetoPolicy;
import com.github.lgooddatepicker.optionalusertools.PickerUtilities;
import com.github.lgooddatepicker.zinternaltools.DateVetoPolicyMinimumMaximumDate;
import com.github.lgooddatepicker.zinternaltools.ExtraDateStrings;
import com.github.lgooddatepicker.zinternaltools.InternalConstants;
import com.github.lgooddatepicker.zinternaltools.InternalUtilities;
import com.github.lgooddatepicker.zinternaltools.TranslationSource;
import com.privatejgoodies.forms.layout.ColumnSpec;
import com.privatejgoodies.forms.layout.ConstantSize;
import com.privatejgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.font.TextAttribute;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.time.format.ResolverStyle;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;

public class DatePickerSettings {
    private boolean allowEmptyDates = true;
    private boolean allowKeyboardEditing = true;
    private Border borderCalendarPopup = null;
    private ArrayList<CalendarBorderProperties> borderPropertiesList;
    private Color colorBackgroundWeekdayLabels = new Color(184, 207, 229);
    private Color colorBackgroundWeekNumberLabels = new Color(184, 207, 229);
    private HashMap<DateArea, Color> colors = new HashMap();
    private YearMonth defaultYearMonth = null;
    private boolean enableMonthMenu = true;
    private boolean enableYearMenu = true;
    private DayOfWeek firstDayOfWeek;
    private Font fontCalendarDateLabels;
    private Font fontCalendarWeekdayLabels;
    private Font fontCalendarWeekNumberLabels;
    private Font fontClearLabel;
    private Font fontInvalidDate;
    private Font fontMonthAndYearMenuLabels;
    private Font fontMonthAndYearNavigationButtons;
    private Font fontTodayLabel;
    private Font fontValidDate;
    private Font fontVetoedDate;
    private DateTimeFormatter formatForDatesCommonEraStrict;
    private DateTimeFormatter formatForDatesBeforeCommonEraStrict;
    private DateTimeFormatter formatForTodayButton;
    private ArrayList<DateTimeFormatter> formatsForParsingStrict;
    private Integer gapBeforeButtonPixels = null;
    private DateHighlightPolicy highlightPolicy = null;
    private boolean isVisibleClearButton = true;
    private boolean isVisibleDateTextField = true;
    private boolean isVisibleMonthMenuButton = true;
    private boolean isVisibleNextMonthButton = true;
    private boolean isVisibleNextYearButton = true;
    private boolean isVisiblePreviousMonthButton = true;
    private boolean isVisiblePreviousYearButton = true;
    private boolean isVisibleTodayButton = true;
    private boolean isVisibleYearMenuButton = true;
    private Locale locale;
    private CalendarPanel parentCalendarPanel;
    private DatePicker parentDatePicker;
    private int sizeDatePanelMinimumHeight;
    private int sizeDatePanelMinimumWidth;
    private Integer sizeTextFieldMinimumWidth = null;
    private boolean sizeTextFieldMinimumWidthDefaultOverride = true;
    private String[] translationArrayStandaloneLongMonthNames;
    private String[] translationArrayStandaloneShortMonthNames;
    private String translationClear;
    private String translationToday;
    private DateVetoPolicy vetoPolicy = null;
    private WeekFields weekNumberRules;
    private boolean weekNumbersDisplayed = false;
    private boolean weekNumbersWillOverrideFirstDayOfWeek = true;
    private boolean zSkipDrawIndependentCalendarPanelIfNeeded = false;

    public DatePickerSettings() {
        this(Locale.getDefault());
    }

    public DatePickerSettings(Locale pickerLocale) {
        Font defaultTextFieldFont;
        Font defaultButtonFont;
        Font defaultLabelFont;
        for (DateArea area : DateArea.values()) {
            this.colors.put(area, area.defaultColor);
        }
        this.sizeDatePanelMinimumWidth = 217;
        this.sizeDatePanelMinimumHeight = 133;
        this.fontClearLabel = defaultLabelFont = new JLabel().getFont();
        this.fontCalendarDateLabels = defaultLabelFont;
        this.fontCalendarWeekdayLabels = defaultLabelFont;
        this.fontCalendarWeekNumberLabels = defaultLabelFont;
        this.fontMonthAndYearMenuLabels = defaultLabelFont;
        this.fontTodayLabel = defaultLabelFont;
        this.fontMonthAndYearNavigationButtons = defaultButtonFont = new JButton().getFont();
        this.fontValidDate = defaultTextFieldFont = new JTextField().getFont();
        this.fontInvalidDate = defaultTextFieldFont;
        this.fontVetoedDate = defaultTextFieldFont;
        Map<TextAttribute, ?> attributes = this.fontVetoedDate.getAttributes();
        attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        this.fontVetoedDate = new Font(attributes);
        this.setBorderPropertiesList(null);
        this.setLocale(pickerLocale);
    }

    public DatePickerSettings copySettings() {
        DatePickerSettings result = new DatePickerSettings();
        result.allowEmptyDates = this.allowEmptyDates;
        result.allowKeyboardEditing = this.allowKeyboardEditing;
        if (this.borderPropertiesList == null) {
            result.borderPropertiesList = null;
        } else {
            result.borderPropertiesList = new ArrayList(this.borderPropertiesList.size());
            for (CalendarBorderProperties borderProperty : this.borderPropertiesList) {
                result.borderPropertiesList.add(borderProperty.clone());
            }
        }
        result.colorBackgroundWeekNumberLabels = this.colorBackgroundWeekNumberLabels;
        result.colorBackgroundWeekdayLabels = this.colorBackgroundWeekdayLabels;
        result.colors = this.colors == null ? null : new HashMap<DateArea, Color>(this.colors);
        result.firstDayOfWeek = this.firstDayOfWeek;
        result.fontClearLabel = this.fontClearLabel;
        result.fontCalendarDateLabels = this.fontCalendarDateLabels;
        result.fontCalendarWeekdayLabels = this.fontCalendarWeekdayLabels;
        result.fontCalendarWeekNumberLabels = this.fontCalendarWeekNumberLabels;
        result.fontInvalidDate = this.fontInvalidDate;
        result.fontMonthAndYearMenuLabels = this.fontMonthAndYearMenuLabels;
        result.fontMonthAndYearNavigationButtons = this.fontMonthAndYearNavigationButtons;
        result.fontTodayLabel = this.fontTodayLabel;
        result.fontValidDate = this.fontValidDate;
        result.fontVetoedDate = this.fontVetoedDate;
        result.formatForDatesBeforeCommonEraStrict = this.formatForDatesBeforeCommonEraStrict;
        result.formatForDatesCommonEraStrict = this.formatForDatesCommonEraStrict;
        result.formatForTodayButton = this.formatForTodayButton;
        result.formatsForParsingStrict = this.formatsForParsingStrict == null ? null : (ArrayList)this.formatsForParsingStrict.clone();
        result.gapBeforeButtonPixels = this.gapBeforeButtonPixels;
        result.isVisibleClearButton = this.isVisibleClearButton;
        result.isVisibleDateTextField = this.isVisibleDateTextField;
        result.isVisibleMonthMenuButton = this.isVisibleMonthMenuButton;
        result.isVisibleNextMonthButton = this.isVisibleNextMonthButton;
        result.isVisibleNextYearButton = this.isVisibleNextYearButton;
        result.isVisiblePreviousMonthButton = this.isVisiblePreviousMonthButton;
        result.isVisiblePreviousYearButton = this.isVisiblePreviousYearButton;
        result.isVisibleTodayButton = this.isVisibleTodayButton;
        result.isVisibleYearMenuButton = this.isVisibleYearMenuButton;
        result.locale = (Locale)this.locale.clone();
        result.sizeDatePanelMinimumHeight = this.sizeDatePanelMinimumHeight;
        result.sizeDatePanelMinimumWidth = this.sizeDatePanelMinimumWidth;
        result.sizeTextFieldMinimumWidth = this.sizeTextFieldMinimumWidth;
        result.sizeTextFieldMinimumWidthDefaultOverride = this.sizeTextFieldMinimumWidthDefaultOverride;
        result.translationArrayStandaloneLongMonthNames = (String[])this.translationArrayStandaloneLongMonthNames.clone();
        result.translationArrayStandaloneShortMonthNames = (String[])this.translationArrayStandaloneShortMonthNames.clone();
        result.translationClear = this.translationClear;
        result.translationToday = this.translationToday;
        result.weekNumberRules = this.weekNumberRules;
        result.weekNumbersDisplayed = this.weekNumbersDisplayed;
        result.weekNumbersWillOverrideFirstDayOfWeek = this.weekNumbersWillOverrideFirstDayOfWeek;
        result.zSkipDrawIndependentCalendarPanelIfNeeded = false;
        return result;
    }

    public boolean getAllowEmptyDates() {
        return this.allowEmptyDates;
    }

    public boolean getAllowKeyboardEditing() {
        return this.allowKeyboardEditing;
    }

    public Border getBorderCalendarPopup() {
        return this.borderCalendarPopup;
    }

    public ArrayList<CalendarBorderProperties> getBorderPropertiesList() {
        return this.borderPropertiesList;
    }

    public Color getColor(DateArea area) {
        return this.colors.get((Object)area);
    }

    public Color getColorBackgroundWeekNumberLabels() {
        return this.colorBackgroundWeekNumberLabels;
    }

    public Color getColorBackgroundWeekdayLabels() {
        return this.colorBackgroundWeekdayLabels;
    }

    public DateInterval getDateRangeLimits() {
        DateVetoPolicy policy = this.getVetoPolicy();
        if (policy instanceof DateVetoPolicyMinimumMaximumDate) {
            return ((DateVetoPolicyMinimumMaximumDate)policy).getDateRangeLimits();
        }
        return new DateInterval();
    }

    public YearMonth getDefaultYearMonth() {
        return this.defaultYearMonth;
    }

    public boolean getEnableMonthMenu() {
        return this.enableMonthMenu;
    }

    public boolean getEnableYearMenu() {
        return this.enableYearMenu;
    }

    public DayOfWeek getFirstDayOfWeekDisplayedOnCalendar() {
        if (this.weekNumbersDisplayed && this.weekNumbersWillOverrideFirstDayOfWeek && this.weekNumberRules != null) {
            return this.weekNumberRules.getFirstDayOfWeek();
        }
        return this.firstDayOfWeek;
    }

    public DayOfWeek getFirstDayOfWeekSetting() {
        return this.firstDayOfWeek;
    }

    public Font getFontCalendarDateLabels() {
        return this.fontCalendarDateLabels;
    }

    public Font getFontCalendarWeekNumberLabels() {
        return this.fontCalendarWeekNumberLabels;
    }

    public Font getFontCalendarWeekdayLabels() {
        return this.fontCalendarWeekdayLabels;
    }

    public Font getFontClearLabel() {
        return this.fontClearLabel;
    }

    public Font getFontInvalidDate() {
        return this.fontInvalidDate;
    }

    public Font getFontMonthAndYearMenuLabels() {
        return this.fontMonthAndYearMenuLabels;
    }

    public Font getFontMonthAndYearNavigationButtons() {
        return this.fontMonthAndYearNavigationButtons;
    }

    public Font getFontTodayLabel() {
        return this.fontTodayLabel;
    }

    public Font getFontValidDate() {
        return this.fontValidDate;
    }

    public Font getFontVetoedDate() {
        return this.fontVetoedDate;
    }

    public DateTimeFormatter getFormatForDatesBeforeCommonEra() {
        return this.formatForDatesBeforeCommonEraStrict;
    }

    public DateTimeFormatter getFormatForDatesCommonEra() {
        return this.formatForDatesCommonEraStrict;
    }

    public DateTimeFormatter getFormatForTodayButton() {
        return this.formatForTodayButton;
    }

    public ArrayList<DateTimeFormatter> getFormatsForParsing() {
        return this.formatsForParsingStrict;
    }

    public Integer getGapBeforeButtonPixels() {
        return this.gapBeforeButtonPixels;
    }

    public DateHighlightPolicy getHighlightPolicy() {
        return this.highlightPolicy;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public CalendarPanel getParentCalendarPanel() {
        return this.parentCalendarPanel;
    }

    public DatePicker getParentDatePicker() {
        return this.parentDatePicker;
    }

    public int getSizeDatePanelMinimumHeight() {
        return this.sizeDatePanelMinimumHeight;
    }

    public int getSizeDatePanelMinimumWidth() {
        return this.sizeDatePanelMinimumWidth;
    }

    public Integer getSizeTextFieldMinimumWidth() {
        return this.sizeTextFieldMinimumWidth;
    }

    public boolean getSizeTextFieldMinimumWidthDefaultOverride() {
        return this.sizeTextFieldMinimumWidthDefaultOverride;
    }

    public String[] getTranslationArrayStandaloneLongMonthNames() {
        return this.translationArrayStandaloneLongMonthNames;
    }

    public String[] getTranslationArrayStandaloneShortMonthNames() {
        return this.translationArrayStandaloneShortMonthNames;
    }

    public String getTranslationClear() {
        return this.translationClear;
    }

    public String getTranslationToday() {
        return this.translationToday;
    }

    public DateVetoPolicy getVetoPolicy() {
        return this.vetoPolicy;
    }

    public boolean getVisibleClearButton() {
        return this.isVisibleClearButton;
    }

    public boolean getVisibleDateTextField() {
        return this.isVisibleDateTextField;
    }

    public boolean getVisibleMonthMenuButton() {
        return this.isVisibleMonthMenuButton;
    }

    public boolean getVisibleNextMonthButton() {
        return this.isVisibleNextMonthButton;
    }

    public boolean getVisibleNextYearButton() {
        return this.isVisibleNextYearButton;
    }

    public boolean getVisiblePreviousMonthButton() {
        return this.isVisiblePreviousMonthButton;
    }

    public boolean getVisiblePreviousYearButton() {
        return this.isVisiblePreviousYearButton;
    }

    public boolean getVisibleTodayButton() {
        return this.isVisibleTodayButton;
    }

    public boolean getVisibleYearMenuButton() {
        return this.isVisibleYearMenuButton;
    }

    public WeekFields getWeekNumberRules() {
        return this.weekNumberRules;
    }

    public boolean getWeekNumbersDisplayed() {
        return this.weekNumbersDisplayed;
    }

    public boolean getWeekNumbersWillOverrideFirstDayOfWeek() {
        return this.weekNumbersWillOverrideFirstDayOfWeek;
    }

    public boolean hasParent() {
        boolean hasParentDatePicker = this.parentDatePicker != null;
        boolean hasParentCalendarPanel = this.parentCalendarPanel != null;
        return hasParentDatePicker || hasParentCalendarPanel;
    }

    public boolean isDateAllowed(LocalDate date) {
        if (date == null) {
            return this.allowEmptyDates;
        }
        return !InternalUtilities.isDateVetoed(this.vetoPolicy, date);
    }

    public void setAllowEmptyDates(boolean allowEmptyDates) {
        this.allowEmptyDates = allowEmptyDates;
        if (this.hasParent()) {
            this.zApplyAllowEmptyDates();
        }
    }

    public void setAllowKeyboardEditing(boolean allowKeyboardEditing) {
        this.allowKeyboardEditing = allowKeyboardEditing;
        this.zApplyAllowKeyboardEditing();
    }

    public void setBorderCalendarPopup(Border borderCalendarPopup) {
        this.borderCalendarPopup = borderCalendarPopup;
    }

    public void setBorderPropertiesList(ArrayList<CalendarBorderProperties> borderPropertiesList) {
        if (borderPropertiesList == null) {
            borderPropertiesList = this.zGetDefaultBorderPropertiesList();
        }
        this.borderPropertiesList = borderPropertiesList;
        if (this.parentCalendarPanel != null) {
            this.parentCalendarPanel.zApplyBorderPropertiesList();
        }
    }

    public void setColor(DateArea area, Color color) {
        if (color == null) {
            color = area.defaultColor;
        }
        this.colors.put(area, color);
        switch (area) {
            case BackgroundMonthAndYearMenuLabels: 
            case BackgroundTodayLabel: 
            case BackgroundClearLabel: {
                if (this.parentCalendarPanel == null) break;
                this.parentCalendarPanel.zSetAllLabelIndicatorColorsToDefaultState();
                break;
            }
            default: {
                if (this.parentDatePicker != null) {
                    this.parentDatePicker.zDrawTextFieldIndicators();
                }
                this.zDrawIndependentCalendarPanelIfNeeded();
            }
        }
    }

    public void setColorBackgroundWeekNumberLabels(Color colorBackgroundWeekNumberLabels, boolean applyMatchingDefaultBorders) {
        this.colorBackgroundWeekNumberLabels = colorBackgroundWeekNumberLabels;
        if (applyMatchingDefaultBorders) {
            this.setBorderPropertiesList(null);
        }
        this.zDrawIndependentCalendarPanelIfNeeded();
    }

    public void setColorBackgroundWeekdayLabels(Color colorBackgroundWeekdayLabels, boolean applyMatchingDefaultBorders) {
        this.colorBackgroundWeekdayLabels = colorBackgroundWeekdayLabels;
        if (applyMatchingDefaultBorders) {
            this.setBorderPropertiesList(null);
        }
        this.zDrawIndependentCalendarPanelIfNeeded();
    }

    public boolean setDateRangeLimits(LocalDate firstAllowedDate, LocalDate lastAllowedDate) {
        if (!this.hasParent()) {
            throw new RuntimeException("DatePickerSettings.setDateRangeLimits(), A date range limit can only be set after constructing the parent DatePicker or the parent independent CalendarPanel. (The parent component should be constructed using the DatePickerSettings instance where the date range limits will be applied. The previous sentence is probably simpler than it sounds.)");
        }
        if (firstAllowedDate == null && lastAllowedDate == null) {
            return this.setVetoPolicy(null);
        }
        return this.setVetoPolicy(new DateVetoPolicyMinimumMaximumDate(firstAllowedDate, lastAllowedDate));
    }

    public void setDefaultYearMonth(YearMonth defaultYearMonth) {
        this.defaultYearMonth = defaultYearMonth;
        this.zDrawIndependentCalendarPanelIfNeeded();
    }

    public void setEnableMonthMenu(boolean enableMonthMenu) {
        this.enableMonthMenu = enableMonthMenu;
    }

    public void setEnableYearMenu(boolean enableYearMenu) {
        this.enableYearMenu = enableYearMenu;
    }

    public void setFirstDayOfWeek(DayOfWeek firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
        this.zDrawIndependentCalendarPanelIfNeeded();
    }

    public void setFontCalendarDateLabels(Font fontCalendarDateLabels) {
        this.fontCalendarDateLabels = fontCalendarDateLabels;
        this.zDrawIndependentCalendarPanelIfNeeded();
    }

    public void setFontCalendarWeekNumberLabels(Font fontCalendarWeekNumberLabels) {
        this.fontCalendarWeekNumberLabels = fontCalendarWeekNumberLabels;
        this.zDrawIndependentCalendarPanelIfNeeded();
    }

    public void setFontCalendarWeekdayLabels(Font fontCalendarWeekdayLabels) {
        this.fontCalendarWeekdayLabels = fontCalendarWeekdayLabels;
        this.zDrawIndependentCalendarPanelIfNeeded();
    }

    public void setFontClearLabel(Font fontClearLabel) {
        this.fontClearLabel = fontClearLabel;
        this.zDrawIndependentCalendarPanelIfNeeded();
    }

    public void setFontInvalidDate(Font fontInvalidDate) {
        this.fontInvalidDate = fontInvalidDate;
    }

    public void setFontMonthAndYearMenuLabels(Font fontMonthAndYearMenuLabels) {
        this.fontMonthAndYearMenuLabels = fontMonthAndYearMenuLabels;
        this.zDrawIndependentCalendarPanelIfNeeded();
    }

    public void setFontMonthAndYearNavigationButtons(Font fontMonthAndYearNavigationButtons) {
        this.fontMonthAndYearNavigationButtons = fontMonthAndYearNavigationButtons;
        this.zDrawIndependentCalendarPanelIfNeeded();
    }

    public void setFontTodayLabel(Font fontTodayLabel) {
        this.fontTodayLabel = fontTodayLabel;
        this.zDrawIndependentCalendarPanelIfNeeded();
    }

    public void setFontValidDate(Font fontValidDate) {
        this.fontValidDate = fontValidDate;
        if (this.parentDatePicker != null) {
            this.parentDatePicker.zSetAppropriateTextFieldMinimumWidth();
        }
    }

    public void setFontVetoedDate(Font fontVetoedDate) {
        this.fontVetoedDate = fontVetoedDate;
    }

    public void setFormatForDatesBeforeCommonEra(DateTimeFormatter formatForDatesBeforeCommonEra) {
        this.formatForDatesBeforeCommonEraStrict = formatForDatesBeforeCommonEra.withResolverStyle(ResolverStyle.STRICT);
        if (this.parentDatePicker != null) {
            this.parentDatePicker.setTextFieldToValidStateIfNeeded();
        }
    }

    public void setFormatForDatesBeforeCommonEra(String patternString) {
        DateTimeFormatter formatter = PickerUtilities.createFormatterFromPatternString(patternString, this.getLocale());
        this.setFormatForDatesBeforeCommonEra(formatter);
    }

    public void setFormatForDatesCommonEra(DateTimeFormatter formatForDatesCommonEra) {
        this.formatForDatesCommonEraStrict = formatForDatesCommonEra.withResolverStyle(ResolverStyle.STRICT);
        if (this.parentDatePicker != null) {
            this.parentDatePicker.setTextFieldToValidStateIfNeeded();
        }
        if (this.parentDatePicker != null) {
            this.parentDatePicker.zSetAppropriateTextFieldMinimumWidth();
        }
    }

    public void setFormatForDatesCommonEra(String patternString) {
        DateTimeFormatter formatter = PickerUtilities.createFormatterFromPatternString(patternString, this.getLocale());
        this.setFormatForDatesCommonEra(formatter);
    }

    public void setFormatForTodayButton(DateTimeFormatter formatForTodayButton) {
        this.formatForTodayButton = formatForTodayButton;
        this.zDrawIndependentCalendarPanelIfNeeded();
    }

    public void setFormatsForParsing(ArrayList<DateTimeFormatter> formatsForParsing) {
        this.formatsForParsingStrict = new ArrayList();
        for (DateTimeFormatter format : formatsForParsing) {
            this.formatsForParsingStrict.add(format.withResolverStyle(ResolverStyle.STRICT));
        }
    }

    public void setGapBeforeButtonPixels(Integer gapBeforeButtonPixels) {
        this.gapBeforeButtonPixels = gapBeforeButtonPixels;
        if (this.parentDatePicker != null) {
            this.zApplyGapBeforeButtonPixels();
        }
    }

    public void setHighlightPolicy(DateHighlightPolicy highlightPolicy) {
        this.highlightPolicy = highlightPolicy;
        this.zDrawIndependentCalendarPanelIfNeeded();
    }

    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ("hi".equals(locale.getLanguage()) && locale.getCountry().isEmpty()) {
            locale = new Locale("hi", "IN");
        }
        this.locale = locale;
        this.zSkipDrawIndependentCalendarPanelIfNeeded = true;
        WeekFields localeWeekFields = WeekFields.of(locale);
        this.setWeekNumberRules(localeWeekFields);
        String todayTranslation = TranslationSource.getTranslation(locale, "today", "Today");
        this.setTranslationToday(todayTranslation);
        String clearTranslation = TranslationSource.getTranslation(locale, "clear", "Clear");
        this.setTranslationClear(clearTranslation);
        String[] standaloneLongMonthNames = ExtraDateStrings.getDefaultStandaloneLongMonthNamesForLocale(locale);
        this.setTranslationArrayStandaloneLongMonthNames(standaloneLongMonthNames);
        String[] standaloneShortMonthNames = ExtraDateStrings.getDefaultStandaloneShortMonthNamesForLocale(locale);
        this.setTranslationArrayStandaloneShortMonthNames(standaloneShortMonthNames);
        DateTimeFormatter formatForToday = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(locale);
        this.setFormatForTodayButton(formatForToday);
        DateTimeFormatter formatForDatesCE = InternalUtilities.generateDefaultFormatterCE(locale);
        this.setFormatForDatesCommonEra(formatForDatesCE);
        DateTimeFormatter formatForDatesBCE = InternalUtilities.generateDefaultFormatterBCE(locale);
        this.setFormatForDatesBeforeCommonEra(formatForDatesBCE);
        FormatStyle[] allFormatStyles = new FormatStyle[]{FormatStyle.SHORT, FormatStyle.MEDIUM, FormatStyle.LONG, FormatStyle.FULL};
        ArrayList<DateTimeFormatter> parsingFormats = new ArrayList<DateTimeFormatter>();
        for (int i = 0; i < allFormatStyles.length; ++i) {
            DateTimeFormatter parseFormat = new DateTimeFormatterBuilder().parseLenient().parseCaseInsensitive().appendLocalized(allFormatStyles[i], null).toFormatter(locale);
            parsingFormats.add(parseFormat);
        }
        ArrayList<DateTimeFormatter> extraFormatters = ExtraDateStrings.getExtraParsingFormatsForLocale(locale);
        parsingFormats.addAll(extraFormatters);
        this.setFormatsForParsing(parsingFormats);
        DayOfWeek firstDayOfWeekDefault = WeekFields.of(locale).getFirstDayOfWeek();
        this.setFirstDayOfWeek(firstDayOfWeekDefault);
        this.zSkipDrawIndependentCalendarPanelIfNeeded = false;
        this.zDrawIndependentCalendarPanelIfNeeded();
        this.zDrawDatePickerTextFieldIfNeeded();
    }

    public void setSizeDatePanelMinimumHeight(int sizeDatePanelMinimumHeight) {
        this.sizeDatePanelMinimumHeight = sizeDatePanelMinimumHeight;
        this.zDrawIndependentCalendarPanelIfNeeded();
    }

    public void setSizeDatePanelMinimumWidth(int sizeDatePanelMinimumWidth) {
        this.sizeDatePanelMinimumWidth = sizeDatePanelMinimumWidth;
        this.zDrawIndependentCalendarPanelIfNeeded();
    }

    public void setSizeTextFieldMinimumWidth(Integer minimumWidthInPixels) {
        this.sizeTextFieldMinimumWidth = minimumWidthInPixels;
        if (this.parentDatePicker != null) {
            this.parentDatePicker.zSetAppropriateTextFieldMinimumWidth();
        }
    }

    public void setSizeTextFieldMinimumWidthDefaultOverride(boolean defaultShouldOverrideIfNeeded) {
        this.sizeTextFieldMinimumWidthDefaultOverride = defaultShouldOverrideIfNeeded;
        if (this.parentDatePicker != null) {
            this.parentDatePicker.zSetAppropriateTextFieldMinimumWidth();
        }
    }

    public void setTranslationArrayStandaloneLongMonthNames(String[] newTranslationArray) {
        if (newTranslationArray == null) {
            String[] defaultLongMonthNames = ExtraDateStrings.getDefaultStandaloneLongMonthNamesForLocale(this.locale);
            this.translationArrayStandaloneLongMonthNames = defaultLongMonthNames;
        } else {
            this.translationArrayStandaloneLongMonthNames = newTranslationArray;
        }
        this.zDrawIndependentCalendarPanelIfNeeded();
    }

    public void setTranslationArrayStandaloneShortMonthNames(String[] newTranslationArray) {
        if (newTranslationArray == null) {
            String[] defaultShortMonthNames = ExtraDateStrings.getDefaultStandaloneShortMonthNamesForLocale(this.locale);
            this.translationArrayStandaloneShortMonthNames = defaultShortMonthNames;
        } else {
            this.translationArrayStandaloneShortMonthNames = newTranslationArray;
        }
        this.zDrawIndependentCalendarPanelIfNeeded();
    }

    public void setTranslationClear(String translationClear) {
        this.translationClear = translationClear;
        this.zDrawIndependentCalendarPanelIfNeeded();
    }

    public void setTranslationToday(String translationToday) {
        this.translationToday = translationToday;
        this.zDrawIndependentCalendarPanelIfNeeded();
    }

    public boolean setVetoPolicy(DateVetoPolicy vetoPolicy) {
        if (!this.hasParent()) {
            throw new RuntimeException("DatePickerSettings.setVetoPolicy(), A veto policy can only be set after constructing the parent DatePicker or the parent independent CalendarPanel. (The parent component should be constructed using the DatePickerSettings instance where the veto policy will be applied. The previous sentence is probably simpler than it sounds.)");
        }
        this.vetoPolicy = vetoPolicy;
        this.zDrawIndependentCalendarPanelIfNeeded();
        LocalDate parentDate = this.zGetParentSelectedDate();
        return this.isDateAllowed(parentDate);
    }

    public void setVisibleDateTextField(boolean isVisible) {
        this.isVisibleDateTextField = isVisible;
        if (this.parentDatePicker != null) {
            this.parentDatePicker.zApplyVisibilityOfComponents();
        }
    }

    public void setVisibleClearButton(boolean isVisible) {
        this.isVisibleClearButton = isVisible;
        this.zApplyIndependentCalendarPanelButtonVisibilityIfNeeded();
    }

    public void setVisibleMonthMenuButton(boolean isVisible) {
        this.isVisibleMonthMenuButton = isVisible;
        this.zApplyIndependentCalendarPanelButtonVisibilityIfNeeded();
    }

    public void setVisibleNextMonthButton(boolean isVisible) {
        this.isVisibleNextMonthButton = isVisible;
        this.zApplyIndependentCalendarPanelButtonVisibilityIfNeeded();
    }

    public void setVisibleNextYearButton(boolean isVisible) {
        this.isVisibleNextYearButton = isVisible;
        this.zApplyIndependentCalendarPanelButtonVisibilityIfNeeded();
    }

    public void setVisiblePreviousMonthButton(boolean isVisible) {
        this.isVisiblePreviousMonthButton = isVisible;
        this.zApplyIndependentCalendarPanelButtonVisibilityIfNeeded();
    }

    public void setVisiblePreviousYearButton(boolean isVisible) {
        this.isVisiblePreviousYearButton = isVisible;
        this.zApplyIndependentCalendarPanelButtonVisibilityIfNeeded();
    }

    public void setVisibleTodayButton(boolean isVisible) {
        this.isVisibleTodayButton = isVisible;
        this.zApplyIndependentCalendarPanelButtonVisibilityIfNeeded();
    }

    public void setVisibleYearMenuButton(boolean isVisible) {
        this.isVisibleYearMenuButton = isVisible;
        this.zApplyIndependentCalendarPanelButtonVisibilityIfNeeded();
    }

    public void setWeekNumberRules(WeekFields weekNumberRules) {
        if (weekNumberRules == null) {
            weekNumberRules = WeekFields.of(this.locale);
        }
        this.weekNumberRules = weekNumberRules;
        this.zDrawIndependentCalendarPanelIfNeeded();
    }

    public void setWeekNumbersDisplayed(boolean weekNumbersDisplayed, boolean applyMatchingDefaultBorders) {
        this.weekNumbersDisplayed = weekNumbersDisplayed;
        if (applyMatchingDefaultBorders) {
            this.setBorderPropertiesList(null);
        }
        this.zDrawIndependentCalendarPanelIfNeeded();
    }

    public void setWeekNumbersWillOverrideFirstDayOfWeek(boolean weekNumbersWillOverrideFirstDayOfWeek) {
        this.weekNumbersWillOverrideFirstDayOfWeek = weekNumbersWillOverrideFirstDayOfWeek;
        this.zDrawIndependentCalendarPanelIfNeeded();
    }

    void zApplyAllowEmptyDates() {
        if (!this.hasParent()) {
            return;
        }
        LocalDate selectedDate = this.zGetParentSelectedDate();
        if (!this.allowEmptyDates && selectedDate == null) {
            LocalDate today = LocalDate.now();
            if (InternalUtilities.isDateVetoed(this.vetoPolicy, today)) {
                throw new RuntimeException("Exception in DatePickerSettings.zApplyAllowEmptyDates(), Could not initialize a null date to today, because today is vetoed by the veto policy. To prevent this exception, always call setAllowEmptyDates() -before- setting a veto policy.");
            }
            this.zSetParentSelectedDate(today);
        }
    }

    void zApplyAllowKeyboardEditing() {
        if (this.parentDatePicker == null) {
            return;
        }
        this.parentDatePicker.getComponentDateTextField().setEditable(this.allowKeyboardEditing);
        Color textFieldBorderColor = this.allowKeyboardEditing ? InternalConstants.colorEditableTextFieldBorder : InternalConstants.colorNotEditableTextFieldBorder;
        this.parentDatePicker.getComponentDateTextField().setBorder(new CompoundBorder(new MatteBorder(1, 1, 1, 1, textFieldBorderColor), new EmptyBorder(1, 3, 2, 2)));
    }

    void zApplyGapBeforeButtonPixels() {
        int gapPixels = this.gapBeforeButtonPixels == null ? 3 : this.gapBeforeButtonPixels;
        ConstantSize gapSizeObject = new ConstantSize(gapPixels, ConstantSize.PIXEL);
        ColumnSpec columnSpec = ColumnSpec.createGap(gapSizeObject);
        FormLayout layout = (FormLayout)this.parentDatePicker.getLayout();
        layout.setColumnSpec(2, columnSpec);
    }

    private void zApplyIndependentCalendarPanelButtonVisibilityIfNeeded() {
        if (this.parentCalendarPanel != null) {
            this.parentCalendarPanel.zApplyVisibilityOfButtons();
        }
    }

    void zDrawDatePickerTextFieldIfNeeded() {
        if (this.parentDatePicker != null) {
            this.parentDatePicker.setTextFieldToValidStateIfNeeded();
        }
    }

    private void zDrawIndependentCalendarPanelIfNeeded() {
        if (this.zSkipDrawIndependentCalendarPanelIfNeeded) {
            return;
        }
        if (this.parentCalendarPanel != null) {
            this.parentCalendarPanel.drawCalendar();
        }
    }

    private LocalDate zGetParentSelectedDate() {
        if (!this.hasParent()) {
            return null;
        }
        boolean useDatePicker = this.parentDatePicker != null;
        return useDatePicker ? this.parentDatePicker.getDate() : this.parentCalendarPanel.getSelectedDate();
    }

    private ArrayList<CalendarBorderProperties> zGetDefaultBorderPropertiesList() {
        ArrayList<CalendarBorderProperties> results = new ArrayList<CalendarBorderProperties>();
        Color defaultDateBoxBorderColor = new Color(99, 130, 191);
        Color defaultWeekdayEndcapsBorderColor = this.colorBackgroundWeekdayLabels;
        Color defaultWeekNumberEndcapsBorderColor = this.colorBackgroundWeekNumberLabels;
        CalendarBorderProperties dateBoxBorderProperties = new CalendarBorderProperties(new Point(3, 3), new Point(5, 5), defaultDateBoxBorderColor, 1);
        results.add(dateBoxBorderProperties);
        CalendarBorderProperties weekdayLabelBorderProperties = new CalendarBorderProperties(new Point(3, 2), new Point(5, 2), defaultWeekdayEndcapsBorderColor, 1);
        results.add(weekdayLabelBorderProperties);
        CalendarBorderProperties weekNumberBorderProperties = new CalendarBorderProperties(new Point(2, 3), new Point(2, 5), defaultWeekNumberEndcapsBorderColor, 1);
        results.add(weekNumberBorderProperties);
        return results;
    }

    YearMonth zGetDefaultYearMonthAsUsed() {
        return this.defaultYearMonth == null ? YearMonth.now() : this.defaultYearMonth;
    }

    void zSetParentCalendarPanel(CalendarPanel parentCalendarPanel) {
        if (this.hasParent()) {
            throw new RuntimeException("DatePickerSettings.setParentCalendarPanel(), A DatePickerSettings instance can only be used as the settings for one parent object. (Settings instances cannot be reused for multiple DatePickers, multiple independent CalendarPanels, or for combinations of both. )");
        }
        this.parentCalendarPanel = parentCalendarPanel;
    }

    void zSetParentDatePicker(DatePicker parentDatePicker) {
        if (this.hasParent()) {
            throw new RuntimeException("DatePickerSettings.setParentCalendarPanel(), A DatePickerSettings instance can only be used as the settings for one parent object. (Settings instances cannot be reused for multiple DatePickers, multiple independent CalendarPanels, or for combinations of both.)");
        }
        this.parentDatePicker = parentDatePicker;
    }

    private void zSetParentSelectedDate(LocalDate dateValue) {
        if (this.parentDatePicker != null) {
            this.parentDatePicker.setDate(dateValue);
        }
        if (this.parentCalendarPanel != null) {
            this.parentCalendarPanel.setSelectedDate(dateValue);
        }
    }

    public static enum DateArea {
        BackgroundClearLabel(new Color(240, 240, 240)),
        BackgroundMonthAndYearMenuLabels(new Color(240, 240, 240)),
        BackgroundMonthAndYearNavigationButtons(new JButton().getBackground()),
        BackgroundOverallCalendarPanel(new Color(240, 240, 240)),
        BackgroundTodayLabel(new Color(240, 240, 240)),
        BackgroundTopLeftLabelAboveWeekNumbers(new Color(184, 207, 229)),
        CalendarBackgroundNormalDates(Color.white),
        CalendarBackgroundSelectedDate(new Color(163, 184, 204)),
        CalendarBackgroundVetoedDates(Color.lightGray),
        CalendarBorderSelectedDate(new Color(99, 130, 191)),
        CalendarDefaultBackgroundHighlightedDates(Color.green),
        CalendarDefaultTextHighlightedDates(Color.black),
        CalendarTextNormalDates(Color.black),
        CalendarTextWeekdays(Color.black),
        CalendarTextWeekNumbers(Color.black),
        TextClearLabel(new JLabel().getForeground()),
        TextMonthAndYearMenuLabels(new JLabel().getForeground()),
        TextMonthAndYearNavigationButtons(new JButton().getForeground()),
        TextTodayLabel(new JLabel().getForeground()),
        TextFieldBackgroundDisallowedEmptyDate(Color.pink),
        TextFieldBackgroundInvalidDate(Color.white),
        TextFieldBackgroundValidDate(Color.white),
        TextFieldBackgroundVetoedDate(Color.white),
        DatePickerTextInvalidDate(Color.red),
        DatePickerTextValidDate(Color.black),
        DatePickerTextVetoedDate(Color.black);

        public Color defaultColor;

        private DateArea(Color defaultColor) {
            this.defaultColor = defaultColor;
        }
    }
}

