/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.certificate.ocsp;

import es.mityc.firmaJava.ocsp.OCSPCliente;
import es.mityc.firmaJava.ocsp.RespuestaOCSP;
import es.mityc.firmaJava.ocsp.exception.OCSPClienteException;
import es.mityc.firmaJava.ocsp.exception.OCSPProxyException;
import es.mityc.javasign.certificate.CertStatusException;
import es.mityc.javasign.certificate.ICertStatus;
import es.mityc.javasign.certificate.ICertStatusRecoverer;
import es.mityc.javasign.certificate.ocsp.OCSPStatus;
import es.mityc.javasign.trust.TrustAbstract;
import es.mityc.javasign.trust.UnknownTrustException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCSPLiveConsultant
implements ICertStatusRecoverer {
    private String servidorOCSP;
    private TrustAbstract validadorConfianza;

    public OCSPLiveConsultant(String hostOCSPResponder, TrustAbstract truster) {
        this.servidorOCSP = hostOCSPResponder;
        this.validadorConfianza = truster;
    }

    public List<ICertStatus> getCertStatus(List<X509Certificate> certList) throws CertStatusException {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public ICertStatus getCertStatus(X509Certificate cert) throws CertStatusException {
        OCSPCliente ocspCliente = null;
        OCSPStatus bloque = null;
        RespuestaOCSP respuesta = null;
        try {
            ocspCliente = new OCSPCliente(this.servidorOCSP);
            CertPath certPath = this.validadorConfianza.getCertPath(cert);
            List<? extends Certificate> certificates = certPath.getCertificates();
            X509Certificate issuerCertificate = certificates.size() > 1 ? (X509Certificate)certificates.get(1) : (X509Certificate)certificates.get(0);
            respuesta = ocspCliente.validateCert(cert, issuerCertificate);
        }
        catch (OCSPClienteException ex) {
            throw new CertStatusException(ex.getMessage(), (Throwable)ex);
        }
        catch (OCSPProxyException ex) {
            throw new CertStatusException(ex.getMessage(), (Throwable)ex);
        }
        catch (UnknownTrustException ex) {
            throw new CertStatusException(ex.getMessage(), (Throwable)ex);
        }
        bloque = new OCSPStatus(respuesta, cert);
        return bloque;
    }

    public List<ICertStatus> getCertChainStatus(X509Certificate cert) throws CertStatusException {
        OCSPCliente ocspCliente = null;
        ArrayList<ICertStatus> result = new ArrayList<ICertStatus>();
        try {
            ocspCliente = new OCSPCliente(this.servidorOCSP);
            CertPath certPath = this.validadorConfianza.getCertPath(cert);
            List<? extends Certificate> certificates = certPath.getCertificates();
            int certificatesSize = certificates.size();
            for (int i = 0; i < certificatesSize; ++i) {
                X509Certificate certificateToValidate = (X509Certificate)certificates.get(i);
                X509Certificate issuerCertificate = i == certificatesSize - 1 ? (X509Certificate)certificates.get(i) : (X509Certificate)certificates.get(i + 1);
                RespuestaOCSP respuesta = ocspCliente.validateCert(certificateToValidate, issuerCertificate);
                OCSPStatus bloque = new OCSPStatus(respuesta, certificateToValidate);
                result.add((ICertStatus)bloque);
            }
        }
        catch (OCSPClienteException ex) {
            throw new CertStatusException(ex.getMessage(), (Throwable)ex);
        }
        catch (OCSPProxyException ex) {
            throw new CertStatusException(ex.getMessage(), (Throwable)ex);
        }
        catch (UnknownTrustException ex) {
            throw new CertStatusException(ex.getMessage(), (Throwable)ex);
        }
        return result;
    }

    public List<List<ICertStatus>> getCertChainStatus(List<X509Certificate> certs) throws CertStatusException {
        throw new UnsupportedOperationException("Not Supported Operation");
    }
}

