/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.certificate.ocsp;

import es.mityc.firmaJava.ocsp.RespuestaOCSP;
import es.mityc.javasign.certificate.AbstractCertStatus;
import es.mityc.javasign.certificate.ICertStatus;
import es.mityc.javasign.certificate.IOCSPCertStatus;
import es.mityc.javasign.certificate.RevokedInfo;
import java.security.cert.X509Certificate;
import java.util.Date;

public class OCSPStatus
extends AbstractCertStatus
implements IOCSPCertStatus {
    private byte[] respOCSP = null;
    private Date dateResponse = null;
    private String responderID = null;
    private IOCSPCertStatus.TYPE_RESPONDER responderType;

    public OCSPStatus(RespuestaOCSP resp, X509Certificate cert) {
        this.setRespOCSP(resp.getRespuestaEncoded());
        this.setRespondeDate(resp.getTiempoRespuesta());
        this.setResponder(resp.getValorResponder(), resp.getTipoResponder());
        if (resp.getNroRespuesta() == 0) {
            this.setCertStatus(ICertStatus.CERT_STATUS.valid);
        } else if (resp.getNroRespuesta() == 1) {
            this.setCertStatus(ICertStatus.CERT_STATUS.revoked);
            this.setRevokedInfo(new RevokedInfo(null, resp.getFechaRevocacion()));
        } else {
            this.setCertStatus(ICertStatus.CERT_STATUS.unknown);
        }
        this.setCertificate(cert);
    }

    private void setRespOCSP(byte[] binary) {
        this.respOCSP = binary != null ? (byte[])binary.clone() : null;
    }

    private void setResponder(String id, IOCSPCertStatus.TYPE_RESPONDER tipoResponder) {
        this.responderID = new String(id);
        this.responderType = tipoResponder;
    }

    private void setRespondeDate(Date date) {
        this.dateResponse = (Date)date.clone();
    }

    public String getResponderID() {
        return this.responderID != null ? new String(this.responderID) : null;
    }

    public IOCSPCertStatus.TYPE_RESPONDER getResponderType() {
        return this.responderType;
    }

    public Date getResponseDate() {
        return this.dateResponse != null ? (Date)this.dateResponse.clone() : null;
    }

    public byte[] getEncoded() {
        return this.respOCSP;
    }
}

