/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.io;

import es.mityc.javasign.io.DecodingException;
import es.mityc.javasign.io.IDecoder;

public class Base64Decoder
implements IDecoder {
    private static final int BASE64_CHUNK_LENGTH = 4;
    private static final int BASE64_CHUNK_DECODED_LENGTH = 3;
    private byte[] buffer;
    private byte[] remaining;
    private boolean countMode;
    private long count = 0L;
    private static final byte[] BASE64_TO_INT = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, -1, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};

    public Base64Decoder() {
        this(false);
    }

    public Base64Decoder(boolean onlyCountMode) {
        this.countMode = onlyCountMode;
    }

    public void reset() {
        this.count = 0L;
    }

    public long getCount() {
        return this.count;
    }

    public void addInput(byte[] data, int pos, int len) {
        int totalLen = len + (this.buffer != null ? this.buffer.length : 0) + (this.remaining != null ? this.remaining.length : 0);
        byte[] temp = new byte[totalLen];
        int off = 0;
        if (this.remaining != null) {
            System.arraycopy(this.remaining, 0, temp, 0, this.remaining.length);
            off += this.remaining.length;
        }
        if (this.buffer != null) {
            System.arraycopy(this.buffer, 0, temp, off, this.buffer.length);
            off += this.buffer.length;
        }
        System.arraycopy(data, pos, temp, off, len);
        this.buffer = temp;
        this.remaining = null;
    }

    public int decode(byte[] data, int off, int len) throws DecodingException {
        if (off < 0 || len < 0 || off > data.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (len < 3) {
            throw new DecodingException("Buffer too small, minimum size = 3");
        }
        int res = 0;
        if (this.buffer != null) {
            String s = new String(this.buffer).replace("\r\n", "").replace(" ", "");
            if (s.length() % 4 != 0) {
                this.remaining = s.substring(s.length() - s.length() % 4).getBytes();
                s = s.substring(0, s.length() - s.length() % 4);
            } else {
                this.remaining = null;
            }
            int len64 = s.length() * 3 / 4;
            if (s.endsWith("==")) {
                len64 -= 2;
            } else if (s.endsWith("=")) {
                --len64;
            }
            int actualLen = len;
            if (actualLen < len64) {
                actualLen -= actualLen % 3;
                this.buffer = s.substring(actualLen * 4 / 3).getBytes();
                s = s.substring(0, actualLen * 4 / 3 - 1);
            } else {
                this.buffer = null;
            }
            if (!this.countMode) {
                res = Base64Decoder.base64ToByteArray(s, data, off);
                this.count += (long)res;
            } else {
                this.count += (long)(s.length() * 3 / 4);
            }
        }
        return res;
    }

    private static int base64ToByteArray(String s, byte[] data, int off) {
        int sLen = s.length();
        int numGroups = sLen / 4;
        if (4 * numGroups != sLen) {
            throw new IllegalArgumentException("String length must be a multiple of four.");
        }
        int missingBytesInLastGroup = 0;
        int numFullGroups = numGroups;
        if (sLen != 0) {
            if (s.charAt(sLen - 1) == '=') {
                ++missingBytesInLastGroup;
                --numFullGroups;
            }
            if (s.charAt(sLen - 2) == '=') {
                ++missingBytesInLastGroup;
            }
        }
        int inCursor = 0;
        int outCursor = off;
        for (int i = 0; i < numFullGroups; ++i) {
            int ch0 = Base64Decoder.base64toInt(s.charAt(inCursor++), BASE64_TO_INT);
            int ch1 = Base64Decoder.base64toInt(s.charAt(inCursor++), BASE64_TO_INT);
            int ch2 = Base64Decoder.base64toInt(s.charAt(inCursor++), BASE64_TO_INT);
            int ch3 = Base64Decoder.base64toInt(s.charAt(inCursor++), BASE64_TO_INT);
            data[outCursor++] = (byte)(ch0 << 2 | ch1 >> 4);
            data[outCursor++] = (byte)(ch1 << 4 | ch2 >> 2);
            data[outCursor++] = (byte)(ch2 << 6 | ch3);
        }
        if (missingBytesInLastGroup != 0) {
            int ch0 = Base64Decoder.base64toInt(s.charAt(inCursor++), BASE64_TO_INT);
            int ch1 = Base64Decoder.base64toInt(s.charAt(inCursor++), BASE64_TO_INT);
            data[outCursor++] = (byte)(ch0 << 2 | ch1 >> 4);
            if (missingBytesInLastGroup == 1) {
                int ch2 = Base64Decoder.base64toInt(s.charAt(inCursor++), BASE64_TO_INT);
                data[outCursor++] = (byte)(ch1 << 4 | ch2 >> 2);
            }
        }
        return outCursor - off;
    }

    private static int base64toInt(char c, byte[] alphaToInt) {
        byte result = alphaToInt[c];
        if (result < 0) {
            throw new IllegalArgumentException("Illegal character " + c);
        }
        return result;
    }

    public boolean needsInput() {
        return this.buffer == null;
    }

    public boolean isIncomplete() {
        return this.remaining != null || this.buffer != null;
    }
}

