/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.javasign.pkstore.pkcs11;

import es.mityc.javasign.i18n.I18nFactory;
import es.mityc.javasign.i18n.II18nManager;
import es.mityc.javasign.pkstore.pkcs11.IModuleData;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigMultiPKCS11 {
    private ArrayList<IModuleData> providers = new ArrayList();
    private static final II18nManager I18N = I18nFactory.getI18nManager((String)"MITyCLibCert");
    private static final String MODULE_CLASS = "es.mityc.javasign.pkstore.pkcs11.SunP11ModuleData";
    private static final String SUN_CLASS = "sun.security.pkcs11.SunPKCS11";

    public void addSunProvider(String name, String lib) throws NoSuchProviderException {
        this.testSunPKCS11Library();
        this.providers.add(this.getSunP11ModuleData(name, lib));
    }

    private IModuleData getSunP11ModuleData(String name, String lib) throws NoSuchProviderException {
        try {
            Class<?> prov = Class.forName(MODULE_CLASS);
            Constructor<?> constructor = prov.getConstructor(String.class, String.class);
            return (IModuleData)constructor.newInstance(name, lib);
        }
        catch (ClassNotFoundException ex) {
            throw new NoSuchProviderException(I18N.getLocalMessage("i18n.mityc.cert.p11.16", new Object[]{ex.getMessage()}));
        }
        catch (SecurityException ex) {
            throw new NoSuchProviderException(I18N.getLocalMessage("i18n.mityc.cert.p11.16", new Object[]{ex.getMessage()}));
        }
        catch (NoSuchMethodException ex) {
            throw new NoSuchProviderException(I18N.getLocalMessage("i18n.mityc.cert.p11.16", new Object[]{ex.getMessage()}));
        }
        catch (IllegalArgumentException ex) {
            throw new NoSuchProviderException(I18N.getLocalMessage("i18n.mityc.cert.p11.16", new Object[]{ex.getMessage()}));
        }
        catch (InstantiationException ex) {
            throw new NoSuchProviderException(I18N.getLocalMessage("i18n.mityc.cert.p11.16", new Object[]{ex.getMessage()}));
        }
        catch (IllegalAccessException ex) {
            throw new NoSuchProviderException(I18N.getLocalMessage("i18n.mityc.cert.p11.16", new Object[]{ex.getMessage()}));
        }
        catch (InvocationTargetException ex) {
            throw new NoSuchProviderException(I18N.getLocalMessage("i18n.mityc.cert.p11.16", new Object[]{ex.getMessage()}));
        }
    }

    public void testSunPKCS11Library() throws NoSuchProviderException {
        try {
            Class<?> prov = Class.forName(SUN_CLASS);
            if (prov == null) {
                throw new NoSuchProviderException(I18N.getLocalMessage("i18n.mityc.cert.p11.16", new Object[]{I18N.getLocalMessage("i18n.mityc.cert.p11.17")}));
            }
        }
        catch (ClassNotFoundException ex) {
            throw new NoSuchProviderException(I18N.getLocalMessage("i18n.mityc.cert.p11.16", new Object[]{ex.getMessage()}));
        }
    }

    protected List<IModuleData> getProviders() {
        return this.providers;
    }
}

