/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.ocsp;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import org.apache.commons.httpclient.NTCredentials;

public class AuthenticatorProxyCredentials
extends NTCredentials {
    protected PasswordAuthentication pa = null;

    public AuthenticatorProxyCredentials(String host, String domain) {
        super("username", "password", host, domain);
    }

    private void refreshAuthenticator() {
        String proxyHost = System.getProperty("http.proxyHost");
        int proxyPort = 80;
        try {
            proxyPort = Integer.parseInt(System.getProperty("http.proxyPort"));
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        try {
            this.pa = Authenticator.requestPasswordAuthentication(proxyHost, null, proxyPort, "HTTP", "", "http", null, Authenticator.RequestorType.PROXY);
        }
        catch (SecurityException ex) {
            this.pa = null;
        }
    }

    public String getUserName() {
        this.refreshAuthenticator();
        if (this.pa == null) {
            return super.getUserName();
        }
        return this.pa.getUserName();
    }

    public String getPassword() {
        if (this.pa == null) {
            this.refreshAuthenticator();
        }
        if (this.pa == null) {
            return super.getPassword();
        }
        return new String(this.pa.getPassword());
    }
}

