/*
 * Decompiled with CFR 0.152.
 */
package es.mityc.firmaJava.ocsp;

import es.mityc.firmaJava.ocsp.AuthenticatorProxyCredentials;
import es.mityc.firmaJava.ocsp.Base64Coder;
import es.mityc.firmaJava.ocsp.I18n;
import es.mityc.firmaJava.ocsp.RespuestaOCSP;
import es.mityc.firmaJava.ocsp.config.ConfigProveedores;
import es.mityc.firmaJava.ocsp.config.ServidorOcsp;
import es.mityc.firmaJava.ocsp.exception.OCSPClienteException;
import es.mityc.firmaJava.ocsp.exception.OCSPProxyException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ocsp.ResponderID;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.ocsp.BasicOCSPResp;
import org.bouncycastle.ocsp.CertificateID;
import org.bouncycastle.ocsp.OCSPException;
import org.bouncycastle.ocsp.OCSPReq;
import org.bouncycastle.ocsp.OCSPReqGenerator;
import org.bouncycastle.ocsp.OCSPResp;
import org.bouncycastle.ocsp.RevokedStatus;
import org.bouncycastle.ocsp.SingleResp;
import org.bouncycastle.ocsp.UnknownStatus;

public class OCSPCliente {
    private static final Integer INT_5000 = new Integer(5000);
    private String servidorURL;
    static Log log = LogFactory.getLog(OCSPCliente.class);

    public OCSPCliente(String servidorURL) {
        this.servidorURL = servidorURL;
    }

    public RespuestaOCSP validateCert(X509Certificate certificadoUsuario, X509Certificate certificadoEmisor) throws OCSPClienteException, OCSPProxyException {
        RespuestaOCSP respuesta = new RespuestaOCSP();
        Security.addProvider((Provider)new BouncyCastleProvider());
        OCSPReqGenerator generadorPeticion = new OCSPReqGenerator();
        OCSPReq peticionOCSP = null;
        OCSPResp respuestaOCSP = null;
        CertificateID certificadoId = null;
        try {
            certificadoId = new CertificateID("1.3.14.3.2.26", certificadoEmisor, certificadoUsuario.getSerialNumber());
            log.info((Object)"Creado identificador \u00fanico de certificado a validar.");
        }
        catch (OCSPException e) {
            log.info((Object)("Error al generar el identificador unico del certificado de usuario: " + e.getMessage()));
            throw new OCSPClienteException(I18n.getResource("libreriaocsp.error2") + ": " + e.getMessage());
        }
        generadorPeticion.addRequest(certificadoId);
        try {
            peticionOCSP = generadorPeticion.generate();
            log.info((Object)"Petici\u00f3n OCSP generada.");
        }
        catch (OCSPException e) {
            log.error((Object)("Error al generar la petici\u00f3n OCSP: " + e.getMessage()));
            throw new OCSPClienteException(I18n.getResource("libreriaocsp.error3") + ": " + e.getMessage());
        }
        HttpClient cliente = new HttpClient();
        cliente.getParams().setParameter("http.socket.timeout", (Object)INT_5000);
        String servidorProxy = System.getProperty("http.proxyHost");
        if (servidorProxy != null) {
            int puertoProxy = 80;
            try {
                puertoProxy = Integer.parseInt(System.getProperty("http.proxyPort"));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            cliente.getHostConfiguration().setProxy(servidorProxy, puertoProxy);
            AuthenticatorProxyCredentials defaultcreds = new AuthenticatorProxyCredentials(servidorProxy, "");
            cliente.getState().setProxyCredentials(AuthScope.ANY, (Credentials)defaultcreds);
        }
        if (this.servidorURL == null || "".equals(this.servidorURL.trim()) || this.servidorURL.trim().equalsIgnoreCase("MULTIPLE")) {
            ServidorOcsp servidor = ConfigProveedores.getServidor(certificadoUsuario);
            if (null != servidor) {
                this.servidorURL = servidor.getUrl().toString();
                log.debug((Object)("Servidor OCSP encontrado " + this.servidorURL));
            } else {
                log.error((Object)I18n.getResource("libreriaocsp.error12"));
                this.servidorURL = "";
                throw new OCSPClienteException(I18n.getResource("libreriaocsp.error12"));
            }
        }
        PostMethod metodo = new PostMethod(this.servidorURL);
        metodo.addRequestHeader("Content-Type", "application/ocsp-request");
        ByteArrayInputStream datos = null;
        try {
            datos = new ByteArrayInputStream(peticionOCSP.getEncoded());
        }
        catch (IOException e) {
            log.error((Object)("Error al leer la petici\u00f3n: " + e.getMessage()));
            throw new OCSPClienteException(I18n.getResource("libreriaocsp.error4") + ": " + e.getMessage());
        }
        InputStreamRequestEntity rq = new InputStreamRequestEntity((InputStream)datos);
        metodo.setRequestEntity((RequestEntity)rq);
        metodo.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        try {
            int estadoCodigo = cliente.executeMethod((HttpMethod)metodo);
            log.info((Object)"Petici\u00f3n enviada.");
            if (estadoCodigo != 200) {
                if (estadoCodigo == 407) {
                    throw new OCSPProxyException("Autenticaci\u00f3n fallida en el proxy");
                }
                if (estadoCodigo == 305) {
                    throw new OCSPProxyException("Debe configurar su proxy para poder realizar la consulta");
                }
                log.error((Object)("Fallo la ejecuci\u00f3n del m\u00e9todo: " + metodo.getStatusLine()));
                throw new OCSPClienteException(I18n.getResource("libreriaocsp.error9") + ": " + metodo.getStatusLine());
            }
            byte[] cuerpoRespuesta = metodo.getResponseBody();
            log.info((Object)"Respuesta obtenida.");
            try {
                respuestaOCSP = new OCSPResp(cuerpoRespuesta);
            }
            catch (IOException e) {
                log.error((Object)("Error en la secuencia de bytes de respuesta: " + e.getMessage()));
                throw new OCSPClienteException(I18n.getResource("libreriaocsp.error5") + ": " + e.getMessage());
            }
            OCSPCliente.processResponse(respuestaOCSP, respuesta, certificadoId);
        }
        catch (HttpException e) {
            log.error((Object)("Violaci\u00f3n del protocolo HTTP: " + e.getMessage()));
            throw new OCSPClienteException(I18n.getResource("libreriaocsp.error7") + ": " + e.getMessage());
        }
        catch (IOException e) {
            String mensajeError = I18n.getResource("libreriaocsp.error10") + ": " + this.servidorURL;
            log.error((Object)("Error en la conexi\u00f3n con el servidor OCSP: " + e.getMessage()));
            throw new OCSPClienteException(mensajeError);
        }
        finally {
            Security.removeProvider("BC");
            metodo.releaseConnection();
        }
        return respuesta;
    }

    public static void processResponse(OCSPResp inResp, RespuestaOCSP outResp, CertificateID certID) throws OCSPClienteException, IOException {
        outResp.setRespuesta(inResp);
        if (inResp.getStatus() != 0) {
            log.info((Object)"OCSPResponseStatus: not successful.");
            switch (inResp.getStatus()) {
                case 1: {
                    log.warn((Object)"OCSPResponseStatus: malformedRequest.");
                    outResp.setNroRespuesta(4);
                    outResp.setMensajeRespuesta(I18n.getResource("libreriaocsp.respuesta1"));
                    break;
                }
                case 2: {
                    log.warn((Object)"OCSPResponseStatus: internalError.");
                    outResp.setNroRespuesta(5);
                    outResp.setMensajeRespuesta(I18n.getResource("libreriaocsp.respuesta2"));
                    break;
                }
                case 3: {
                    log.warn((Object)"OCSPResponseStatus: tryLater.");
                    outResp.setNroRespuesta(6);
                    outResp.setMensajeRespuesta(I18n.getResource("libreriaocsp.respuesta3"));
                    break;
                }
                case 5: {
                    log.warn((Object)"OCSPResponseStatus: sigRequired.");
                    outResp.setNroRespuesta(7);
                    outResp.setMensajeRespuesta(I18n.getResource("libreriaocsp.respuesta4"));
                    break;
                }
                case 6: {
                    log.warn((Object)"OCSPResponseStatus: unauthorized.");
                    outResp.setNroRespuesta(8);
                    outResp.setMensajeRespuesta(I18n.getResource("libreriaocsp.respuesta5"));
                }
            }
        } else {
            try {
                log.info((Object)"OCSPResponseStatus: successful.");
                BasicOCSPResp respuestaBasica = (BasicOCSPResp)inResp.getResponseObject();
                try {
                    X509Certificate[] certs = respuestaBasica.getCerts("SUN");
                    if (certs != null && certs.length > 0) {
                        ArrayList<X509Certificate> list = new ArrayList<X509Certificate>(certs.length);
                        for (int i = 0; i < certs.length; ++i) {
                            list.add(certs[i]);
                        }
                        outResp.setOCSPSigner(list);
                    }
                }
                catch (NoSuchProviderException e) {
                    log.info((Object)e.getMessage(), (Throwable)e);
                }
                catch (OCSPException e) {
                    log.info((Object)e.getMessage(), (Throwable)e);
                }
                SingleResp[] arrayRespuestaBasica = respuestaBasica.getResponses();
                outResp.setTiempoRespuesta(respuestaBasica.getProducedAt());
                ResponderID respID = respuestaBasica.getResponderId().toASN1Object();
                outResp.setResponder(respID);
                StringBuffer mensaje = new StringBuffer("Se recibi\u00f3 un estado no definido: ");
                boolean finded = false;
                for (int i = 0; i < arrayRespuestaBasica.length; ++i) {
                    SingleResp sr = arrayRespuestaBasica[i];
                    if (!certID.equals((Object)sr.getCertID())) continue;
                    finded = true;
                    Object certStatus = arrayRespuestaBasica[i].getCertStatus();
                    if (certStatus == null) {
                        log.info((Object)"Estado del certificado: Good.");
                        outResp.setNroRespuesta(0);
                        outResp.setMensajeRespuesta(new String(Base64Coder.encode(inResp.getEncoded())));
                        continue;
                    }
                    if (certStatus instanceof RevokedStatus) {
                        log.info((Object)"Estado del certificado: Revoked.");
                        outResp.setFechaRevocacion(((RevokedStatus)certStatus).getRevocationTime());
                        outResp.setNroRespuesta(1);
                        RevokedStatus revoked = (RevokedStatus)certStatus;
                        if (revoked.hasRevocationReason()) {
                            switch (revoked.getRevocationReason()) {
                                case 1: {
                                    outResp.setMensajeRespuesta(I18n.getResource("libreriaocsp.razonrevocacion1"));
                                    break;
                                }
                                case 2: {
                                    outResp.setMensajeRespuesta(I18n.getResource("libreriaocsp.razonrevocacion2"));
                                    break;
                                }
                                case 3: {
                                    outResp.setMensajeRespuesta(I18n.getResource("libreriaocsp.razonrevocacion3"));
                                    break;
                                }
                                case 4: {
                                    outResp.setMensajeRespuesta(I18n.getResource("libreriaocsp.razonrevocacion4"));
                                    break;
                                }
                                case 5: {
                                    outResp.setMensajeRespuesta(I18n.getResource("libreriaocsp.razonrevocacion5"));
                                    break;
                                }
                                case 6: {
                                    outResp.setMensajeRespuesta(I18n.getResource("libreriaocsp.razonrevocacion6"));
                                    break;
                                }
                                default: {
                                    outResp.setMensajeRespuesta("");
                                    break;
                                }
                            }
                            continue;
                        }
                        outResp.setMensajeRespuesta("");
                        continue;
                    }
                    if (certStatus instanceof UnknownStatus) {
                        log.info((Object)"Estado del certificado: Unknown.");
                        outResp.setNroRespuesta(2);
                        outResp.setMensajeRespuesta("El servidor ha respondido que el estado del certificado es desconocido");
                        continue;
                    }
                    mensaje.append(arrayRespuestaBasica[i].getCertStatus().getClass().getName());
                    log.info((Object)mensaje.toString());
                    outResp.setNroRespuesta(3);
                    outResp.setMensajeRespuesta(arrayRespuestaBasica[i].getCertStatus().getClass().getName());
                }
                if (!finded) {
                    log.info((Object)"Estado del certificado: Unknown.");
                    outResp.setNroRespuesta(2);
                    outResp.setMensajeRespuesta("El servidor ha respondido que el estado del certificado es desconocido");
                }
            }
            catch (OCSPException e) {
                log.error((Object)("Error al instanciar la respuesta OCSP b\u00e1sica: " + e.getMessage()));
                throw new OCSPClienteException(I18n.getResource("libreriaocsp.error6") + ": " + e.getMessage());
            }
        }
    }
}

