/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import java.io.IOException;
import java.io.StringReader;

public class RFC2253Parser {
    static boolean _TOXML = true;
    static int counter = 0;

    public static String rfc2253toXMLdsig(String dn) {
        _TOXML = true;
        String normalized = RFC2253Parser.normalize(dn);
        return RFC2253Parser.rfctoXML(normalized);
    }

    public static String xmldsigtoRFC2253(String dn) {
        _TOXML = false;
        String normalized = RFC2253Parser.normalize(dn);
        return RFC2253Parser.xmltoRFC(normalized);
    }

    public static String normalize(String dn) {
        if (dn == null || dn.equals("")) {
            return "";
        }
        try {
            int k;
            String _DN = RFC2253Parser.semicolonToComma(dn);
            StringBuffer sb = new StringBuffer();
            int i = 0;
            int l = 0;
            int j = 0;
            while ((k = _DN.indexOf(",", j)) >= 0) {
                if (k > 0 && _DN.charAt(k - 1) != '\\' && (l += RFC2253Parser.countQuotes(_DN, j, k)) % 2 != 1) {
                    sb.append(RFC2253Parser.parseRDN(_DN.substring(i, k).trim()) + ",");
                    i = k + 1;
                    l = 0;
                }
                j = k + 1;
            }
            sb.append(RFC2253Parser.parseRDN(RFC2253Parser.trim(_DN.substring(i))));
            return sb.toString();
        }
        catch (IOException ex) {
            return dn;
        }
    }

    static String parseRDN(String str) throws IOException {
        int k;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int l = 0;
        int j = 0;
        while ((k = str.indexOf("+", j)) >= 0) {
            if (k > 0 && str.charAt(k - 1) != '\\' && (l += RFC2253Parser.countQuotes(str, j, k)) % 2 != 1) {
                sb.append(RFC2253Parser.parseATAV(RFC2253Parser.trim(str.substring(i, k))) + "+");
                i = k + 1;
                l = 0;
            }
            j = k + 1;
        }
        sb.append(RFC2253Parser.parseATAV(RFC2253Parser.trim(str.substring(i))));
        return sb.toString();
    }

    static String parseATAV(String str) throws IOException {
        int i = str.indexOf("=");
        if (i == -1 || i > 0 && str.charAt(i - 1) == '\\') {
            return str;
        }
        String attrType = RFC2253Parser.normalizeAT(str.substring(0, i));
        String attrValue = null;
        attrValue = attrType.charAt(0) >= '0' && attrType.charAt(0) <= '9' ? str.substring(i + 1) : RFC2253Parser.normalizeV(str.substring(i + 1));
        return attrType + "=" + attrValue;
    }

    static String normalizeAT(String str) {
        String at = str.toUpperCase().trim();
        if (at.startsWith("OID")) {
            at = at.substring(3);
        }
        return at;
    }

    static String normalizeV(String str) throws IOException {
        String value = RFC2253Parser.trim(str);
        if (value.startsWith("\"")) {
            StringBuffer sb = new StringBuffer();
            StringReader sr = new StringReader(value.substring(1, value.length() - 1));
            int i = 0;
            while ((i = sr.read()) > -1) {
                char c = (char)i;
                if (c == ',' || c == '=' || c == '+' || c == '<' || c == '>' || c == '#' || c == ';') {
                    sb.append('\\');
                }
                sb.append(c);
            }
            value = RFC2253Parser.trim(sb.toString());
        }
        if (_TOXML) {
            if (value.startsWith("#")) {
                value = '\\' + value;
            }
        } else if (value.startsWith("\\#")) {
            value = value.substring(1);
        }
        return value;
    }

    static String rfctoXML(String string) {
        try {
            String s = RFC2253Parser.changeLess32toXML(string);
            return RFC2253Parser.changeWStoXML(s);
        }
        catch (Exception e) {
            return string;
        }
    }

    static String xmltoRFC(String string) {
        try {
            String s = RFC2253Parser.changeLess32toRFC(string);
            return RFC2253Parser.changeWStoRFC(s);
        }
        catch (Exception e) {
            return string;
        }
    }

    static String changeLess32toRFC(String string) throws IOException {
        StringBuffer sb = new StringBuffer();
        StringReader sr = new StringReader(string);
        int i = 0;
        while ((i = sr.read()) > -1) {
            char c = (char)i;
            if (c == '\\') {
                sb.append(c);
                char c1 = (char)sr.read();
                char c2 = (char)sr.read();
                if ((c1 >= '0' && c1 <= '9' || c1 >= 'A' && c1 <= 'F' || c1 >= 'a' && c1 <= 'f') && (c2 >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F' || c2 >= 'a' && c2 <= 'f')) {
                    char ch = (char)Byte.parseByte("" + c1 + c2, 16);
                    sb.append(ch);
                    continue;
                }
                sb.append(c1);
                sb.append(c2);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static String changeLess32toXML(String string) throws IOException {
        StringBuffer sb = new StringBuffer();
        StringReader sr = new StringReader(string);
        int i = 0;
        while ((i = sr.read()) > -1) {
            if (i < 32) {
                sb.append('\\');
                sb.append(Integer.toHexString(i));
                continue;
            }
            sb.append((char)i);
        }
        return sb.toString();
    }

    static String changeWStoXML(String string) throws IOException {
        StringBuffer sb = new StringBuffer();
        StringReader sr = new StringReader(string);
        int i = 0;
        while ((i = sr.read()) > -1) {
            char c = (char)i;
            if (c == '\\') {
                char c1 = (char)sr.read();
                if (c1 == ' ') {
                    sb.append('\\');
                    String s = "20";
                    sb.append(s);
                    continue;
                }
                sb.append('\\');
                sb.append(c1);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    static String changeWStoRFC(String string) {
        int k;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int j = 0;
        while ((k = string.indexOf("\\20", j)) >= 0) {
            sb.append(RFC2253Parser.trim(string.substring(i, k)) + "\\ ");
            i = k + 3;
            j = k + 3;
        }
        sb.append(string.substring(i));
        return sb.toString();
    }

    static String semicolonToComma(String str) {
        return RFC2253Parser.removeWSandReplace(str, ";", ",");
    }

    static String removeWhiteSpace(String str, String symbol) {
        return RFC2253Parser.removeWSandReplace(str, symbol, symbol);
    }

    static String removeWSandReplace(String str, String symbol, String replace) {
        int k;
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int l = 0;
        int j = 0;
        while ((k = str.indexOf(symbol, j)) >= 0) {
            if (k > 0 && str.charAt(k - 1) != '\\' && (l += RFC2253Parser.countQuotes(str, j, k)) % 2 != 1) {
                sb.append(RFC2253Parser.trim(str.substring(i, k)) + replace);
                i = k + 1;
                l = 0;
            }
            j = k + 1;
        }
        sb.append(RFC2253Parser.trim(str.substring(i)));
        return sb.toString();
    }

    private static int countQuotes(String s, int i, int j) {
        int k = 0;
        for (int l = i; l < j; ++l) {
            if (s.charAt(l) != '\"') continue;
            ++k;
        }
        return k;
    }

    static String trim(String str) {
        String trimed = str.trim();
        int i = str.indexOf(trimed) + trimed.length();
        if (str.length() > i && trimed.endsWith("\\") && !trimed.endsWith("\\\\") && str.charAt(i) == ' ') {
            trimed = trimed + " ";
        }
        return trimed;
    }

    public static void main(String[] args) throws Exception {
        RFC2253Parser.testToXML("CN=\"Steve, Kille\",  O=Isode Limited, C=GB");
        RFC2253Parser.testToXML("CN=Steve Kille    ,   O=Isode Limited,C=GB");
        RFC2253Parser.testToXML("\\ OU=Sales+CN=J. Smith,O=Widget Inc.,C=US\\ \\ ");
        RFC2253Parser.testToXML("CN=L. Eagle,O=Sue\\, Grabbit and Runn,C=GB");
        RFC2253Parser.testToXML("CN=Before\\0DAfter,O=Test,C=GB");
        RFC2253Parser.testToXML("CN=\"L. Eagle,O=Sue, = + < > # ;Grabbit and Runn\",C=GB");
        RFC2253Parser.testToXML("1.3.6.1.4.1.1466.0=#04024869,O=Test,C=GB");
        StringBuffer sb = new StringBuffer();
        sb.append('L');
        sb.append('u');
        sb.append('\uc48d');
        sb.append('i');
        sb.append('\uc487');
        String test7 = "SN=" + sb.toString();
        RFC2253Parser.testToXML(test7);
        RFC2253Parser.testToRFC("CN=\"Steve, Kille\",  O=Isode Limited, C=GB");
        RFC2253Parser.testToRFC("CN=Steve Kille    ,   O=Isode Limited,C=GB");
        RFC2253Parser.testToRFC("\\20OU=Sales+CN=J. Smith,O=Widget Inc.,C=US\\20\\20 ");
        RFC2253Parser.testToRFC("CN=L. Eagle,O=Sue\\, Grabbit and Runn,C=GB");
        RFC2253Parser.testToRFC("CN=Before\\12After,O=Test,C=GB");
        RFC2253Parser.testToRFC("CN=\"L. Eagle,O=Sue, = + < > # ;Grabbit and Runn\",C=GB");
        RFC2253Parser.testToRFC("1.3.6.1.4.1.1466.0=\\#04024869,O=Test,C=GB");
        sb = new StringBuffer();
        sb.append('L');
        sb.append('u');
        sb.append('\uc48d');
        sb.append('i');
        sb.append('\uc487');
        test7 = "SN=" + sb.toString();
        RFC2253Parser.testToRFC(test7);
    }

    static void testToXML(String st) {
        System.out.println("start " + counter++ + ": " + st);
        System.out.println("         " + RFC2253Parser.rfc2253toXMLdsig(st));
        System.out.println("");
    }

    static void testToRFC(String st) {
        System.out.println("start " + counter++ + ": " + st);
        System.out.println("         " + RFC2253Parser.xmldsigtoRFC2253(st));
        System.out.println("");
    }
}

